/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpAsgnOrNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OpAsgnOrNode(ISourcePosition position, Node headNode, Node valueNode) {
        super(position);
        assert (headNode != null) : "headNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.firstNode = headNode;
        this.secondNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNORNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnOrNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String def;
        try {
            context.setWithinDefined(true);
            def = this.firstNode.definition(runtime2, context, self, aBlock);
        }
        finally {
            context.setWithinDefined(false);
        }
        IRubyObject result = runtime2.getNil();
        if (def != null) {
            result = this.firstNode.interpret(runtime2, context, self, aBlock);
        }
        if (!result.isTrue()) {
            result = this.secondNode.interpret(runtime2, context, self, aBlock);
        }
        return ASTInterpreter.pollAndReturn(context, result);
    }
}

