/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class Constant
extends AbstractVariable {
    private boolean initialized = false;

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        String pattern = "[A-Z]([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
        if (name2.matches(pattern)) {
            return new Constant(runtime2, name2, javaObject);
        }
        return null;
    }

    private Constant(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    Constant(String name2, IRubyObject irubyObject) {
        super(name2, irubyObject);
    }

    void markInitialized() {
        this.initialized = true;
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        if (receiver2 == null) {
            receiver2 = runtime2.getTopSelf();
        }
        Collection<String> names2 = receiver2.getMetaClass().getConstantNames();
        for (String name2 : names2) {
            BiVariable var;
            IRubyObject value2 = receiver2.getMetaClass().getConstant(name2);
            if (vars.containsKey(name2)) {
                var = vars.getVariable(name2);
                var.setRubyObject(value2);
                continue;
            }
            var = new Constant(name2, value2);
            ((Constant)var).markInitialized();
            vars.update(name2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.Constant;
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        if (this.initialized) {
            return;
        }
        RubyModule rubyClass = this.getRubyClass(runtime2);
        if (rubyClass != null) {
            rubyClass.setConstant(this.name, this.irubyObject);
        } else {
            RubyModule module = runtime2.getCurrentContext().getRubyClass();
            module.setConstant(this.name, this.irubyObject);
        }
        this.initialized = true;
    }

    public void remove(Ruby runtime2) {
    }
}

