/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jffi.CallbackMarshaller;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

final class CallbackMethodWithBlock
extends DynamicMethod {
    private final ParameterMarshaller[] marshallers;
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final int cbindex;

    public CallbackMethodWithBlock(RubyModule implementationClass, Function function, FunctionInvoker functionInvoker, ParameterMarshaller[] marshallers, int cbindex) {
        super(implementationClass, Visibility.PUBLIC, CallConfiguration.FrameFullScopeFull);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
        this.cbindex = cbindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        boolean blockGiven = block.isGiven();
        Arity.checkArgumentCount(context.getRuntime(), args2, this.marshallers.length - (blockGiven ? 1 : 0), this.marshallers.length);
        Invocation invocation = new Invocation(context);
        try {
            int i;
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
            if (!blockGiven) {
                for (i = 0; i < args2.length; ++i) {
                    this.marshallers[i].marshal(invocation, (InvocationBuffer)buffer, args2[i]);
                }
            } else {
                for (i = 0; i < this.cbindex; ++i) {
                    this.marshallers[i].marshal(invocation, (InvocationBuffer)buffer, args2[i]);
                }
                ((CallbackMarshaller)this.marshallers[this.cbindex]).marshal(invocation, (InvocationBuffer)buffer, block);
                for (i = this.cbindex + 1; i < this.marshallers.length; ++i) {
                    this.marshallers[i].marshal(invocation, (InvocationBuffer)buffer, args2[i - 1]);
                }
            }
            IRubyObject iRubyObject = this.functionInvoker.invoke(context.getRuntime(), this.function, buffer);
            return iRubyObject;
        }
        finally {
            invocation.finish();
        }
    }

    public DynamicMethod dup() {
        return this;
    }

    public Arity getArity() {
        return Arity.fixed(this.marshallers.length);
    }

    public boolean isNative() {
        return true;
    }
}

