/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints.infrastructure;

import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;

public class Utilities {
    private static final String DEFAULT_NAME = "name";

    public static CsmClass extractEnclosingClass(CsmContext csmContext) {
        CsmFunction csmFunction;
        if (csmContext == null) {
            return null;
        }
        CsmClass csmClass = csmContext.getEnclosingClass();
        if (csmClass == null && (csmFunction = csmContext.getEnclosingFunction()) != null && CsmKindUtilities.isMethod((CsmObject)csmFunction)) {
            csmClass = ((CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)csmFunction)).getContainingClass();
        }
        return csmClass;
    }

    public static String guessName(CsmContext csmContext) {
        CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(csmContext.getFile(), csmContext.getStartOffset());
        if (csmReference != null) {
            return ((Object)csmReference.getText()).toString();
        }
        return DEFAULT_NAME;
    }

    private static String guessLiteralName(String string) {
        if (string.length() == 0) {
            return DEFAULT_NAME;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = string.charAt(0);
        if (CndLexerUtilities.isCppIdentifierStart((char)string.charAt(0))) {
            stringBuilder.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ') {
                stringBuilder.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(c2)) {
                stringBuilder.append(c2);
            }
            if (i > 40) break;
        }
        if (stringBuilder.length() == 0) {
            return DEFAULT_NAME;
        }
        return stringBuilder.toString();
    }

    public static String getName(CsmType csmType) {
        if (CsmKindUtilities.isBuiltIn((CsmObject)csmType)) {
            return "" + Character.toLowerCase(csmType.getClassifierText().charAt(0));
        }
        return Utilities.firstToLower(((Object)csmType.getClassifierText()).toString());
    }

    public static String getName(CsmContext csmContext) {
        CsmReferenceContext csmReferenceContext = null;
        return Utilities.getName(csmReferenceContext);
    }

    public static String getName(CsmReferenceContext csmReferenceContext) {
        return Utilities.adjustName(Utilities.getNameRaw(csmReferenceContext));
    }

    private static String getNameRaw(CsmReferenceContext csmReferenceContext) {
        if (csmReferenceContext == null) {
            return null;
        }
        return ((Object)csmReferenceContext.getReference().getText()).toString();
    }

    static String adjustName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        }
        if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Utilities.firstToLower(string2);
        }
        if (Utilities.isKeyword(string)) {
            return "a" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private static String firstToLower(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        if (Utilities.isKeyword(string2)) {
            string2 = "a" + string;
        }
        return string2;
    }

    private static boolean isKeyword(String string) {
        return true;
    }
}

