/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceFieldPanel;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceKind;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceMethodPanel;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceVariablePanel;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceHint {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<CppTokenId> WHITESPACES = EnumSet.of(CppTokenId.WHITESPACE, new CppTokenId[]{CppTokenId.NEW_LINE, CppTokenId.ESCAPED_LINE, CppTokenId.ESCAPED_WHITESPACE, CppTokenId.BLOCK_COMMENT, CppTokenId.LINE_COMMENT, CppTokenId.DOXYGEN_COMMENT, CppTokenId.DOXYGEN_LINE_COMMENT});

    static int[] ignoreWhitespaces(CsmContext csmContext, int n, int n2) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)csmContext.getDocument(), (int)n, (boolean)true, (boolean)false);
        if (tokenSequence == null) {
            return new int[]{n, n2};
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            boolean bl = true;
            while (WHITESPACES.contains(tokenSequence.token().id()) && (bl = tokenSequence.moveNext())) {
            }
            if (bl && tokenSequence.offset() > n) {
                n = tokenSequence.offset();
            }
        }
        tokenSequence.move(n2);
        while (tokenSequence.movePrevious() && WHITESPACES.contains(tokenSequence.token().id()) && tokenSequence.offset() < n2) {
            n2 = tokenSequence.offset();
        }
        return new int[]{n, n2};
    }

    static CsmObject validateSelection(CsmContext csmContext, int n, int n2) {
        return null;
    }

    static CsmObject validateSelectionForIntroduceMethod(CsmContext csmContext, int n, int n2, int[] nArray) {
        int[] nArray2 = IntroduceHint.ignoreWhitespaces(csmContext, Math.min(n, n2), Math.max(n, n2));
        if ((n = nArray2[0]) >= (n2 = nArray2[1])) {
            return null;
        }
        return null;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static List<ErrorDescription> computeError(CsmContext csmContext, Map<IntroduceKind, Fix> map, Map<IntroduceKind, String> map2, AtomicBoolean atomicBoolean) {
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        String string = Utilities.guessName(csmContext);
        IntroduceFix introduceFix = new IntroduceFix(csmContext, string, 1, IntroduceKind.CREATE_VARIABLE);
        IntroduceFix introduceFix2 = new IntroduceFix(csmContext, string, 1, IntroduceKind.CREATE_CONSTANT);
        Object v = null;
        IntroduceExpressionBasedMethodFix introduceExpressionBasedMethodFix = null;
        LinkedList<CsmType> linkedList2 = new LinkedList<CsmType>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        HashSet<CsmType> hashSet = new HashSet<CsmType>();
        introduceExpressionBasedMethodFix = new IntroduceExpressionBasedMethodFix(csmContext, null, linkedList2, linkedList3, hashSet);
        if (map != null) {
            map.put(IntroduceKind.CREATE_VARIABLE, introduceFix);
            map.put(IntroduceKind.CREATE_CONSTANT, introduceFix2);
            map.put(IntroduceKind.CREATE_FIELD, (Fix)v);
            map.put(IntroduceKind.CREATE_METHOD, introduceExpressionBasedMethodFix);
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntroduceExpressionBasedMethodFix
    implements Fix {
        private final CsmContext context;
        private final CsmExpressionStatement expression;
        private final List<CsmType> parameterTypes;
        private final List<String> parameterNames;

        public IntroduceExpressionBasedMethodFix(CsmContext csmContext, CsmExpressionStatement csmExpressionStatement, List<CsmType> list, List<String> list2, Set<CsmType> set) {
            this.context = csmContext;
            this.expression = csmExpressionStatement;
            this.parameterTypes = list;
            this.parameterNames = list2;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toString() {
            return "[IntroduceExpressionBasedMethodFix]";
        }

        public ChangeInfo implement() throws Exception {
            JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton jButton2 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel introduceMethodPanel = new IntroduceMethodPanel("");
            introduceMethodPanel.setOkButton(jButton);
            String string = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceMethodPanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                return null;
            }
            String string2 = introduceMethodPanel.getMethodName();
            CsmVisibility csmVisibility = introduceMethodPanel.getAccess();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntroduceMethodFix
    implements Fix {
        private CsmFile csmFile;
        private CsmScope parentBlock;
        private List<CsmType> parameterTypes;
        private List<String> parameterNames;
        private List<CsmType> additionalLocalTypes;
        private List<String> additionalLocalNames;
        private CsmType returnType;
        private String returnName;
        private boolean declareVariableForReturnValue;
        private Set<CsmType> thrownTypes;
        private List<CsmObject> exists;
        private boolean exitsFromAllBranches;
        private int from;
        private int to;

        public IntroduceMethodFix(CsmFile csmFile, CsmScope csmScope, List<CsmType> list, List<String> list2, List<CsmType> list3, List<String> list4, CsmType csmType, String string, boolean bl, Set<CsmType> set, List<CsmObject> list5, boolean bl2, int n, int n2) {
            this.csmFile = csmFile;
            this.parentBlock = csmScope;
            this.parameterTypes = list;
            this.parameterNames = list2;
            this.additionalLocalTypes = list3;
            this.additionalLocalNames = list4;
            this.returnType = csmType;
            this.returnName = string;
            this.declareVariableForReturnValue = bl;
            this.thrownTypes = set;
            this.exists = list5;
            this.exitsFromAllBranches = bl2;
            this.from = n;
            this.to = n2;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toDebugString() {
            return "[IntroduceMethod:" + this.from + ":" + this.to + "]";
        }

        public ChangeInfo implement() throws Exception {
            JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton jButton2 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel introduceMethodPanel = new IntroduceMethodPanel("");
            introduceMethodPanel.setOkButton(jButton);
            String string = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceMethodPanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                return null;
            }
            return null;
        }
    }

    private static final class IntroduceFieldFix
    implements Fix {
        private String guessedName;
        private CsmObject handle;
        private CsmFile csmFile;
        private int numDuplicates;
        private int[] initilizeIn;
        private boolean statik;
        private boolean allowFinalInCurrentMethod;

        public IntroduceFieldFix(CsmObject csmObject, CsmFile csmFile, String string, int n, int[] nArray, boolean bl, boolean bl2) {
            this.handle = csmObject;
            this.csmFile = csmFile;
            this.guessedName = string;
            this.numDuplicates = n;
            this.initilizeIn = nArray;
            this.statik = bl;
            this.allowFinalInCurrentMethod = bl2;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceField");
        }

        public String toString() {
            return "[IntroduceField:" + this.guessedName + ":" + this.numDuplicates + ":" + this.statik + ":" + this.allowFinalInCurrentMethod + ":" + Arrays.toString(this.initilizeIn) + "]";
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_OK"));
            JButton jButton2 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_Cancel"));
            IntroduceFieldPanel introduceFieldPanel = new IntroduceFieldPanel(this.guessedName, this.initilizeIn, this.numDuplicates, this.allowFinalInCurrentMethod, jButton);
            String string = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceField");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceFieldPanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                return null;
            }
            return null;
        }
    }

    private static final class IntroduceFix
    implements Fix {
        private final String guessedName;
        private final CsmContext handle;
        private final int numDuplicates;
        private final IntroduceKind kind;

        public IntroduceFix(CsmContext csmContext, String string, int n, IntroduceKind introduceKind) {
            this.handle = csmContext;
            this.guessedName = string;
            this.numDuplicates = n;
            this.kind = introduceKind;
        }

        public String toString() {
            return "[IntroduceFix:" + this.guessedName + ":" + this.numDuplicates + ":" + (Object)((Object)this.kind) + "]";
        }

        public String getKeyExt() {
            switch (this.kind) {
                case CREATE_CONSTANT: {
                    return "IntroduceConstant";
                }
                case CREATE_VARIABLE: {
                    return "IntroduceVariable";
                }
            }
            throw new IllegalStateException();
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton jButton2 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceVariablePanel introduceVariablePanel = new IntroduceVariablePanel(this.numDuplicates, this.guessedName, this.kind == IntroduceKind.CREATE_CONSTANT, jButton);
            String string = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceVariablePanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                return null;
            }
            return null;
        }
    }
}

