/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    private static final String ERROR = "<error>";

    private GeneratorUtils() {
    }

    public static String getGetterSetterDisplayName(Kind kind) {
        if (kind == Kind.GETTERS_ONLY) {
            return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_getter");
        }
        if (kind == Kind.SETTERS_ONLY) {
            return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_setter");
        }
        return NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_getter_and_setter");
    }

    public static Collection<CsmMember> getAllMembers(CsmClass csmClass) {
        return csmClass.getMembers();
    }

    public static Collection<CsmFunction> getAllOutOfClassMethodDefinitions(CsmClass csmClass) {
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_FRIEND}));
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        while (iterator.hasNext()) {
            CsmMethod csmMethod = (CsmMethod)iterator.next();
            CsmFunctionDefinition csmFunctionDefinition = csmMethod.getDefinition();
            if (csmFunctionDefinition == null || csmFunctionDefinition == csmMethod) continue;
            arrayList.add((CsmFunction)csmFunctionDefinition);
        }
        return arrayList;
    }

    public static boolean isConstant(CsmVariable csmVariable) {
        return csmVariable.getType() != null && csmVariable.getType().isConst();
    }

    public static void scanForFieldsAndConstructors(CsmClass csmClass, Set<CsmField> set, Set<CsmField> set2, List<CsmConstructor> list) {
        for (CsmMember csmMember : csmClass.getMembers()) {
            if (CsmKindUtilities.isField((CsmObject)csmMember)) {
                CsmField csmField = (CsmField)csmMember;
                if (csmField.isStatic()) continue;
                if (csmField.getInitialValue() == null) {
                    if (set.remove(csmField)) continue;
                    set2.add(csmField);
                    continue;
                }
                if (set.remove(csmField)) continue;
                set2.add(csmField);
                continue;
            }
            if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
            list.add((CsmConstructor)csmMember);
        }
    }

    public static CsmFile[] getDeclarationDefinitionFiles(CsmClass csmClass) {
        CsmFile csmFile;
        CsmFile csmFile2 = csmFile = CsmRefactoringUtils.getCsmFile((CsmObject)csmClass);
        if (csmFile.isHeaderFile()) {
            CsmFile csmFile3;
            Iterator<CsmFunction> iterator = GeneratorUtils.getAllOutOfClassMethodDefinitions(csmClass).iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                csmFile3 = iterator.next();
                csmFile2 = CsmRefactoringUtils.getCsmFile((CsmObject)csmFile3);
                if (csmFile.equals(csmFile2)) continue;
                bl = true;
            }
            if (!bl && (csmFile3 = GeneratorUtils.findSource(csmFile)) != null) {
                csmFile2 = csmFile3;
            }
        }
        return new CsmFile[]{csmFile, csmFile2};
    }

    private static CsmFile findSource(CsmFile csmFile) {
        String string = GeneratorUtils.getFileName(csmFile.getAbsolutePath());
        Collection collection = CsmIncludeHierarchyResolver.getDefault().getFiles(csmFile);
        for (CsmFile csmFile2 : collection) {
            if (!IpeUtils.areFilenamesEqual((String)GeneratorUtils.getFileName(csmFile2.getAbsolutePath()), (String)string)) continue;
            return csmFile2;
        }
        for (CsmFile csmFile2 : csmFile.getProject().getSourceFiles()) {
            if (!IpeUtils.areFilenamesEqual((String)GeneratorUtils.getFileName(((Object)csmFile2.getAbsolutePath()).toString()), (String)string)) continue;
            return csmFile2;
        }
        return null;
    }

    private static String getFileName(CharSequence charSequence) {
        String string = new File(((Object)charSequence).toString()).getName();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static InsertInfo[] getInsertPositons(CsmContext csmContext, CsmClass csmClass, EncapsulateFieldPanel.InsertPoint insertPoint) {
        CsmMember csmMember;
        CsmFunctionDefinition csmFunctionDefinition;
        PositionRef positionRef;
        CsmObject csmObject2;
        Object object;
        int n = -1;
        int n2 = -1;
        CsmFile csmFile = null;
        CsmFile csmFile2 = null;
        InsertInfo[] insertInfoArray = new InsertInfo[2];
        if (insertPoint == EncapsulateFieldPanel.InsertPoint.DEFAULT) {
            Object object2 = object = csmContext == null ? null : csmContext.getObjectUnderOffset();
            if (object == null && csmContext != null) {
                for (CsmObject csmObject2 : csmContext.getPath()) {
                    if (CsmKindUtilities.isClass((CsmObject)csmObject2)) {
                        csmClass = (CsmClass)csmObject2;
                        n = csmContext.getCaretOffset();
                        if (n > csmClass.getLeftBracketOffset()) continue;
                        n = csmClass.getLeftBracketOffset() + 1;
                        continue;
                    }
                    if (!CsmKindUtilities.isOffsetableDeclaration((Object)csmObject2)) continue;
                    object = (CsmOffsetable)csmObject2;
                }
            }
            if (object != null) {
                n = object.getEndOffset();
            }
            if (CsmKindUtilities.isClassMember((CsmObject)object)) {
                csmClass = ((CsmMember)object).getContainingClass();
                if (CsmKindUtilities.isField((CsmObject)object)) {
                    n = -1;
                }
            } else if (csmClass == null) {
                csmClass = csmContext.getEnclosingClass();
            }
        } else {
            if (csmClass == null) {
                csmClass = insertPoint.getContainerClass();
            }
            if (insertPoint.getElementDeclaration() != null) {
                n = insertPoint.getElementDeclaration().getEndOffset();
            } else if (insertPoint.getIndex() == Integer.MIN_VALUE) {
                n = csmClass.getLeftBracketOffset() + 1;
            }
        }
        if (n < 0) {
            object = null;
            Object var9_10 = null;
            csmObject2 = null;
            positionRef = null;
            csmFunctionDefinition = csmClass.getMembers().iterator();
            while (csmFunctionDefinition.hasNext()) {
                void var9_11;
                csmMember = (CsmMember)csmFunctionDefinition.next();
                if (csmMember.getVisibility() != CsmVisibility.PUBLIC || !CsmKindUtilities.isMethod((CsmObject)csmMember)) continue;
                CsmMethod csmMethod = (CsmMethod)csmMember;
                object = csmMethod;
                if (var9_11 == null) {
                    CsmMethod csmMethod2 = csmMethod;
                }
                if (!CsmKindUtilities.isConstructor((CsmObject)csmMethod)) continue;
                csmObject2 = csmMethod;
                if (positionRef != null) continue;
                positionRef = csmMethod;
            }
            if (object != null) {
                n = object.getEndOffset();
                if (csmFile == null) {
                    csmFile = CsmRefactoringUtils.getCsmFile((CsmObject)object);
                }
                if ((csmFunctionDefinition = object.getDefinition()) != null && csmFunctionDefinition != object) {
                    csmFile2 = CsmRefactoringUtils.getCsmFile((CsmObject)csmFunctionDefinition);
                    n2 = csmFunctionDefinition.getEndOffset();
                }
            } else {
                n = csmClass.getLeftBracketOffset() + 1;
            }
        }
        if (csmFile == null) {
            csmFile = CsmRefactoringUtils.getCsmFile((CsmObject)csmClass);
        }
        if (csmFile2 == null) {
            for (CsmFunction csmFunction : GeneratorUtils.getAllOutOfClassMethodDefinitions(csmClass)) {
                csmFile2 = CsmRefactoringUtils.getCsmFile((CsmObject)csmFunction);
                n2 = csmFunction.getEndOffset();
                if (insertPoint.getIndex() == Integer.MAX_VALUE) continue;
                break;
            }
        }
        object = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmFile2);
        csmObject2 = object.createPositionRef(n, Position.Bias.Backward);
        positionRef = object.createPositionRef(n, Position.Bias.Forward);
        insertInfoArray[0] = new InsertInfo((CloneableEditorSupport)object, n, (PositionRef)csmObject2, positionRef);
        if (cloneableEditorSupport != null && n2 >= 0) {
            csmFunctionDefinition = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Backward);
            csmMember = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
            insertInfoArray[1] = new InsertInfo(cloneableEditorSupport, n2, (PositionRef)csmFunctionDefinition, (PositionRef)csmMember);
        }
        return insertInfoArray;
    }

    public static Boolean checkStartWithUpperCase(CsmMethod csmMethod) {
        String string = "";
        if (!(CsmKindUtilities.isConstructor((CsmObject)csmMethod) || CsmKindUtilities.isOperator((CsmObject)csmMethod) || CsmKindUtilities.isDestructor((CsmObject)csmMethod))) {
            string = ((Object)csmMethod.getName()).toString();
        }
        return string.length() == 0 ? null : Boolean.valueOf(Character.isUpperCase(string.charAt(0)));
    }

    public static void generateGettersAndSetters(CsmContext csmContext, Collection<? extends CsmField> collection, boolean bl, Kind kind, boolean bl2) {
        CsmClass csmClass = Utilities.extractEnclosingClass(csmContext);
        if (csmClass == null) {
            System.err.println("why enclosing class is null? " + csmContext);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (collection.isEmpty()) {
            System.err.println("nothing to encapsulate");
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (bl) {
            InsertInfo[] insertInfoArray = GeneratorUtils.getInsertPositons(csmContext, csmClass, EncapsulateFieldPanel.InsertPoint.DEFAULT);
            final InsertInfo insertInfo = insertInfoArray[0];
            final StringBuilder stringBuilder = new StringBuilder();
            for (CsmField object2 : collection) {
                if (kind != Kind.SETTERS_ONLY) {
                    stringBuilder.append("\n");
                    stringBuilder.append(DeclarationGenerator.createGetter(object2, GeneratorUtils.computeGetterName(object2, bl2), DeclarationGenerator.Kind.INLINE_DEFINITION));
                }
                if (kind == Kind.GETTERS_ONLY) continue;
                stringBuilder.append("\n");
                stringBuilder.append(DeclarationGenerator.createSetter(object2, GeneratorUtils.computeSetterName(object2, bl2), DeclarationGenerator.Kind.INLINE_DEFINITION));
            }
            final Document document = csmContext.getDocument();
            Runnable csmField = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        document.insertString(insertInfo.dot, stringBuilder.toString(), null);
                        Reformat reformat = Reformat.get((Document)document);
                        reformat.lock();
                        try {
                            int n = insertInfo.start.getOffset();
                            int n2 = insertInfo.end.getOffset();
                            reformat.reformat(n, n2);
                        }
                        finally {
                            reformat.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            };
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).runAtomicAsUser(csmField);
            } else {
                csmField.run();
            }
        } else {
            RefactoringSession refactoringSession = RefactoringSession.create((String)GeneratorUtils.getGetterSetterDisplayName(kind));
            EncapsulateFieldsRefactoring encapsulateFieldsRefactoring = new EncapsulateFieldsRefactoring(null, csmContext);
            ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> arrayList = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
            for (CsmField csmField : collection) {
                String string = kind != Kind.SETTERS_ONLY ? GeneratorUtils.computeGetterName(csmField, bl2) : null;
                String string2 = kind != Kind.GETTERS_ONLY ? GeneratorUtils.computeSetterName(csmField, bl2) : null;
                arrayList.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo(csmField, string, string2, null, null));
            }
            encapsulateFieldsRefactoring.setRefactorFields(arrayList);
            encapsulateFieldsRefactoring.setFieldModifiers(Collections.<CsmVisibility>emptySet());
            encapsulateFieldsRefactoring.getContext().add((Object)EncapsulateFieldPanel.InsertPoint.DEFAULT);
            encapsulateFieldsRefactoring.setMethodInline(false);
            Problem problem = encapsulateFieldsRefactoring.preCheck();
            if (problem != null && problem.isFatal()) {
                System.err.println("preCheck failed: not possible to refactor " + problem);
                return;
            }
            problem = encapsulateFieldsRefactoring.prepare(refactoringSession);
            if (problem != null && problem.isFatal()) {
                System.err.println("prepare failed: not possible to refactor " + problem);
                return;
            }
            refactoringSession.doRefactoring(false);
        }
    }

    public static boolean hasGetter(CsmField csmField, Map<String, List<CsmMethod>> map, boolean bl) {
        String string = GeneratorUtils.computeGetterName(csmField, bl);
        List<CsmMethod> list = map.get(string);
        if (list != null) {
            CsmType csmType = csmField.getType();
            for (CsmMethod csmMethod : list) {
                Collection collection = csmMethod.getParameters();
                if (!collection.isEmpty() || !GeneratorUtils.isSameType(csmMethod.getReturnType(), csmType)) continue;
                return true;
            }
        }
        return false;
    }

    public static String stripFieldPrefix(String string) {
        String string2 = string;
        if (string2.startsWith("m_")) {
            string2 = string.substring(2);
        }
        if (string2.length() > 1 && string2.charAt(0) == 'p' && Character.isUpperCase(string2.charAt(1))) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private static StringBuilder getCapitalizedName(CsmField csmField) {
        StringBuilder stringBuilder = new StringBuilder(GeneratorUtils.stripFieldPrefix(((Object)csmField.getName()).toString()));
        while (stringBuilder.length() > 1 && stringBuilder.charAt(0) == '_') {
            stringBuilder.deleteCharAt(0);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        }
        stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        return stringBuilder;
    }

    public static String computeSetterName(CsmField csmField, boolean bl) {
        StringBuilder stringBuilder = GeneratorUtils.getCapitalizedName(csmField);
        stringBuilder.insert(0, GeneratorUtils.toPrefix("set", bl));
        return stringBuilder.toString();
    }

    public static String computeGetterName(CsmField csmField, boolean bl) {
        StringBuilder stringBuilder = GeneratorUtils.getCapitalizedName(csmField);
        CsmType csmType = csmField.getType();
        stringBuilder.insert(0, GeneratorUtils.toPrefix(GeneratorUtils.getTypeKind(csmType) == TypeKind.BOOLEAN ? "is" : "get", bl));
        return stringBuilder.toString();
    }

    private static String toPrefix(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        char c = stringBuilder.charAt(0);
        c = bl ? Character.toUpperCase(c) : Character.toLowerCase(c);
        stringBuilder.setCharAt(0, c);
        return stringBuilder.toString();
    }

    public static TypeKind getTypeKind(CsmType csmType) {
        CharSequence charSequence = csmType.getClassifierText();
        if (CharSequenceKey.Comparator.compare("void", charSequence) == 0) {
            return TypeKind.VOID;
        }
        if (CharSequenceKey.Comparator.compare("bool", charSequence) == 0 || CharSequenceKey.Comparator.compare("boolean", charSequence) == 0) {
            return TypeKind.BOOLEAN;
        }
        return TypeKind.UNKNOWN;
    }

    public static boolean isSameType(CsmType csmType, CsmType csmType2) {
        if (csmType.equals(csmType2)) {
            return true;
        }
        if (csmType2 != null) {
            return CharSequenceKey.Comparator.compare(csmType.getCanonicalText(), csmType2.getCanonicalText()) == 0;
        }
        return false;
    }

    public static boolean hasSetter(CsmField csmField, Map<String, List<CsmMethod>> map, boolean bl) {
        String string = GeneratorUtils.computeSetterName(csmField, bl);
        List<CsmMethod> list = map.get(string);
        if (list != null) {
            CsmType csmType = csmField.getType();
            for (CsmMethod csmMethod : list) {
                Collection collection = csmMethod.getParameters();
                if (GeneratorUtils.getTypeKind(csmMethod.getReturnType()) != TypeKind.VOID || collection.size() != 1 || !GeneratorUtils.isSameType(((CsmParameter)collection.iterator().next()).getType(), csmType)) continue;
                return true;
            }
        }
        return false;
    }

    public static DialogDescriptor createDialogDescriptor(JComponent jComponent, String string) {
        Object[] objectArray = new JButton[2];
        objectArray[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_button"));
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, (String)"A11Y_Generate"));
        objectArray[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)jComponent, string, true, objectArray, (Object)objectArray[0], 0, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeKind {
        VOID,
        BOOLEAN,
        UNKNOWN;

    }

    public static final class InsertInfo {
        public final CloneableEditorSupport ces;
        public final PositionRef start;
        public final PositionRef end;
        public final int dot;

        public InsertInfo(CloneableEditorSupport cloneableEditorSupport, int n, PositionRef positionRef, PositionRef positionRef2) {
            this.ces = cloneableEditorSupport;
            this.start = positionRef;
            this.end = positionRef2;
            this.dot = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        GETTERS_ONLY,
        SETTERS_ONLY,
        GETTERS_SETTERS;

    }
}

