/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.document;

import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.structure.document.DocumentScene;
import org.openide.util.ImageUtilities;

public class ComponentWidget
extends Widget {
    private static final Layout LAYOUT = LayoutFactory.createHorizontalFlowLayout();
    private static final Layout LAYOUT_NODES = LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)10);
    private static final Layout LAYOUT_LABEL = LayoutFactory.createVerticalFlowLayout();
    private static final Border BORDER_SEPARATOR = BorderFactory.createEmptyBorder((int)8, (int)0);
    private static final Border BORDER_IMAGE = BorderFactory.createEmptyBorder((int)4, (int)8, (int)4, (int)0);
    private static final Border BORDER_LABEL = BorderFactory.createEmptyBorder((int)8, (int)4);
    private Widget components;
    private DesignComponent component;

    public ComponentWidget(DocumentScene documentScene, DesignComponent designComponent, boolean bl) {
        super((Scene)documentScene);
        Widget widget;
        this.component = designComponent;
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        Color color = componentDescriptor != null ? Color.WHITE : Color.MAGENTA;
        PaletteDescriptor paletteDescriptor = componentDescriptor != null ? componentDescriptor.getPaletteDescriptor() : null;
        Image image = paletteDescriptor != null ? ImageUtilities.loadImage((String)paletteDescriptor.getSmallIcon()) : null;
        this.setLayout(LAYOUT);
        SeparatorWidget separatorWidget = new SeparatorWidget((Scene)documentScene, SeparatorWidget.Orientation.VERTICAL);
        separatorWidget.setBorder(BORDER_SEPARATOR);
        this.addChild((Widget)separatorWidget);
        if (image != null) {
            widget = new ImageWidget((Scene)documentScene, image);
            widget.setBorder(BORDER_IMAGE);
            widget.setOpaque(true);
            widget.setBackground((Paint)(bl ? DocumentScene.COLOR_SELECTED : color));
            this.addChild(widget);
        }
        widget = new Widget((Scene)documentScene);
        widget.setBorder(BORDER_LABEL);
        widget.setOpaque(true);
        widget.setBackground((Paint)(bl ? DocumentScene.COLOR_SELECTED : color));
        widget.setLayout(LAYOUT_LABEL);
        this.addChild(widget);
        LabelWidget labelWidget = new LabelWidget((Scene)documentScene, designComponent.getComponentID() + " : " + (componentDescriptor != null ? componentDescriptor.getTypeDescriptor().getThisType().toString() : "<Unknown>"));
        labelWidget.setFont(documentScene.getDefaultFont().deriveFont(1));
        widget.addChild((Widget)labelWidget);
        if (componentDescriptor != null) {
            for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
                String string = propertyDescriptor.getName();
                PropertyValue propertyValue = designComponent.readProperty(string);
                widget.addChild((Widget)new LabelWidget((Scene)documentScene, string + "=" + propertyValue.serialize()));
            }
        }
        this.components = new Widget((Scene)documentScene);
        this.components.setLayout(LAYOUT_NODES);
        this.addChild(this.components);
        widget.getActions().addAction(documentScene.getHoverAction());
        this.getActions().addAction(documentScene.getSelectAction());
    }

    public void addChildComponentWidget(ComponentWidget componentWidget) {
        this.components.addChild((Widget)componentWidget);
        ((ObjectScene)componentWidget.getScene()).addObject((Object)componentWidget.getComponent(), new Widget[]{componentWidget});
    }

    public DesignComponent getComponent() {
        return this.component;
    }
}

