/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.document;

import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.structure.document.ComponentWidget;
import org.netbeans.modules.vmd.structure.document.DocumentScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentController
implements DesignDocumentAwareness,
DesignListener {
    private DataObjectContext context;
    private JToolBar toolbarRepresentation;
    private JScrollPane scrollPane;
    private DesignDocument document;
    private DocumentScene scene;
    private JComponent view;

    public DocumentController(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        this.scene = new DocumentScene();
        this.view = this.scene.createView();
        this.scrollPane = new JScrollPane(this.view);
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    public void setDesignDocument(final DesignDocument designDocument) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DocumentController.this.updateDocumentReference(designDocument);
            }
        });
    }

    public void attach() {
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void deattach() {
        this.context.removeDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbarRepresentation == null) {
            this.toolbarRepresentation = new JToolBar();
            this.toolbarRepresentation.setFloatable(false);
        }
        return this.toolbarRepresentation;
    }

    private void updateDocumentReference(DesignDocument designDocument) {
        if (this.document == designDocument) {
            return;
        }
        if (this.document != null) {
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
        }
        this.document = designDocument;
        if (this.document != null) {
            this.document.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            this.designChanged(null);
        } else {
            this.scene.setupLoadingDocument();
        }
    }

    public void designChanged(DesignEvent designEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final DesignDocument designDocument = DocumentController.this.document;
                if (designDocument != null) {
                    designDocument.getTransactionManager().readAccess(new Runnable(){

                        public void run() {
                            DocumentController.this.updateScene(designDocument);
                        }
                    });
                }
            }
        });
    }

    private void updateScene(DesignDocument designDocument) {
        if (designDocument == null) {
            return;
        }
        this.scene.clear();
        Collection collection = designDocument.getSelectedComponents();
        DesignComponent designComponent = designDocument.getRootComponent();
        ComponentWidget componentWidget = new ComponentWidget(this.scene, designComponent, collection.contains(designComponent));
        this.scene.setRootNode(designDocument, componentWidget);
        this.updateForChildren(collection, componentWidget, designComponent);
        this.scene.validate();
    }

    private void updateForChildren(Collection<DesignComponent> collection, ComponentWidget componentWidget, DesignComponent designComponent) {
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            ComponentWidget componentWidget2 = new ComponentWidget(this.scene, designComponent2, collection.contains(designComponent2));
            componentWidget.addChildComponentWidget(componentWidget2);
            this.updateForChildren(collection, componentWidget2, designComponent2);
        }
    }
}

