/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;

public class GdbWatchVariable
extends AbstractVariable
implements PropertyChangeListener {
    protected static boolean disableMacros = Boolean.getBoolean("gdb.macros.disable");
    private final Watch watch;
    private static final Logger log = Logger.getLogger("gdb.logger.watches");
    private boolean requestType = true;
    private boolean requestValue = true;
    private boolean requestResolved = true;
    private String type = null;
    private String resolvedType = null;
    private String expandedWatch = null;

    public GdbWatchVariable(GdbDebugger gdbDebugger, Watch watch) {
        super(gdbDebugger, null);
        this.watch = watch;
        gdbDebugger.addPropertyChangeListener(this);
        watch.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Watch getWatch() {
        return this.watch;
    }

    protected void selfDestroy() {
        this.getDebugger().removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        log.fine("GWV.propertyChange: Property change for " + propertyChangeEvent.getPropertyName());
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("currentThread") || string.equals("currentCallStackFrame") || string.equals("expression")) {
            if (string.equals("expression")) {
                this.tinfo = null;
            }
            this.emptyFields();
            this.requestType = true;
            this.requestValue = true;
            this.requestResolved = true;
            this.expandedWatch = null;
            this.notifyValueChanged(this.value, null);
        } else if ("valueChanged".equals(string)) {
            this.onValueChange(propertyChangeEvent);
        }
    }

    public String getName() {
        return this.watch.getExpression();
    }

    public String getType() {
        if (this.requestType) {
            String string = this.getDebugger().requestWhatis(this.getExpanded());
            this.type = string == null ? "" : string;
            this.requestType = false;
        }
        return this.type;
    }

    protected String getResolvedType() {
        if (this.requestResolved) {
            this.resolvedType = this.getType().length() > 0 ? super.getResolvedType() : "";
            this.requestResolved = false;
        }
        return this.resolvedType;
    }

    public String getValue() {
        if (this.requestValue) {
            this.value = this.getDebugger().evaluate(this.getExpanded());
            this.requestValue = false;
        }
        return super.getValue();
    }

    private String getExpanded() {
        if (this.expandedWatch == null) {
            String string = this.watch.getExpression();
            if (!disableMacros) {
                string = GdbWatchVariable.expandMacro(this.getDebugger(), string);
            }
            this.expandedWatch = string;
        }
        return this.expandedWatch;
    }

    public static String expandMacro(GdbDebugger gdbDebugger, String string) {
        int n;
        StyledDocument styledDocument;
        GdbCallStackFrame gdbCallStackFrame = gdbDebugger.getCurrentCallStackFrame();
        if (gdbCallStackFrame != null && (styledDocument = gdbCallStackFrame.getDocument()) != null && (n = gdbCallStackFrame.getOffset()) >= 0) {
            return CsmMacroExpansion.expand((Document)styledDocument, (int)n, (String)string);
        }
        return string;
    }
}

