/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncUnit {
    private final DocumentComponent target;
    private List<ChangeInfo> changes = new ArrayList<ChangeInfo>();
    private List<DocumentComponent> toRemove = new ArrayList<DocumentComponent>();
    private List<DocumentComponent> toAdd = new ArrayList<DocumentComponent>();
    private Map<String, Attr> removedAttributes = new HashMap<String, Attr>();
    private Map<String, Attr> addedAttributes = new HashMap<String, Attr>();
    private boolean componentChanged;
    private boolean hasTextContentChanges = false;
    private Set<String> nonDomainedChanges = new HashSet<String>();

    public SyncUnit(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            throw new IllegalArgumentException("Null syncTarget");
        }
        this.target = documentComponent;
    }

    public void addChange(ChangeInfo changeInfo) {
        if (!this.target.referencesSameNode(changeInfo.getParent())) {
            throw new IllegalArgumentException("ChangeInfo does not match target id");
        }
        this.changes.add(changeInfo);
        if (changeInfo.getChangedNode() instanceof Attr) {
            Attr attr = (Attr)changeInfo.getChangedNode();
            if (changeInfo.isAdded()) {
                this.addToAddedAttributes(attr);
            } else {
                this.addToRemovedAttributes(attr);
            }
        } else if (!changeInfo.isDomainElement()) {
            Node node = changeInfo.getActualChangedNode();
            if (!(node instanceof Attribute) && !(node instanceof Element)) {
                if (node.getNodeType() != 3 || ((Text)node).getNodeValue().trim().length() != 0) {
                    this.setHasTextContentChanges(true);
                    this.addNonDomainedElementChange(changeInfo);
                }
            } else {
                this.addNonDomainedElementChange(changeInfo);
            }
        }
    }

    public List<ChangeInfo> getChanges() {
        return this.changes;
    }

    public DocumentComponent getTarget() {
        return this.target;
    }

    public List<DocumentComponent> getToRemoveList() {
        return this.toRemove;
    }

    public void addToRemoveList(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.toRemove.add(documentComponent);
    }

    public List<DocumentComponent> getToAddList() {
        return this.toAdd;
    }

    public void addToAddList(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.toAdd.add(documentComponent);
    }

    public void setComponentChanged(boolean bl) {
        this.componentChanged = bl;
    }

    public boolean isComponentChanged() {
        return this.componentChanged;
    }

    public void addToAddedAttributes(Attr attr) {
        this.addedAttributes.put(attr.getName(), attr);
    }

    public Map<String, Attr> getAddedAttributes() {
        return this.addedAttributes;
    }

    public Map<String, Attr> getRemovedAttributes() {
        return this.removedAttributes;
    }

    public void addToRemovedAttributes(Attr attr) {
        this.removedAttributes.put(attr.getName(), attr);
    }

    public void merge(SyncUnit syncUnit) {
        if (this.target != syncUnit.getTarget()) {
            throw new IllegalArgumentException("Invalid sync unit for merge");
        }
        this.changes.addAll(syncUnit.getChanges());
        for (String object : syncUnit.getRemovedAttributes().keySet()) {
            this.addToRemovedAttributes(syncUnit.getRemovedAttributes().get(object));
        }
        for (String string : syncUnit.getAddedAttributes().keySet()) {
            this.addToAddedAttributes(syncUnit.getAddedAttributes().get(string));
        }
        if (!syncUnit.getToAddList().isEmpty()) {
            Iterator<DocumentComponent> iterator = new HashSet();
            for (DocumentComponent documentComponent : this.toAdd) {
                ((HashSet)((Object)iterator)).add((DocumentComponent)((Object)documentComponent.getPeer()));
            }
            for (DocumentComponent documentComponent : syncUnit.getToAddList()) {
                if (((HashSet)((Object)iterator)).contains(documentComponent.getPeer())) continue;
                this.toAdd.add(documentComponent);
            }
        }
        for (DocumentComponent documentComponent : syncUnit.getToRemoveList()) {
            if (this.toRemove.contains(documentComponent)) continue;
            this.toRemove.add(documentComponent);
        }
    }

    public void updateTargetReference() {
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)this.target;
        if (abstractDocumentComponent != null) {
            abstractDocumentComponent.updateReference(this.getParentToRootPath());
        }
    }

    public ChangeInfo getLastChange() {
        if (this.changes.size() > 0) {
            return this.changes.get(this.changes.size() - 1);
        }
        return null;
    }

    public List<Element> getParentToRootPath() {
        if (this.getLastChange() == null) {
            return Collections.emptyList();
        }
        return this.getLastChange().getParentToRootPath();
    }

    public boolean hasTextContentChanges() {
        return this.hasTextContentChanges;
    }

    public void setHasTextContentChanges(boolean bl) {
        this.hasTextContentChanges = bl;
    }

    public Set<String> getNonDomainedElementChanges() {
        return this.nonDomainedChanges;
    }

    public void addNonDomainedElementChange(ChangeInfo changeInfo) {
        if (changeInfo.getChangedNode() instanceof Element) {
            this.nonDomainedChanges.add(((Element)changeInfo.getChangedNode()).getTagName());
        }
    }

    public boolean hasWhitespaceChangeOnly() {
        for (ChangeInfo changeInfo : this.getChanges()) {
            String string;
            if (changeInfo.isDomainElement()) continue;
            Node node = changeInfo.getActualChangedNode();
            if (node.getNodeType() == 3) {
                string = ((Text)node).getNodeValue();
                if (string == null || string.trim().length() <= 0) continue;
                return false;
            }
            if (node.getNodeType() == 2) {
                string = ((Attr)node).getName();
                Attr attr = this.getRemovedAttributes().get(string);
                if (attr == null) {
                    return false;
                }
                Attr attr2 = this.getAddedAttributes().get(string);
                if (attr2 == null) {
                    return false;
                }
                if (attr.getValue() != null && attr.getValue().equals(attr2.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

