/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.jumpto.file.FileDescription;
import org.netbeans.modules.jumpto.file.FileSearchOptions;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.netbeans.modules.jumpto.type.GoToTypeAction;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSearchAction
extends AbstractAction
implements FileSearchPanel.ContentProvider {
    static final Logger LOGGER = Logger.getLogger(FileSearchAction.class.getName());
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("FileSearchAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private Dialog dialog;
    private JButton openBtn;
    private FileSearchPanel panel;
    private Dimension initialDimension;

    public FileSearchAction() {
        super(NbBundle.getMessage(FileSearchAction.class, (String)"CTL_FileSearchAction"));
        this.putValue("PopupMenuText", NbBundle.getBundle(FileSearchAction.class).getString("editor-popup-CTL_FileSearchAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileDescription[] fileDescriptionArray = this.getSelectedFiles();
        if (fileDescriptionArray != null) {
            for (FileDescription fileDescription : fileDescriptionArray) {
                fileDescription.open();
            }
        }
    }

    @Override
    public ListCellRenderer getListCellRenderer(JList jList) {
        return new FileDescription.Renderer(jList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListModel(FileSearchPanel fileSearchPanel, String string) {
        QuerySupport.Kind kind;
        if (this.openBtn != null) {
            this.openBtn.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (string == null) {
            fileSearchPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean bl = string.endsWith(" ");
        if ((string = string.trim()).length() == 0) {
            fileSearchPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int n = GoToTypeAction.containsWildCard(string);
        if (bl) {
            kind = QuerySupport.Kind.EXACT;
        } else if (n != -1) {
            kind = fileSearchPanel.isCaseSensitive() ? QuerySupport.Kind.REGEXP : QuerySupport.Kind.CASE_INSENSITIVE_REGEXP;
            string = FileSearchAction.wildcards2regexp(string);
        } else {
            kind = GoToTypeAction.isAllUpper(string) && string.length() > 1 || GoToTypeAction.isCamelCase(string) ? QuerySupport.Kind.CAMEL_CASE : (fileSearchPanel.isCaseSensitive() ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        }
        FileSearchAction fileSearchAction = this;
        synchronized (fileSearchAction) {
            this.running = new Worker(string, kind, fileSearchPanel.getCurrentProject());
            this.task = rp.post((Runnable)this.running, 220);
            if (fileSearchPanel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - fileSearchPanel.time) + " ms.");
            }
        }
    }

    @Override
    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.openBtn != null && this.openBtn.isEnabled();
    }

    private FileDescription[] getSelectedFiles() {
        FileDescription[] fileDescriptionArray = null;
        this.panel = new FileSearchPanel(this, FileSearchAction.findCurrentProject());
        this.dialog = this.createDialog(this.panel);
        this.dialog.setVisible(true);
        fileDescriptionArray = this.panel.getSelectedFiles();
        return fileDescriptionArray;
    }

    private Dialog createDialog(FileSearchPanel fileSearchPanel) {
        this.openBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.openBtn, (String)NbBundle.getMessage(FileSearchAction.class, (String)"CTL_Open"));
        this.openBtn.getAccessibleContext().setAccessibleDescription(this.openBtn.getText());
        this.openBtn.setEnabled(false);
        Object[] objectArray = new Object[]{this.openBtn, DialogDescriptor.CANCEL_OPTION};
        String string = NbBundle.getMessage(FileSearchAction.class, (String)"MSG_FileSearchDlgTitle");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fileSearchPanel, string, true, objectArray, (Object)this.openBtn, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(fileSearchPanel));
        dialogDescriptor.setClosingOptions(objectArray);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchAction.class, (String)"AN_FileSearchDialog"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchAction.class, (String)"AD_FileSearchDialog"));
        dialog.setPreferredSize(new Dimension(FileSearchOptions.getWidth(), FileSearchOptions.getHeight()));
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n = rectangle.width * 9 / 10;
        int n2 = rectangle.height * 9 / 10;
        Dimension dimension = dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n);
        dimension.height = Math.min(dimension.height, n2);
        this.initialDimension = dimension;
        dialog.setBounds(Utilities.findCenterBounds((Dimension)dimension));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FileSearchAction.this.cleanup();
            }
        });
        return dialog;
    }

    private static Project findCurrentProject() {
        Lookup lookup = Utilities.actionsGlobalContext();
        Iterator iterator = lookup.lookupAll(Project.class).iterator();
        if (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            return project;
        }
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) continue;
            return project;
        }
        return OpenProjects.getDefault().getMainProject();
    }

    private void cleanup() {
        if (this.dialog != null) {
            int n = this.dialog.getWidth();
            int n2 = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != n || this.initialDimension.height != n2)) {
                FileSearchOptions.setHeight(n2);
                FileSearchOptions.setWidth(n);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            FileSearchOptions.flush();
        }
    }

    private static String wildcards2regexp(String string) {
        return string.replace(".", "\\.").replace("*", ".*").replace('?', '.').concat(".*");
    }

    private Collection<? extends FileObject> searchSources(FileObject fileObject, Collection<? extends FileObject> collection, Collection<? extends FileObject> collection2, FileObjectFilter[] fileObjectFilterArray) {
        if (fileObject.getChildren().length == 0 || collection2.contains(fileObject) || !this.checkAgainstFilters(fileObject, fileObjectFilterArray)) {
            return collection;
        }
        collection.add((FileObject)fileObject);
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            this.searchSources((FileObject)enumeration.nextElement(), collection, collection2, fileObjectFilterArray);
        }
        return collection;
    }

    private boolean isMatchedFileObject(QuerySupport.Kind kind, FileObject fileObject, String string) {
        boolean bl = false;
        switch (kind) {
            case EXACT: {
                bl = fileObject.getNameExt().equals(string);
                break;
            }
            case PREFIX: {
                if (string.length() == 0) {
                    bl = true;
                    break;
                }
                bl = fileObject.getNameExt().startsWith(string);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (string.length() == 0) {
                    bl = true;
                    break;
                }
                bl = fileObject.getNameExt().toLowerCase().startsWith(string.toLowerCase());
                break;
            }
            case CAMEL_CASE: {
                Object object;
                int n;
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                int n2 = 0;
                do {
                    object = string.substring(n2, (n = FileSearchAction.findNextUpper(string, n2 + 1)) == -1 ? string.length() : n);
                    if (n2 == 0) {
                        string2 = object;
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n2 = n;
                } while (n != -1);
                object = Pattern.compile(stringBuilder.toString());
                Matcher matcher = ((Pattern)object).matcher(fileObject.getNameExt());
                bl = matcher.matches();
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    Pattern pattern = Pattern.compile(string, 2);
                    Matcher matcher = pattern.matcher(fileObject.getNameExt());
                    bl = matcher.matches();
                    break;
                }
                Pattern pattern = Pattern.compile(string, 34);
                Matcher matcher = pattern.matcher(fileObject.getNameExt());
                bl = matcher.matches();
                break;
            }
            case REGEXP: {
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    Pattern pattern = Pattern.compile(string);
                    Matcher matcher = pattern.matcher(fileObject.getNameExt());
                    bl = matcher.matches();
                    break;
                }
                Pattern pattern = Pattern.compile(string, 32);
                Matcher matcher = pattern.matcher(fileObject.getNameExt());
                bl = matcher.matches();
                break;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: {
                Object object;
                int n;
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = null;
                int n3 = 0;
                do {
                    object = string.substring(n3, (n = FileSearchAction.findNextUpper(string, n3 + 1)) == -1 ? string.length() : n);
                    if (n3 == 0) {
                        string3 = object;
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n3 = n;
                } while (n != -1);
                object = Pattern.compile(stringBuilder.toString(), 2);
                Matcher matcher = ((Pattern)object).matcher(fileObject.getNameExt());
                bl = matcher.matches();
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        return bl;
    }

    private static int findNextUpper(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean checkAgainstFilters(FileObject fileObject, FileObjectFilter[] fileObjectFilterArray) {
        assert (fileObject.isFolder());
        for (FileObjectFilter fileObjectFilter : fileObjectFilterArray) {
            if (fileObjectFilter.traverseFolder(fileObject) != 0) continue;
            return false;
        }
        return true;
    }

    private class DialogButtonListener
    implements ActionListener {
        private FileSearchPanel panel;

        public DialogButtonListener(FileSearchPanel fileSearchPanel) {
            this.panel = fileSearchPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FileSearchAction.this.openBtn) {
                this.panel.setSelectedFile();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private final String text;
        private final QuerySupport.Kind searchType;
        private final Project currentProject;
        private final long createTime;

        public Worker(String string, QuerySupport.Kind kind, Project project) {
            this.text = string;
            this.searchType = kind;
            this.currentProject = project;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + string + ", " + kind + " - created after " + (System.currentTimeMillis() - ((FileSearchAction)FileSearchAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            final List<? extends FileDescription> list = this.getFileNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            final ListModel listModel = Models.fromList(list);
            if (!this.isCanceled && listModel != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileSearchAction.this.panel.setModel(listModel);
                        if (FileSearchAction.this.openBtn != null && !list.isEmpty()) {
                            FileSearchAction.this.openBtn.setEnabled(true);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (((FileSearchAction)FileSearchAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        private List<? extends FileDescription> getFileNames(String string) {
            String string2;
            switch (this.searchType) {
                case CASE_INSENSITIVE_PREFIX: 
                case CASE_INSENSITIVE_REGEXP: {
                    string2 = "ci-file-name";
                    break;
                }
                default: {
                    string2 = "file-name";
                }
            }
            Collection collection = QuerySupport.findRoots((Project)null, null, Collections.emptyList(), Collections.emptyList());
            try {
                Sources sources;
                FileObjectFilter[] fileObjectFilterArray;
                Object object;
                QuerySupport querySupport = QuerySupport.forRoots((String)"org-netbeans-modules-jumpto-file-FileIndexer", (int)1, (FileObject[])collection.toArray(new FileObject[collection.size()]));
                Collection collection2 = querySupport.query(string2, string, this.searchType, new String[0]);
                ArrayList<FileDescription> arrayList = new ArrayList<FileDescription>();
                for (IndexResult indexResult : collection2) {
                    object = indexResult.getFile();
                    if (object == null || !object.isValid()) continue;
                    fileObjectFilterArray = FileOwnerQuery.getOwner((FileObject)object);
                    boolean bl = fileObjectFilterArray != null && this.currentProject != null ? fileObjectFilterArray.getProjectDirectory() == this.currentProject.getProjectDirectory() : false;
                    FileDescription fileDescription = new FileDescription((FileObject)object, indexResult.getRelativePath().substring(0, Math.max(indexResult.getRelativePath().length() - object.getNameExt().length() - 1, 0)), (Project)fileObjectFilterArray, bl);
                    arrayList.add(fileDescription);
                    LOGGER.finer("Found: " + object.getPath() + ", project=" + fileObjectFilterArray + ", currentProject=" + this.currentProject + ", preferred=" + bl);
                }
                Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
                object = new ArrayList();
                fileObjectFilterArray = new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER};
                for (Project project : projectArray) {
                    SourceGroup[] sourceGroupArray;
                    sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("generic")) {
                        FileObject fileObject = sourceGroup.getRootFolder();
                        object = FileSearchAction.this.searchSources(fileObject, (Collection)object, collection, fileObjectFilterArray);
                    }
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject = (FileObject)iterator.next();
                    assert (fileObject.isFolder());
                    Enumeration enumeration = fileObject.getData(false);
                    while (enumeration.hasMoreElements()) {
                        void var17_28;
                        Project project;
                        project = (FileObject)enumeration.nextElement();
                        if (project.isFolder() || !FileSearchAction.this.isMatchedFileObject(this.searchType, (FileObject)project, string)) continue;
                        sources = FileOwnerQuery.getOwner((FileObject)project);
                        boolean bl = sources != null && this.currentProject != null ? sources.getProjectDirectory() == this.currentProject.getProjectDirectory() : false;
                        String string3 = FileUtil.getRelativePath((FileObject)sources.getProjectDirectory(), (FileObject)project);
                        if (string3 == null) {
                            String string4 = "";
                        }
                        FileDescription fileDescription = new FileDescription((FileObject)project, (String)var17_28, (Project)sources, bl);
                        arrayList.add(fileDescription);
                    }
                }
                Collections.sort(arrayList, new FileDescription.FDComarator(FileSearchAction.this.panel.isPreferedProject(), FileSearchAction.this.panel.isCaseSensitive()));
                return arrayList;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return Collections.emptyList();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
                return Collections.emptyList();
            }
        }
    }
}

