/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.gotodeclaration.symbol.CppSymbolDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcher;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcherFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppSymbolProvider
implements SymbolProvider {
    Cache cache;
    private boolean cancelled;
    private static final boolean TRACE = Boolean.getBoolean("cnd.gotosymbol.trace");
    private static final boolean USE_CACHE = CndUtils.getBoolean((String)"cnd.gotosymbol.cache", (boolean)true);

    public CppSymbolProvider() {
        if (TRACE) {
            this.trace("ctor", new Object[0]);
        }
    }

    public synchronized void cancel() {
        if (TRACE) {
            this.trace("cancel", new Object[0]);
        }
        this.cancelled = true;
        this.cache = null;
    }

    public synchronized void cleanup() {
        if (TRACE) {
            this.trace("cleanup", new Object[0]);
        }
        this.cancelled = false;
        this.cache = null;
    }

    private CsmSelect.NameAcceptor createNameAcceptor(SymbolProvider.Context context) {
        final NameMatcher nameMatcher = NameMatcherFactory.createNameMatcher(context.getText(), context.getSearchType());
        if (nameMatcher == null) {
            return null;
        }
        return new CsmSelect.NameAcceptor(){

            public boolean accept(CharSequence charSequence) {
                return nameMatcher.accept(((Object)charSequence).toString());
            }
        };
    }

    public synchronized void computeSymbolNames(SymbolProvider.Context context, SymbolProvider.Result result) {
        List list;
        if (TRACE) {
            this.trace("computeSymbolNames %s", this.toString(context));
        }
        this.cancelled = false;
        CsmSelect.NameAcceptor nameAcceptor = this.createNameAcceptor(context);
        if (nameAcceptor == null) {
            if (CndUtils.isDebugMode()) {
                Logger.global.severe("Can not create matcher for '" + context.getText() + "' search type " + context.getSearchType());
            }
            return;
        }
        ArrayList<CppSymbolDescriptor> arrayList = new ArrayList<CppSymbolDescriptor>();
        boolean bl = false;
        if (this.cache != null && context.getSearchType() == this.cache.searchType && context.getText().startsWith(this.cache.text) && (list = (List)this.cache.data.get(context.getProject())) != null) {
            bl = true;
            long l = System.currentTimeMillis();
            for (CppSymbolDescriptor cppSymbolDescriptor : list) {
                if (!nameAcceptor.accept(cppSymbolDescriptor.getRawName())) continue;
                arrayList.add(cppSymbolDescriptor);
            }
            if (TRACE) {
                this.trace("Narrowing %d symbols took %d ms", arrayList.size(), System.currentTimeMillis() - l);
            }
        }
        if (!bl) {
            long l = System.currentTimeMillis();
            this.collect(context, nameAcceptor, arrayList);
            if (TRACE) {
                this.trace("Collecting %d symbols took %d ms", arrayList.size(), System.currentTimeMillis() - l);
            }
        }
        if (this.cancelled) {
            this.cache = null;
        } else {
            if (USE_CACHE) {
                this.cache = new Cache(context.getSearchType(), context.getText());
                this.cache.data.put(context.getProject(), arrayList);
            }
            result.addResult(arrayList);
        }
        this.cancelled = false;
    }

    private void collect(SymbolProvider.Context context, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> list) {
        if (context.getProject() == null) {
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
            for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                if (this.cancelled) break;
                this.collectSymbols(csmProject, nameAcceptor, list);
                this.collectLibs(csmProject, hashSet);
            }
            for (CsmProject csmProject : hashSet) {
                if (!this.cancelled) {
                    this.collectSymbols(csmProject, nameAcceptor, list);
                    continue;
                }
                break;
            }
        } else {
            CsmProject csmProject;
            NativeProject nativeProject = (NativeProject)context.getProject().getLookup().lookup(NativeProject.class);
            if (nativeProject != null && (csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject)) != null) {
                this.collectSymbols(csmProject, nameAcceptor, list);
            }
        }
    }

    private void collectLibs(CsmProject csmProject, Collection<CsmProject> collection) {
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            if (collection.contains(csmProject2)) continue;
            collection.add(csmProject2);
            this.collectLibs(csmProject2, collection);
        }
    }

    private void collectSymbols(CsmProject csmProject, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> list) {
        this.collectSymbols(csmProject.getGlobalNamespace(), nameAcceptor, list);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(nameAcceptor);
        for (CsmFile csmFile : csmProject.getAllFiles()) {
            Object object;
            Iterator iterator = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (iterator.hasNext() && !this.cancelled) {
                list.add(new CppSymbolDescriptor((CsmOffsetable)iterator.next()));
            }
            if (this.cancelled) break;
            Iterator iterator2 = CsmSelect.getStaticFunctions((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (iterator2.hasNext() && !this.cancelled) {
                object = (CsmFunction)iterator2.next();
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)object)) {
                    list.add(new CppSymbolDescriptor((CsmOffsetable)object));
                    continue;
                }
                CsmFunctionDefinition csmFunctionDefinition = object.getDefinition();
                if (csmFunctionDefinition == null) continue;
                list.add(new CppSymbolDescriptor((CsmOffsetable)csmFunctionDefinition));
            }
            if (this.cancelled) break;
            object = CsmSelect.getStaticVariables((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (object.hasNext() && !this.cancelled) {
                list.add(new CppSymbolDescriptor((CsmOffsetable)object.next()));
            }
            if (!this.cancelled) continue;
            break;
        }
    }

    private void collectSymbols(CsmNamespace csmNamespace, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> list) {
        CsmOffsetableDeclaration csmOffsetableDeclaration;
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(nameAcceptor);
        CsmSelect.CsmFilter csmFilter2 = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION, CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.TYPEDEF});
        CsmSelect.CsmFilter csmFilter3 = CsmSelect.getFilterBuilder().createCompoundFilter(csmFilter, csmFilter2);
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)csmFilter3);
        while (iterator.hasNext()) {
            csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next();
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                    list.add(new CppSymbolDescriptor((CsmOffsetable)csmOffsetableDeclaration));
                    continue;
                }
                CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmOffsetableDeclaration).getDefinition();
                if (csmFunctionDefinition != null && csmFunctionDefinition != csmOffsetableDeclaration) continue;
                list.add(new CppSymbolDescriptor((CsmOffsetable)csmOffsetableDeclaration));
                continue;
            }
            list.add(new CppSymbolDescriptor((CsmOffsetable)csmOffsetableDeclaration));
        }
        csmOffsetableDeclaration = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT});
        iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)csmOffsetableDeclaration);
        while (iterator.hasNext()) {
            this.addDeclarationIfNeed((CsmOffsetableDeclaration)iterator.next(), nameAcceptor, list);
        }
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            this.collectSymbols(csmNamespace2, nameAcceptor, list);
        }
    }

    private void addDeclarationIfNeed(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> list) {
        block4: {
            block3: {
                if (nameAcceptor.accept(csmOffsetableDeclaration.getName())) {
                    list.add(new CppSymbolDescriptor((CsmOffsetable)csmOffsetableDeclaration));
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) break block3;
                for (CsmMember csmMember : ((CsmClass)csmOffsetableDeclaration).getMembers()) {
                    this.addDeclarationIfNeed((CsmOffsetableDeclaration)csmMember, nameAcceptor, list);
                }
                break block4;
            }
            if (!CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) break block4;
            for (CsmEnumerator csmEnumerator : ((CsmEnum)csmOffsetableDeclaration).getEnumerators()) {
                if (!nameAcceptor.accept(csmEnumerator.getName())) continue;
                list.add(new CppSymbolDescriptor((CsmOffsetable)csmEnumerator));
            }
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CPP_Provider_Display_Name");
    }

    public String name() {
        return "C/C++";
    }

    private String toString(SymbolProvider.Context context) {
        return String.format("Context: prj=%s type=%s text=%s", context.getProject(), context.getSearchType(), context.getText());
    }

    private void trace(String string, Object ... objectArray) {
        if (TRACE) {
            string = String.format("%s @%x %s\n", this.getClass().getSimpleName(), this.hashCode(), string);
            System.err.printf(string, objectArray);
        }
    }

    private static class Cache {
        public final String text;
        public final SearchType searchType;
        private final Map<Project, List<CppSymbolDescriptor>> data;

        public Cache(SearchType searchType, String string) {
            this.text = string;
            this.searchType = searchType;
            this.data = new HashMap<Project, List<CppSymbolDescriptor>>();
        }
    }
}

