/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcher;
import org.netbeans.spi.jumpto.type.SearchType;

public class NameMatcherFactory {
    private NameMatcherFactory() {
    }

    public static NameMatcher createNameMatcher(String string, SearchType searchType) {
        try {
            switch (searchType) {
                case EXACT_NAME: {
                    return new ExactNameMatcher(string);
                }
                case CASE_INSENSITIVE_EXACT_NAME: {
                    return new CaseInsensitiveExactNameMatcher(string);
                }
                case PREFIX: {
                    return new PrefixNameMatcher(string);
                }
                case REGEXP: {
                    return new RegExpNameMatcher(string, true);
                }
                case CASE_INSENSITIVE_REGEXP: {
                    return new RegExpNameMatcher(string, false);
                }
                case CASE_INSENSITIVE_PREFIX: {
                    return new CaseInsensitivePrefixNameMatcher(string);
                }
                case CAMEL_CASE: {
                    return new CamelCaseNameMatcher(string);
                }
            }
            return null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static CsmSelect.CsmFilter createNameFilter(String string, SearchType searchType) {
        final NameMatcher nameMatcher = NameMatcherFactory.createNameMatcher(string, searchType);
        if (nameMatcher != null) {
            CsmSelect.NameAcceptor nameAcceptor = new CsmSelect.NameAcceptor(){

                public boolean accept(CharSequence charSequence) {
                    return nameMatcher.accept(((Object)charSequence).toString());
                }
            };
            return CsmSelect.getFilterBuilder().createNameFilter(nameAcceptor);
        }
        return null;
    }

    private static final class CamelCaseNameMatcher
    implements NameMatcher {
        Pattern pattern;

        public CamelCaseNameMatcher(String string) {
            if (string.length() == 0) {
                throw new IllegalArgumentException();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuilder.append(c);
                if (i == string.length() - 1) {
                    stringBuilder.append("\\w*");
                    continue;
                }
                stringBuilder.append("[\\p{Lower}\\p{Digit}]*");
            }
            this.pattern = Pattern.compile(stringBuilder.toString());
        }

        public final boolean accept(String string) {
            return string != null && this.pattern.matcher(string).matches();
        }
    }

    private static final class RegExpNameMatcher
    implements NameMatcher {
        Pattern pattern;

        public RegExpNameMatcher(String string, boolean bl) {
            this.pattern = Pattern.compile(string, bl ? 0 : 2);
        }

        public final boolean accept(String string) {
            return string != null && this.pattern.matcher(string).matches();
        }
    }

    private static final class CaseInsensitivePrefixNameMatcher
    extends BaseNameMatcher
    implements NameMatcher {
        public CaseInsensitivePrefixNameMatcher(String string) {
            super(string.toLowerCase());
        }

        public final boolean accept(String string) {
            return string != null && string.toLowerCase().startsWith(this.patternText);
        }
    }

    private static final class PrefixNameMatcher
    extends BaseNameMatcher
    implements NameMatcher {
        public PrefixNameMatcher(String string) {
            super(string);
        }

        public final boolean accept(String string) {
            return string != null && string.startsWith(this.patternText);
        }
    }

    private static final class CaseInsensitiveExactNameMatcher
    extends BaseNameMatcher
    implements NameMatcher {
        public CaseInsensitiveExactNameMatcher(String string) {
            super(string);
        }

        public final boolean accept(String string) {
            return this.patternText.equalsIgnoreCase(string);
        }
    }

    private static final class ExactNameMatcher
    extends BaseNameMatcher
    implements NameMatcher {
        public ExactNameMatcher(String string) {
            super(string);
        }

        public final boolean accept(String string) {
            return this.patternText.equals(string);
        }
    }

    private static abstract class BaseNameMatcher
    implements NameMatcher {
        protected String patternText;

        protected BaseNameMatcher(String string) {
            this.patternText = string;
        }
    }
}

