/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigEditorContextImpl;
import org.netbeans.modules.web.jsf.JSFConfigEditorViewFactorySupport;
import org.netbeans.modules.web.jsf.JSFConfigMultiviewDescriptor;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class JSFConfigEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JSFConfigDataObject jSFConfigDataObject = (JSFConfigDataObject)JSFConfigEditorSupport.this.getDataObject();
            JSFConfigEditorSupport.this.restartTimer();
            jSFConfigDataObject.parsingDocument();
            if (jSFConfigDataObject.isDocumentValid()) {
                JSFConfigEditorSupport.this.saveDocument();
            } else {
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    JSFConfigEditorSupport.this.saveDocument();
                }
            }
        }
    };
    private JSFConfigDataObject dataObject;
    private RequestProcessor.Task parsingDocumentTask;
    private TopComponent mvtc;
    private static final int AUTO_PARSING_DELAY = 2000;
    private int click = 0;

    public JSFConfigEditorSupport(JSFConfigDataObject jSFConfigDataObject) {
        super((DataObject)jSFConfigDataObject, (CloneableEditorSupport.Env)new XmlEnv(jSFConfigDataObject));
        this.dataObject = jSFConfigDataObject;
        this.setMIMEType("text/x-jsf+xml");
        this.initialize();
    }

    protected CloneableEditorSupport.Pane createPane() {
        JSFConfigEditorContextImpl jSFConfigEditorContextImpl = new JSFConfigEditorContextImpl((JSFConfigDataObject)this.getDataObject());
        ArrayList<MultiViewDescription> arrayList = new ArrayList<MultiViewDescription>(JSFConfigEditorViewFactorySupport.createViewDescriptions(jSFConfigEditorContextImpl));
        if (arrayList.size() > 0) {
            arrayList.add(new JSFConfigMultiviewDescriptor(jSFConfigEditorContextImpl));
            return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])arrayList.toArray(new MultiViewDescription[arrayList.size()]), (MultiViewDescription)arrayList.get(0), (CloseOperationHandler)new CloseHandler((JSFConfigDataObject)this.getDataObject()));
        }
        return super.createPane();
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent cloneableTopComponent = super.createCloneableTopComponent();
        this.mvtc = cloneableTopComponent;
        this.updateDisplayName();
        return cloneableTopComponent;
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    protected void setMVTC(TopComponent topComponent) {
        this.mvtc = topComponent;
        this.updateDisplayName();
    }

    public void updateDisplayName() {
        final TopComponent topComponent = this.mvtc;
        if (topComponent == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = JSFConfigEditorSupport.this.messageName();
                if (!string.equals(topComponent.getDisplayName())) {
                    topComponent.setDisplayName(string);
                }
                topComponent.setToolTipText(JSFConfigEditorSupport.this.dataObject.getPrimaryFile().getPath());
            }
        });
    }

    private void initialize() {
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            private void change(DocumentEvent documentEvent) {
                if (!JSFConfigEditorSupport.this.dataObject.isNodeDirty()) {
                    JSFConfigEditorSupport.this.restartTimer();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StyledDocument styledDocument = JSFConfigEditorSupport.this.getDocument();
                if ("document".equals(propertyChangeEvent.getPropertyName()) && JSFConfigEditorSupport.this.isDocumentLoaded() && styledDocument != null) {
                    styledDocument.addDocumentListener(documentListener);
                }
            }
        });
    }

    public void saveDocument() throws IOException {
        CharsetEncoder charsetEncoder;
        final StyledDocument styledDocument = this.getDocument();
        String string = "UTF-8";
        String string2 = EncodingUtil.detectEncoding((Document)styledDocument);
        boolean bl = false;
        if (string2 == null) {
            string2 = string;
        }
        if (!this.isSupportedEncoding(string2)) {
            charsetEncoder = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2, string}), 0, 2);
            charsetEncoder.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)charsetEncoder);
            if (charsetEncoder.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            bl = true;
        }
        if (!bl) {
            try {
                charsetEncoder = Charset.forName(string2).newEncoder();
                if (!charsetEncoder.canEncode(styledDocument.getText(0, styledDocument.getLength()))) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2}), 0, 2);
                    confirmation.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int n;
                int n2 = Math.min(1000, styledDocument.getLength());
                final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                int n3 = 0;
                if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                    for (n = 3; n < n2; ++n) {
                        if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                        n3 = n + 1;
                        break;
                    }
                }
                n = n3;
                Runnable runnable = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                styledDocument.remove(0, n + 1);
                                styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                            }
                            catch (BadLocationException badLocationException) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
        }
    }

    private boolean isSupportedEncoding(String string) {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            bl = false;
        }
        return bl;
    }

    public void restartTimer() {
        if (this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel()) {
            this.dataObject.setDocumentDirty(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    JSFConfigEditorSupport.this.dataObject.parsingDocument();
                }
            };
            this.parsingDocumentTask = this.parsingDocumentTask != null ? RequestProcessor.getDefault().post(runnable, 2000) : RequestProcessor.getDefault().post(runnable, 100);
        }
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        this.updateDisplayName();
        this.addSaveCookie();
        return true;
    }

    protected void notifyClosed() {
        this.mvtc = null;
        super.notifyClosed();
        try {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel(this.dataObject.getPrimaryFile(), true);
            if (jSFConfigModel != null) {
                jSFConfigModel.sync();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.updateDisplayName();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        if (this.dataObject.getCookie(SaveCookie.class) == null) {
            this.dataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            this.dataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        JSFConfigDataObject jSFConfigDataObject = (JSFConfigDataObject)this.getDataObject();
        Node.Cookie cookie = jSFConfigDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            jSFConfigDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            jSFConfigDataObject.setModified(false);
        }
    }

    public void open() {
        super.open();
        this.restartTimer();
        this.updateDisplayName();
    }

    public void edit() {
        this.open();
        JSFConfigEditorSupport.runInAwtDispatchThread(new Runnable(){

            public void run() {
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)JSFConfigEditorSupport.this.mvtc);
                if (multiViewHandler != null) {
                    multiViewHandler.requestVisible(multiViewHandler.getPerspectives()[multiViewHandler.getPerspectives().length - 1]);
                    JSFConfigEditorSupport.this.mvtc.requestActive();
                }
            }
        });
    }

    private static void runInAwtDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(JSFConfigDataObject jSFConfigDataObject) {
            super((DataObject)jSFConfigDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JSFConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (JSFConfigEditorSupport)this.getDataObject().getCookie(JSFConfigEditorSupport.class);
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private JSFConfigDataObject dataObject;

        private CloseHandler() {
        }

        public CloseHandler(JSFConfigDataObject jSFConfigDataObject) {
            this.dataObject = jSFConfigDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            boolean bl = this.dataObject.getEditorSupport().canClose();
            if (bl) {
                this.dataObject.getEditorSupport().notifyClosed();
            }
            return bl;
        }
    }
}

