/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.palette.items.EntityClass;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EntityClassCustomizer
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle(EntityClassCustomizer.class);
    private Dialog dialog = null;
    private boolean dialogOK = false;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private final EntityClass entityClass;
    private final JTextComponent target;
    private final FileObject targetFileObject;
    private final boolean hasModuleJsf;
    private final Vector<String> beans = new Vector();
    private JRadioButton detail;
    private JRadioButton edit;
    private JRadioButton empty;
    private JTextField entityClassName;
    private JRadioButton fromBean;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JComboBox managedBeanComboBox;
    private JRadioButton managedBeanCreate;
    private JTextField managedBeanName;
    private JRadioButton managedBeanNo;
    private JRadioButton managedBeanRegistered;
    private ButtonGroup managedBeanType;
    private ButtonGroup populate;
    private ButtonGroup viewType;

    public EntityClassCustomizer(EntityClass entityClass, JTextComponent jTextComponent) {
        this.entityClass = entityClass;
        this.target = jTextComponent;
        this.targetFileObject = EntityClass.getFO(jTextComponent);
        this.hasModuleJsf = JSFConfigUtilities.hasJsfFramework(this.targetFileObject);
        this.initComponents();
        Mnemonics.setLocalizedText((AbstractButton)this.empty, (String)bundle.getString("LBL_Empty" + entityClass.getName()));
        Mnemonics.setLocalizedText((AbstractButton)this.fromBean, (String)bundle.getString("LBL_FromEntity" + entityClass.getName()));
        this.empty.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_Empty" + entityClass.getName()));
        this.empty.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Empty" + entityClass.getName()));
        this.fromBean.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_Generated" + entityClass.getName()));
        this.fromBean.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Generated" + entityClass.getName()));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Jsf" + entityClass.getName()));
        if (!"Form".equals(entityClass.getName())) {
            this.jLabel2.setVisible(false);
            this.edit.setVisible(false);
            this.detail.setVisible(false);
        }
        this.entityClassName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.updateBeanName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.updateBeanName();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.updateBeanName();
            }
        });
        this.managedBeanName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.checkStatus();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.checkStatus();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                EntityClassCustomizer.this.checkStatus();
            }
        });
        this.initBeans();
    }

    private void initBeans() {
        if (this.targetFileObject == null) {
            return;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)this.targetFileObject);
        List<FacesManagedBean> list = JSFBeanCache.getBeans(webModule);
        for (FacesManagedBean facesManagedBean : list) {
            this.beans.add(facesManagedBean.getManagedBeanName());
        }
        this.managedBeanComboBox.setModel(new DefaultComboBoxModel<String>(this.beans));
    }

    public boolean showDialog() {
        this.dialogOK = false;
        String string = bundle.getString("NAME_jsp-Jsf" + this.entityClass.getName());
        this.descriptor = new DialogDescriptor((Object)this, bundle.getString("LBL_Customizer_InsertPrefix") + " " + string, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EntityClassCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    EntityClassCustomizer.this.evaluateInput();
                    EntityClassCustomizer.this.dialogOK = true;
                }
                EntityClassCustomizer.this.dialog.dispose();
            }
        });
        this.statusLine = this.descriptor.createNotificationLineSupport();
        this.checkStatus();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void evaluateInput() {
        String string = this.entityClassName.getText();
        this.entityClass.setBean(string);
        int n = this.empty.isSelected() ? 0 : (this.detail.isSelected() ? 1 : 2);
        this.entityClass.setFormType(n);
        if (n == 0) {
            return;
        }
        if (this.managedBeanCreate.isSelected()) {
            String string2 = this.managedBeanName.getText();
            this.entityClass.setVariable(string2);
            this.entityClass.addManagedBean(this.targetFileObject, string2, string);
        } else if (this.managedBeanRegistered.isSelected()) {
            this.entityClass.setVariable((String)this.managedBeanComboBox.getSelectedItem());
        } else {
            this.entityClass.setVariable("anInstanceOf." + string);
        }
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.populate = new ButtonGroup();
        this.viewType = new ButtonGroup();
        this.managedBeanType = new ButtonGroup();
        this.empty = new JRadioButton();
        this.fromBean = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.entityClassName = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.managedBeanRegistered = new JRadioButton();
        this.managedBeanCreate = new JRadioButton();
        this.managedBeanNo = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.edit = new JRadioButton();
        this.detail = new JRadioButton();
        this.managedBeanComboBox = new JComboBox();
        this.managedBeanName = new JTextField();
        this.jFileChooser1.setCurrentDirectory(null);
        this.populate.add(this.empty);
        this.empty.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/palette/items/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.empty, (String)resourceBundle.getString("LBL_EmptyForm"));
        this.empty.setMargin(new Insets(0, 0, 0, 0));
        this.empty.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassCustomizer.this.selectItemStateChanged(itemEvent);
            }
        });
        this.populate.add(this.fromBean);
        Mnemonics.setLocalizedText((AbstractButton)this.fromBean, (String)resourceBundle.getString("LBL_FromEntityForm"));
        this.fromBean.setMargin(new Insets(0, 0, 0, 0));
        this.fromBean.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassCustomizer.this.selectItemStateChanged(itemEvent);
            }
        });
        this.jLabel1.setLabelFor(this.entityClassName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("LBL_GetProperty_Bean"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)resourceBundle.getString("LBL_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntityClassCustomizer.this.jButton1ActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("LBL_ManagedBean"));
        this.managedBeanType.add(this.managedBeanRegistered);
        Mnemonics.setLocalizedText((AbstractButton)this.managedBeanRegistered, (String)resourceBundle.getString("LBL_ManagedBean_Registered"));
        this.managedBeanRegistered.setMargin(new Insets(0, 0, 0, 0));
        this.managedBeanRegistered.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassCustomizer.this.selectItemStateChanged(itemEvent);
            }
        });
        this.managedBeanType.add(this.managedBeanCreate);
        this.managedBeanCreate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.managedBeanCreate, (String)resourceBundle.getString("LBL_ManagedBean_Create"));
        this.managedBeanCreate.setMargin(new Insets(0, 0, 0, 0));
        this.managedBeanCreate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassCustomizer.this.selectItemStateChanged(itemEvent);
            }
        });
        this.managedBeanType.add(this.managedBeanNo);
        Mnemonics.setLocalizedText((AbstractButton)this.managedBeanNo, (String)resourceBundle.getString("LBL_ManagedBean_No"));
        this.managedBeanNo.setMargin(new Insets(0, 0, 0, 0));
        this.managedBeanNo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassCustomizer.this.selectItemStateChanged(itemEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("LBL_From_Fields"));
        this.viewType.add(this.edit);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)resourceBundle.getString("LBL_View_Edit"));
        this.edit.setMargin(new Insets(0, 0, 0, 0));
        this.viewType.add(this.detail);
        this.detail.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.detail, (String)resourceBundle.getString("LBL_View_Detail"));
        this.detail.setMargin(new Insets(0, 0, 0, 0));
        this.managedBeanComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jLabel1, -2, 72, -2).add(2, (Component)this.jLabel2, -2, 72, -2)).add((Component)this.jLabel3, -2, 89, -2)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.managedBeanNo, -1, 217, Short.MAX_VALUE).add(343, 343, 343)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.detail, -2, 168, -2).addPreferredGap(0).add((Component)this.edit, -2, 69, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.managedBeanCreate, -2, 209, -2).add(13, 13, 13)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.managedBeanRegistered, -1, -1, Short.MAX_VALUE).add(19, 19, 19))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.managedBeanName, -1, 232, Short.MAX_VALUE).add((Component)this.managedBeanComboBox, 0, 232, Short.MAX_VALUE))).add((Component)this.entityClassName, -1, 454, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.entityClassName, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.managedBeanCreate).add((Component)this.managedBeanName, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.managedBeanComboBox, -2, -1, -2).add((Component)this.managedBeanRegistered)).addPreferredGap(1).add((Component)this.managedBeanNo).add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.detail).add((Component)this.jLabel2).add((Component)this.edit)).addContainerGap(13, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_EntytyClass"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_EntytyClass"));
        this.jButton1.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_Browse"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Browse"));
        this.managedBeanRegistered.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ManagedBean_Registered"));
        this.managedBeanRegistered.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ManagedBean_Registered"));
        this.managedBeanCreate.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ManagedBean_Create"));
        this.managedBeanCreate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ManagedBean_Create"));
        this.managedBeanNo.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ManagedBean_No"));
        this.managedBeanNo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ManagedBean_No"));
        this.edit.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_Editable"));
        this.edit.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Editable"));
        this.detail.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ReadOnly"));
        this.detail.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ReadOnly"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.empty)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.fromBean)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(27, 27, 27).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(14, Short.MAX_VALUE).add((Component)this.empty).addPreferredGap(0).add((Component)this.fromBean).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)));
        this.empty.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_EmptyForm"));
        this.empty.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_EmptyForm"));
        this.fromBean.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_GeneratedForm"));
        this.fromBean.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_GeneratedForm"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_JsfForm"));
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)this.targetFileObject);
        ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)classpathInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
            }

            public boolean accept(ElementHandle<TypeElement> elementHandle) {
                return true;
            }
        });
        if (elementHandle != null) {
            this.entityClassName.setText(elementHandle.getQualifiedName());
        }
    }

    private void selectItemStateChanged(ItemEvent itemEvent) {
        this.checkStatus();
    }

    private void updateBeanName() {
        String string = this.entityClassName.getText();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        this.managedBeanName.setText(string);
        for (String string2 : this.beans) {
            if (!string.equals(string2)) continue;
            this.managedBeanRegistered.setSelected(true);
            this.managedBeanComboBox.setSelectedItem(string2);
            return;
        }
    }

    private void checkStatus() {
        if (this.empty.isSelected()) {
            this.entityClassName.setEnabled(false);
            this.jButton1.setEnabled(false);
            this.managedBeanCreate.setEnabled(false);
            this.managedBeanName.setEnabled(false);
            this.managedBeanRegistered.setEnabled(false);
            this.managedBeanComboBox.setEnabled(false);
            this.managedBeanNo.setEnabled(false);
            this.detail.setEnabled(false);
            this.edit.setEnabled(false);
        } else {
            this.entityClassName.setEnabled(true);
            this.jButton1.setEnabled(true);
            this.managedBeanCreate.setEnabled(true);
            this.managedBeanName.setEnabled(this.managedBeanCreate.isSelected());
            this.managedBeanRegistered.setEnabled(this.beans.size() > 0);
            this.managedBeanComboBox.setEnabled(this.managedBeanRegistered.isSelected() && this.beans.size() > 0);
            this.managedBeanNo.setEnabled(true);
            this.detail.setEnabled(true);
            this.edit.setEnabled(true);
        }
        boolean bl = false;
        try {
            bl = this.empty.isSelected() || this.entityClass.classExists(this.targetFileObject, this.entityClassName.getText());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        boolean bl2 = this.empty.isSelected() || !this.managedBeanCreate.isSelected() || this.validBean(this.targetFileObject, this.managedBeanName.getText());
        this.descriptor.setValid(this.hasModuleJsf && bl && bl2);
        this.statusLine.clearMessages();
        if (!this.hasModuleJsf) {
            this.statusLine.setErrorMessage(bundle.getString("MSG_NoJSF"));
        } else if (!bl) {
            if (this.entityClassName.getText().length() < 1) {
                this.statusLine.setInformationMessage(bundle.getString("MSG_EmptyClassName"));
            } else {
                this.statusLine.setErrorMessage(bundle.getString("MSG_InvalidClassName"));
            }
        } else if (!bl2) {
            if (this.managedBeanName.getText().length() < 1) {
                this.statusLine.setInformationMessage(bundle.getString("MSG_EmptyBeanName"));
            } else {
                this.statusLine.setErrorMessage(bundle.getString("MSG_ExistBeanName"));
            }
        }
    }

    public boolean validBean(FileObject fileObject, String string) {
        if (string.length() == 0) {
            return false;
        }
        for (String string2 : this.beans) {
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }
}

