/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashListConvert
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.HASHNODE);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        ParserResult parserResult = rubyRuleContext.parserResult;
        HashNode hashNode = (HashNode)node;
        ListNode listNode = hashNode.getListNode();
        if (listNode == null) {
            return;
        }
        if (listNode.size() < 2) {
            return;
        }
        int n = HashListConvert.getCommaOffset(rubyRuleContext, listNode, 0);
        if (n == -1) {
            return;
        }
        OffsetRange offsetRange = new OffsetRange(n, n + 1);
        String string = NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertGutter");
        List<HashFix> list2 = Collections.singletonList(new HashFix(rubyRuleContext, listNode));
        Hint hint = new Hint((Rule)this, string, RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange, list2, 140);
        list.add(hint);
    }

    private static int getCommaOffset(RubyRuleContext rubyRuleContext, ListNode listNode, int n) {
        int n2 = listNode.get(2 * n).getPosition().getEndOffset();
        int n3 = listNode.get(2 * n + 1).getPosition().getStartOffset();
        if (n3 < n2) {
            return -1;
        }
        OffsetRange offsetRange = LexUtilities.getLexerOffsets((Parser.Result)rubyRuleContext.parserResult, (OffsetRange)new OffsetRange(n2, n3));
        if (offsetRange == OffsetRange.NONE) {
            return -1;
        }
        try {
            String string = rubyRuleContext.doc.getText(offsetRange.getStart(), offsetRange.getLength());
            int n4 = string.indexOf(44);
            if (n4 == -1 || string.indexOf("=>") != -1) {
                return -1;
            }
            return offsetRange.getStart() + n4;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public String getId() {
        return "HashListConvert";
    }

    public String getDescription() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvert");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class HashFix
    implements PreviewableFix {
        private RubyRuleContext context;
        private ListNode listNode;

        public HashFix(RubyRuleContext rubyRuleContext, ListNode listNode) {
            this.context = rubyRuleContext;
            this.listNode = listNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(Deprecations.class, (String)"HashListConvertFix");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            int n = this.listNode.size() / 2;
            for (int i = 0; i < n; ++i) {
                int n2 = HashListConvert.getCommaOffset(this.context, this.listNode, i);
                if (n2 == -1) continue;
                String string = baseDocument.getText(n2, 3);
                StringBuilder stringBuilder = new StringBuilder();
                if (!Character.isWhitespace(baseDocument.getText(n2 - 1, 1).charAt(0))) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("=>");
                if (n2 < baseDocument.getLength() - 2 && !Character.isWhitespace(baseDocument.getText(n2 + 1, 1).charAt(0))) {
                    stringBuilder.append(' ');
                }
                editList.replace(n2, 1, stringBuilder.toString(), false, 0);
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

