/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingControllerByTypeID
implements InspectorOrderingController {
    private Integer order;
    private List<TypeID> types;
    private Comparator<InspectorFolder> comparatorByName = new Comparator<InspectorFolder>(){

        @Override
        public int compare(InspectorFolder inspectorFolder, InspectorFolder inspectorFolder2) {
            return inspectorFolder.getDisplayName().compareTo(inspectorFolder2.getDisplayName());
        }
    };
    private Comparator<TypeID> comparatorByType = new Comparator<TypeID>(){

        @Override
        public int compare(TypeID typeID, TypeID typeID2) {
            return typeID.toString().compareTo(typeID2.toString());
        }
    };

    public OrderingControllerByTypeID(Integer n, TypeID ... typeIDArray) {
        if (typeIDArray == null) {
            throw new IllegalArgumentException("types argument cant be null");
        }
        this.order = n;
        this.types = Arrays.asList(typeIDArray);
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent designComponent, Collection<InspectorFolder> collection) {
        TreeMap<TypeID, ArrayList<InspectorFolder>> treeMap = new TreeMap<TypeID, ArrayList<InspectorFolder>>(this.comparatorByType);
        ArrayList<InspectorFolder> arrayList = new ArrayList<InspectorFolder>();
        for (InspectorFolder object : collection) {
            if (treeMap.get(object.getTypeID()) == null) {
                treeMap.put(object.getTypeID(), new ArrayList<InspectorFolder>(Arrays.asList(object)));
                continue;
            }
            ((List)treeMap.get(object.getTypeID())).add(object);
        }
        for (List list : treeMap.values()) {
            Collections.sort(list, this.comparatorByName);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument designDocument, TypeID typeID) {
        for (TypeID typeID2 : this.types) {
            if (!designDocument.getDescriptorRegistry().isInHierarchy(typeID2, typeID)) continue;
            return true;
        }
        return false;
    }
}

