/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.system;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2me.cdc.platform.system.EatingReader;
import org.netbeans.modules.j2me.cdc.platform.system.StreamReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ExternalProcessing {
    private static final Logger logger = Logger.getLogger(ExternalProcessing.class.getCanonicalName());

    public static String callExternal(FileObject fileObject, FileObject fileObject2, String ... stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            File file = FileUtil.toFile((FileObject)fileObject);
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = file.getPath();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i + 1] = stringArray[i];
            }
            File file2 = FileUtil.toFile((FileObject)fileObject2);
            Process process = Runtime.getRuntime().exec(stringArray2, null, file2);
            StreamReader streamReader = new StreamReader(process.getInputStream(), stringBuffer);
            EatingReader eatingReader = new EatingReader(process.getErrorStream());
            streamReader.join();
            eatingReader.join();
            int n = process.waitFor();
            process.getOutputStream().close();
            if (n != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, interruptedException.getLocalizedMessage(), interruptedException);
        }
        return stringBuffer.toString();
    }

    public static void callExternalShowOutput(FileObject fileObject, FileObject fileObject2, String ... stringArray) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        InputOutput inputOutput = new String[stringArray.length + 1];
        inputOutput[0] = file.getPath();
        for (int i = 0; i < stringArray.length; ++i) {
            inputOutput[i + 1] = stringArray[i];
        }
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Cannot be called from Event Dispatch Thread");
        }
        File file2 = FileUtil.toFile((FileObject)fileObject2);
        Process process = Runtime.getRuntime().exec((String[])inputOutput, null, file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream(), 8192);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream(), 8192);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(bufferedInputStream2));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : inputOutput) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        InputOutput inputOutput2 = IOProvider.getDefault().getIO(stringBuilder.toString(), false);
        inputOutput2.select();
        inputOutput2.getOut().println((Object)stringBuilder);
        inputOutput2.getOut().println();
        OutHandler outHandler = new OutHandler(bufferedReader, inputOutput2.getOut());
        OutHandler outHandler2 = new OutHandler(bufferedReader2, inputOutput2.getErr());
        RequestProcessor.getDefault().post((Runnable)outHandler);
        RequestProcessor.getDefault().post((Runnable)outHandler2);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.SEVERE, "Interupted", interruptedException);
        }
        outHandler.close();
        outHandler2.close();
        inputOutput2.getOut().println("Process exited with exit code " + process.exitValue());
    }

    static class OutHandler
    implements Runnable {
        private Reader out;
        private OutputWriter writer;

        public OutHandler(Reader reader, OutputWriter outputWriter) {
            this.out = reader;
            this.writer = outputWriter;
        }

        public void run() {
            try {
                while (true) {
                    if (!this.out.ready()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.close();
                            return;
                        }
                    }
                    if (!this.readOneBuffer() || Thread.currentThread().isInterrupted()) break;
                }
                this.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        private boolean readOneBuffer() throws IOException {
            int n;
            char[] cArray = new char[255];
            while ((n = this.out.read(cArray)) != -1) {
                this.writer.write(cArray, 0, n);
            }
            return n != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Failed to close stream", iOException);
            }
            finally {
                this.writer.close();
            }
        }
    }
}

