/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarActionProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private EjbJarProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public EjbJarProjectOperations(EjbJarProject ejbJarProject) {
        this.project = ejbJarProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        EjbJarProjectOperations.addFile(fileObject, "nbproject", arrayList);
        EjbJarProjectOperations.addFile(fileObject, "build.xml", arrayList);
        EjbJarProjectOperations.addFile(fileObject, "catalog.xml", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        File file;
        FileObject fileObject;
        FileObject fileObject2;
        FileObject fileObject3;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject4 = this.project.getEjbModule().getMetaInf();
        if (fileObject4 != null) {
            arrayList.add(fileObject4);
        }
        SourceRoots sourceRoots = this.project.getSourceRoots();
        FileObject[] fileObjectArray = sourceRoots.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            arrayList.add(fileObjectArray[i]);
        }
        PropertyEvaluator propertyEvaluator = this.project.evaluator();
        String string = propertyEvaluator.getProperty("source.root");
        if (string != null && (fileObject3 = this.project.getProjectDirectory()) != (fileObject2 = this.project.getAntProjectHelper().resolveFileObject(string)) && !arrayList.contains(fileObject2)) {
            arrayList.add(fileObject2);
        }
        fileObject3 = this.project.getTestSourceRoots();
        fileObject2 = fileObject3.getRoots();
        for (int i = 0; i < ((FileObject)fileObject2).length; ++i) {
            arrayList.add(fileObject2[i]);
        }
        File file2 = this.project.getEjbModule().getResourceDirectory();
        if (file2 != null && (fileObject = FileUtil.toFileObject((File)file2)) != null) {
            arrayList.add(fileObject);
        }
        if ((fileObject = this.project.getAntProjectHelper()).getLibrariesLocation() != null && (file = fileObject.resolveFile(fileObject.getLibrariesLocation())) != null && file.exists()) {
            FileObject fileObject5 = FileUtil.toFileObject((File)file).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject5)) {
                arrayList.add(fileObject5);
            }
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        EjbJarActionProvider ejbJarActionProvider = (EjbJarActionProvider)this.project.getLookup().lookup(EjbJarActionProvider.class);
        assert (ejbJarActionProvider != null);
        Lookup lookup = Lookups.fixed((Object[])new Object[0]);
        Properties properties = new Properties();
        String[] stringArray = ejbJarActionProvider.getTargetNames("clean", lookup, properties);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(file);
        EjbJarProjectOperations ejbJarProjectOperations = (EjbJarProjectOperations)project.getLookup().lookup(EjbJarProjectOperations.class);
        this.fixLibraryLocation(ejbJarProjectOperations);
        this.fixOtherReferences(file);
        this.project.setName(string);
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, final String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String string2 = this.project.getName();
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        EjbJarProjectOperations ejbJarProjectOperations = (EjbJarProjectOperations)project.getLookup().lookup(EjbJarProjectOperations.class);
        this.fixLibraryLocation(ejbJarProjectOperations);
        this.fixOtherReferences(file);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                AntProjectHelper antProjectHelper = EjbJarProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string3 = editableProperties.get((Object)"jar.name");
                String string22 = string3.substring(0, string3.length() - 4);
                if (string3.endsWith(".jar") && string22.equals(string2)) {
                    editableProperties.put("jar.name", string + ".jar");
                }
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
            }
        });
    }

    private void fixOtherReferences(final File file) {
        final File file2 = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                EditableProperties editableProperties = EjbJarProjectOperations.this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                String string = editableProperties.getProperty("meta.inf");
                if (string == null) {
                    return;
                }
                if (string.startsWith(file.getAbsolutePath())) {
                    String string2 = PropertyUtils.relativizeFile((File)file, (File)new File(string));
                    String string3 = new File(file2, string2).getAbsolutePath();
                    editableProperties.setProperty("meta.inf", string3);
                    EjbJarProjectOperations.this.project.getAntProjectHelper().putProperties("nbproject/project.properties", editableProperties);
                }
            }
        });
    }

    private static boolean isParent(File file, File file2) {
        if (file.equals(file2)) {
            return false;
        }
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    private void fixLibraryLocation(EjbJarProjectOperations ejbJarProjectOperations) throws IllegalArgumentException {
        String string = ejbJarProjectOperations.libraryPath;
        if (string != null) {
            if (!new File(string).isAbsolute()) {
                if (!ejbJarProjectOperations.libraryWithinProject) {
                    File file = ejbJarProjectOperations.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (string2 != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(string2);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (ejbJarProjectOperations.libraryWithinProject && ejbJarProjectOperations.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)ejbJarProjectOperations.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)file, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fileObject = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fileObject != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject);
                }
            }
        }
    }
}

