/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class RegisterDatabase {
    private static volatile RegisterDatabase reg = null;

    public static RegisterDatabase getDefault() {
        if (reg == null) {
            reg = new RegisterDatabase();
        }
        return reg;
    }

    public void setupDerby(String string) {
        String string2 = DerbySupport.getLocation();
        if (null != string2 && string2.trim().length() > 0) {
            return;
        }
        File file = new File(string, "javadb");
        if (file.exists() && file.isDirectory() && file.canRead()) {
            DerbySupport.setLocation((String)file.getAbsolutePath());
            string2 = DerbySupport.getSystemHome();
            if (null != string2 && string2.trim().length() > 0) {
                return;
            }
            File file2 = new File(DerbySupport.getDefaultSystemHome());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            DerbySupport.setSystemHome((String)DerbySupport.getDefaultSystemHome());
        }
        this.configureDatabase();
    }

    public void configureDatabase() {
        String string = DerbySupport.getLocation();
        File file = new File(string);
        if (file != null && file.exists()) {
            this.registerDerbyLibrary(file);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        DerbyDatabases.createSampleDatabase();
                    }
                    catch (DatabaseException databaseException) {
                        Logger.getLogger("glassfish-eecommon").log(Level.INFO, databaseException.getLocalizedMessage(), databaseException);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            });
        }
    }

    private void registerDerbyLibrary(File file) {
        FileObject fileObject = FileUtil.getConfigFile((String)"org-netbeans-api-project-libraries/Libraries");
        if (fileObject != null) {
            try {
                fileObject.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new DerbyLibraryRegistrar(file, fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, fileStateInvalidException.getLocalizedMessage(), fileStateInvalidException);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    static class DerbyLibraryRegistrar
    implements FileSystem.AtomicAction {
        private File location;
        private FileObject libsFolder;

        DerbyLibraryRegistrar(File file, FileObject fileObject) {
            this.location = file;
            this.libsFolder = fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            Writer writer = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                FileObject fileObject = null;
                fileObject = this.libsFolder.getFileObject("JavaDB", "xml");
                if (null == fileObject) {
                    fileObject = this.libsFolder.createData("JavaDB", "xml");
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream);
                    writer = new BufferedWriter(outputStreamWriter);
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">\n");
                    writer.write("<library version=\"1.0\">\n<name>JAVADB_DRIVER_LABEL</name>\n");
                    writer.write("<type>j2se</type>\n");
                    writer.write("<localizing-bundle>org.netbeans.modules.glassfish.eecommon.api.Bundle</localizing-bundle>\n");
                    writer.write("<volume>\n<type>classpath</type>\n");
                    writer.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derby.jar").toURI().toURL() + "!/</resource>\n");
                    writer.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbyclient.jar").toURI().toURL() + "!/</resource>\n");
                    writer.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbynet.jar").toURI().toURL() + "!/</resource>\n");
                    writer.write("</volume>\n<volume>\n<type>src</type>\n</volume>\n");
                    writer.write("<volume>\n<type>javadoc</type>\n");
                    writer.write("</volume>\n</library>");
                }
            }
            finally {
                if (null != writer) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                if (null != fileLock) {
                    fileLock.releaseLock();
                }
            }
        }
    }
}

