/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesImplementation;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupport;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupportEvent;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupportListener;
import org.openide.filesystems.FileUtil;

public final class PersistenceScopesHelper {
    private static final Logger LOG = Logger.getLogger(PersistenceScopesHelper.class.getName());
    private final PersistenceScopes persistenceScopes = PersistenceScopesFactory.createPersistenceScopes(new PersistenceScopesImpl());
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private final FileListener fileListener = new FileListener();
    private PersistenceScope persistenceScope;
    private File persistenceXml;
    private boolean persistenceExists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePersistenceScope(PersistenceScope persistenceScope, File file) {
        boolean bl;
        PersistenceScope persistenceScope2;
        boolean bl2;
        if (persistenceScope == null && file != null) {
            throw new IllegalArgumentException("The persistenceScope parameter cannot be null when newPersistenceXml is non-null");
        }
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            bl2 = this.persistenceExists;
            persistenceScope2 = this.persistenceScope;
            LOG.fine("changePersistenceScope: newPersistenceXml=" + file);
            if (this.persistenceXml != null) {
                FileChangeSupport.DEFAULT.removeListener(this.fileListener, this.persistenceXml);
            }
            if (file != null) {
                this.persistenceXml = file;
                FileChangeSupport.DEFAULT.addListener(this.fileListener, this.persistenceXml);
            } else {
                this.persistenceXml = null;
            }
            this.persistenceScope = persistenceScope;
            this.persistenceXml = file;
            this.change();
            bl = this.persistenceExists;
            LOG.fine("changePersistenceScope: oldPersistenceExists=" + bl2 + ", newPersistenceExists=" + bl);
        }
        if (bl2 != bl || persistenceScope2 != persistenceScope && bl) {
            LOG.fine("changePersistenceScope: firing PROP_PERSISTENCE_SCOPES change");
            this.propChangeSupport.firePropertyChange("persistenceScopes", null, null);
        }
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.persistenceScopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            this.persistenceExists = false;
            if (this.persistenceXml != null) {
                this.persistenceExists = FileUtil.toFileObject((File)this.persistenceXml) != null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileEvent() {
        boolean bl;
        boolean bl2;
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            bl2 = this.persistenceExists;
            this.change();
            bl = this.persistenceExists;
        }
        LOG.fine("fileEvent: oldPersistenceExists=" + bl2 + ", newPersistenceExists=" + bl);
        if (bl2 != bl) {
            LOG.fine("fileEvent: firing PROP_PERSISTENCE_SCOPES change");
            this.propChangeSupport.firePropertyChange("persistenceScopes", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceScope[] getPersistenceScopeList() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            if (this.persistenceExists) {
                return new PersistenceScope[]{this.persistenceScope};
            }
            return new PersistenceScope[0];
        }
    }

    private void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private class PersistenceScopesImpl
    implements PersistenceScopesImplementation {
        private PersistenceScopesImpl() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PersistenceScopesHelper.this.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PersistenceScopesHelper.this.removePropertyChangeListener(propertyChangeListener);
        }

        public PersistenceScope[] getPersistenceScopes() {
            return PersistenceScopesHelper.this.getPersistenceScopeList();
        }
    }

    private class FileListener
    implements FileChangeSupportListener {
        private FileListener() {
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            LOG.fine("fileCreated: " + fileChangeSupportEvent.getPath());
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            LOG.fine("fileDeleted: " + fileChangeSupportEvent.getPath());
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            LOG.fine("fileModified: " + fileChangeSupportEvent.getPath());
        }
    }
}

