/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.indent.TokenItem;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;

public class FortranIndentSupport {
    protected FortranCodeStyle codeStyle;
    protected TokenSequence<FortranTokenId> ts;

    protected TokenItem findImportantToken(TokenItem tokenItem, TokenItem tokenItem2, boolean bl) {
        if (bl) {
            if (tokenItem != null && tokenItem.equals(tokenItem2)) {
                return null;
            }
            tokenItem = this.getPreviousToken(tokenItem);
            if (tokenItem2 != null) {
                tokenItem2 = tokenItem2.getPrevious();
            }
        }
        while (tokenItem != null && !tokenItem.equals(tokenItem2)) {
            if (this.isImportant(tokenItem)) {
                return tokenItem;
            }
            tokenItem = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        }
        return null;
    }

    protected TokenItem getPreviousToken(TokenItem tokenItem) {
        if (tokenItem == null) {
            this.ts.moveEnd();
            while (this.ts.movePrevious()) {
                if (this.ts.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
                return new TokenItem(this.ts);
            }
            return null;
        }
        return tokenItem.getPrevious();
    }

    private boolean isImportant(TokenItem tokenItem) {
        return !this.isComment(tokenItem) && !this.isWhitespace(tokenItem);
    }

    public boolean isComment(TokenItem tokenItem) {
        return tokenItem.getTokenID() == FortranTokenId.LINE_COMMENT_FIXED || tokenItem.getTokenID() == FortranTokenId.LINE_COMMENT_FREE;
    }

    private boolean isWhitespace(TokenItem tokenItem) {
        return "whitespace".equals(tokenItem.getTokenID().primaryCategory());
    }

    public boolean isFreeFormatComment(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == FortranTokenId.LINE_COMMENT_FREE;
    }

    public boolean isFixedFormatComment(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == FortranTokenId.LINE_COMMENT_FIXED;
    }

    public boolean isPreprocessor(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == FortranTokenId.PREPROCESSOR_DIRECTIVE;
    }

    public boolean isFixedFormatLabel(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == FortranTokenId.NUM_LITERAL_INT && !this.getFreeFormat() && this.getTokenColumn(tokenItem) + tokenItem.getImage().length() <= 5;
    }

    public boolean isFixedFormatLineContinuation(TokenItem tokenItem) {
        return tokenItem != null && (tokenItem.getTokenID() == FortranTokenId.OP_PLUS || tokenItem.getTokenID() == FortranTokenId.OP_MINUS) && !this.getFreeFormat() && this.getTokenColumn(tokenItem) == 5;
    }

    public FortranTokenId getWhitespaceTokenID() {
        return FortranTokenId.WHITESPACE;
    }

    public boolean canModifyWhitespace(TokenItem tokenItem) {
        switch (tokenItem.getTokenID()) {
            case WHITESPACE: {
                return true;
            }
        }
        return false;
    }

    public TokenItem findLineStartToken(TokenItem tokenItem) {
        if (tokenItem != null) {
            tokenItem = this.findLineStart(tokenItem);
            while (tokenItem.getTokenID() == FortranTokenId.WHITESPACE) {
                TokenItem tokenItem2 = tokenItem.getNext();
                if (tokenItem2 == null) {
                    return tokenItem;
                }
                tokenItem = tokenItem2;
            }
            return tokenItem;
        }
        return tokenItem;
    }

    public TokenItem findLineStart(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem.getPrevious();
        if (tokenItem2 == null) {
            return tokenItem;
        }
        while (true) {
            switch (tokenItem2.getTokenID()) {
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: 
                case NEW_LINE: {
                    return tokenItem2.getNext();
                }
            }
            TokenItem tokenItem3 = tokenItem2.getPrevious();
            if (tokenItem3 == null) {
                return tokenItem2;
            }
            tokenItem2 = tokenItem3;
        }
    }

    public boolean isIfThenStatement(TokenItem tokenItem) {
        boolean bl = false;
        while (tokenItem != null) {
            switch (tokenItem.getTokenID()) {
                case NEW_LINE: {
                    return bl;
                }
                case KW_THEN: {
                    bl = true;
                    break;
                }
                case WHITESPACE: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
            tokenItem = tokenItem.getNext();
        }
        return false;
    }

    public TokenItem findMatchingToken(TokenItem tokenItem, FortranTokenId fortranTokenId, FortranTokenId fortranTokenId2) {
        int n = 0;
        while (true) {
            TokenItem tokenItem2;
            FortranTokenId fortranTokenId3;
            TokenItem tokenItem3 = this.findImportantToken(tokenItem, null, true);
            TokenItem tokenItem4 = tokenItem = this.findLineStartToken(tokenItem3);
            if (tokenItem == null) {
                return null;
            }
            if (this.isFixedFormatLabel(tokenItem4)) {
                while ((tokenItem4 = tokenItem4.getNext()).getTokenID() == FortranTokenId.WHITESPACE) {
                }
            }
            if ((fortranTokenId3 = tokenItem4.getTokenID()) == FortranTokenId.KW_END) {
                tokenItem2 = tokenItem4.getNext();
                while (tokenItem2.getTokenID() == FortranTokenId.WHITESPACE) {
                    if ((tokenItem2 = tokenItem2.getNext()) != null) continue;
                    return null;
                }
                if (tokenItem2.getTokenID() != fortranTokenId) continue;
                ++n;
                continue;
            }
            if (fortranTokenId3 == fortranTokenId2) {
                ++n;
                continue;
            }
            if (fortranTokenId3 != fortranTokenId) continue;
            if (fortranTokenId == FortranTokenId.KW_IF && fortranTokenId2 == FortranTokenId.KW_ENDIF) {
                TokenItem tokenItem5;
                tokenItem2 = tokenItem4;
                do {
                    if ((tokenItem2 = tokenItem2.getNext()) != null) continue;
                    return null;
                } while ((tokenItem2.getImage().indexOf(10) <= -1 || this.isFixedFormatLineContinuation(this.findLineStartToken(tokenItem5 = tokenItem2.getNext()))) && tokenItem2.getTokenID() != FortranTokenId.KW_THEN);
                if (tokenItem2.getImage().indexOf(10) > -1) {
                    continue;
                }
            } else if (fortranTokenId == FortranTokenId.KW_TYPE && fortranTokenId2 == FortranTokenId.KW_ENDTYPE && (tokenItem2 = this.findImportantToken(tokenItem4.getNext(), null, false)) != null && tokenItem2.getTokenID() == FortranTokenId.LPAREN) continue;
            if (n-- == 0) break;
        }
        return tokenItem;
    }

    public int getTokenIndent(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        TokenItem tokenItem3 = this.findLineFirstNonWhitespace(tokenItem2);
        if (tokenItem3 != null) {
            TokenItem tokenItem4 = tokenItem3;
            if (this.isFixedFormatLabel(tokenItem4) || this.isFixedFormatLineContinuation(tokenItem4)) {
                while ((tokenItem4 = tokenItem4.getNext()) != null && tokenItem4.getTokenID() == this.getWhitespaceTokenID()) {
                }
                TokenItem tokenItem5 = tokenItem3 = tokenItem4 == null || tokenItem4.getImage().length() > 0 ? null : tokenItem4;
            }
            if (tokenItem3 != null) {
                tokenItem2 = tokenItem3;
            }
        }
        return this.getTokenColumn(tokenItem2);
    }

    public TokenItem findLineFirstNonWhitespace(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findLineStartToken(tokenItem);
        if (tokenItem2 == null) {
            return null;
        }
        return this.moveToFirstLineImportantToken(tokenItem2);
    }

    protected TokenItem moveToFirstLineImportantToken(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        while (tokenItem2 != null) {
            switch (tokenItem2.getTokenID()) {
                case NEW_LINE: {
                    return tokenItem;
                }
                case WHITESPACE: {
                    break;
                }
                default: {
                    return tokenItem2;
                }
            }
            tokenItem = tokenItem2;
            tokenItem2 = tokenItem.getNext();
        }
        return tokenItem;
    }

    public int findInlineSpacing(TokenItem tokenItem) {
        int n = 0;
        TokenItem tokenItem2 = this.findLineStartToken(tokenItem);
        if (this.isFixedFormatLabel(tokenItem2)) {
            n = 4 - tokenItem.getImage().length();
            tokenItem2 = tokenItem2.getNext();
        }
        TokenItem tokenItem3 = this.findImportantToken(tokenItem, null, true);
        tokenItem2 = this.findLineStartToken(tokenItem3);
        while (this.isFixedFormatLineContinuation(tokenItem2) || this.isPreprocessor(tokenItem2) || tokenItem2.getTokenID() == FortranTokenId.KW_ENTRY) {
            tokenItem3 = this.findImportantToken(tokenItem2, null, true);
            tokenItem2 = this.findLineStartToken(tokenItem3);
        }
        while (this.isFixedFormatLabel(tokenItem2) || tokenItem2.getTokenID() == FortranTokenId.WHITESPACE) {
            tokenItem2 = tokenItem2.getNext();
        }
        while (this.isFixedFormatLineContinuation(tokenItem) || this.isFixedFormatLabel(tokenItem) || tokenItem.getTokenID() == FortranTokenId.WHITESPACE) {
            tokenItem = tokenItem.getNext();
        }
        if (tokenItem.getTokenID() == FortranTokenId.KW_SUBROUTINE || tokenItem.getTokenID() == FortranTokenId.KW_ENTRY || tokenItem.getTokenID() == FortranTokenId.KW_FUNCTION) {
            return 6;
        }
        if (tokenItem.getImage().length() > 2 && tokenItem.getImage().substring(0, 3).equalsIgnoreCase("end") || tokenItem.getTokenID() == FortranTokenId.KW_ELSE || tokenItem.getTokenID() == FortranTokenId.KW_ELSEIF) {
            n -= this.getShiftWidth();
        }
        return Math.max(6, this.getTokenColumn(tokenItem2) + n);
    }

    protected boolean getFreeFormat() {
        return this.codeStyle.isFreeFormatFortran();
    }

    protected int getTabSize() {
        return this.codeStyle.getTabSize();
    }

    protected int getShiftWidth() {
        return this.codeStyle.indentSize();
    }

    protected int go(TokenItem tokenItem) {
        TokenSequence<FortranTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n = tokenSequence.index();
        tokenSequence.moveIndex(tokenItem.index());
        tokenSequence.moveNext();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenColumn(TokenItem tokenItem) {
        TokenSequence<FortranTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n = this.go(tokenItem);
        try {
            int n2 = 0;
            block8: while (tokenSequence.movePrevious()) {
                switch ((FortranTokenId)tokenSequence.token().id()) {
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: 
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n3 = n2;
                        return n3;
                    }
                    case WHITESPACE: {
                        String string = ((Object)tokenSequence.token().text()).toString();
                        for (int i = 0; i < string.length(); ++i) {
                            char c = string.charAt(i);
                            if (c == '\t') {
                                n2 = (n2 / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++n2;
                        }
                        continue block8;
                    }
                }
                n2 += tokenSequence.token().length();
            }
            int n4 = n2;
            return n4;
        }
        finally {
            tokenSequence.moveIndex(n);
            tokenSequence.moveNext();
        }
    }
}

