/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranBracesStack;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranContextDetector;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranDiffLinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranPreprocessorFormatter;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranStackEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranReformatterImpl {
    final FortranContextDetector ts;
    final FortranCodeStyle codeStyle;
    final FortranDiffLinkedList diffs = new FortranDiffLinkedList();
    final FortranBracesStack braces;
    private FortranPreprocessorFormatter preprocessorFormatter;
    private final int startOffset;
    private final int endOffset;
    private int tabSize;
    private int indentAfterLabel;

    FortranReformatterImpl(TokenSequence<FortranTokenId> tokenSequence, int n, int n2, FortranCodeStyle fortranCodeStyle) {
        this.braces = new FortranBracesStack(fortranCodeStyle);
        this.tabSize = fortranCodeStyle.getTabSize();
        if (this.tabSize <= 1) {
            this.tabSize = 8;
        }
        this.ts = new FortranContextDetector(tokenSequence, this.diffs, this.braces, this.tabSize);
        this.startOffset = n;
        this.endOffset = n2;
        this.codeStyle = fortranCodeStyle;
        this.preprocessorFormatter = new FortranPreprocessorFormatter(this);
    }

    LinkedList<FortranReformatter.Diff> reformat() {
        this.ts.moveStart();
        Token<FortranTokenId> token = this.ts.lookPrevious();
        boolean bl = true;
        while (this.ts.moveNext() && this.ts.offset() <= this.endOffset) {
            Token<FortranTokenId> token2 = this.ts.token();
            FortranTokenId fortranTokenId = (FortranTokenId)token2.id();
            if (token != null && token.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE && fortranTokenId != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.analyzeLine(token, token2);
            }
            if (bl && token2.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.analyzeLine(token, token2);
            }
            bl = false;
            switch (fortranTokenId) {
                case KW_CONTAINS: {
                    System.out.println("");
                    break;
                }
                case PREPROCESSOR_DIRECTIVE: {
                    this.preprocessorFormatter.indentPreprocessor(token2);
                    break;
                }
                case NEW_LINE: {
                    this.analyzeLine(token, token2);
                    break;
                }
                case WHITESPACE: {
                    if (!this.doFormat()) break;
                    this.whiteSpaceFormat(token, token2);
                    break;
                }
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: {
                    if (!this.doFormat()) break;
                    this.reformatBlockComment(token, token2);
                    break;
                }
                case LPAREN: {
                    ++this.braces.parenDepth;
                    if (!this.doFormat()) break;
                    this.formatLeftParen(token, token2);
                    if (token == null || token.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(token2, true);
                    break;
                }
                case RPAREN: {
                    --this.braces.parenDepth;
                    if (this.braces.parenDepth < 0) {
                        this.braces.parenDepth = 0;
                    }
                    if (!this.doFormat()) break;
                    this.formatRightParen(token, token2);
                    break;
                }
                case IDENTIFIER: {
                    if (!this.doFormat()) break;
                    Token<FortranTokenId> token3 = this.ts.lookNextImportant();
                    if (token3 != null && token3.id() == FortranTokenId.COLON && this.braces.parenDepth == 0) {
                        this.indentLabel(token);
                    }
                    if (token == null || token.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(token2, true);
                    break;
                }
                case STRING_LITERAL: {
                    if (!this.doFormat() || token == null || token.id() != FortranTokenId.RPAREN) break;
                    this.spaceBefore(token2, true);
                    break;
                }
                case COMMA: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceBeforeComma());
                    this.spaceAfter(token2, this.codeStyle.spaceAfterComma());
                    break;
                }
                case COLON: {
                    if (!this.doFormat()) break;
                    this.processColumn(token, token2);
                    break;
                }
                case KWOP_NOT: {
                    if (!this.doFormat()) break;
                    this.spaceAfter(token2, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_PLUS: 
                case OP_MINUS: {
                    if (!this.doFormat()) break;
                    FortranContextDetector.OperatorKind operatorKind = this.ts.getOperatorKind(token2);
                    if (operatorKind == FortranContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (operatorKind != FortranContextDetector.OperatorKind.UNARY) break;
                    this.spaceAfter(token2, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_MUL: {
                    if (!this.doFormat()) break;
                    FortranContextDetector.OperatorKind operatorKind = this.ts.getOperatorKind(token2);
                    if (operatorKind == FortranContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (operatorKind != FortranContextDetector.OperatorKind.UNARY) break;
                    this.spaceAfter(token2, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case OP_CONCAT: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                    this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case KWOP_GT: 
                case KWOP_GE: 
                case OP_GT_EQ: 
                case KWOP_LT: 
                case OP_LT: 
                case KWOP_LE: 
                case OP_LT_EQ: 
                case KWOP_EQ: 
                case OP_LOG_EQ: 
                case KWOP_NE: 
                case OP_NOT_EQ: 
                case OP_LT_GT: 
                case PERCENT: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                    this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case OP_GT: {
                    if (!this.doFormat()) break;
                    if (token == null || token.id() != FortranTokenId.EQ) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                    }
                    this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case EQ: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceAroundAssignOps());
                    Token<FortranTokenId> token4 = this.ts.lookNext();
                    if (token4 != null && token4.id() == FortranTokenId.OP_GT) break;
                    this.spaceAfter(token2, this.codeStyle.spaceAroundAssignOps());
                    break;
                }
                case KW_IF: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeIfParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_ELSEIF: {
                    if (!this.doFormat()) break;
                    this.formatElse(token);
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeIfParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_ELSEWHERE: 
                case KW_ELSE: {
                    if (!this.doFormat()) break;
                    this.formatElse(token);
                    break;
                }
                case KW_WHILE: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceBeforeWhile());
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeWhileParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_FORALL: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeForParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_SELECT: 
                case KW_SELECTCASE: 
                case KW_SELECTTYPE: {
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeSwitchParen(), FortranTokenId.LPAREN);
                    break;
                }
                case KW_DEFAULT: 
                case KW_CASE: {
                    break;
                }
                case KW_CONTINUE: {
                    break;
                }
                case NUM_LITERAL_INT: {
                    int n;
                    FortranStackEntry fortranStackEntry;
                    if (this.codeStyle.isFreeFormatFortran() || !this.ts.isFirstLineToken()) break;
                    while ((fortranStackEntry = this.braces.peek()) != null && fortranStackEntry.getKind() == FortranTokenId.KW_DO && fortranStackEntry.getLabel() == Integer.parseInt(((Object)token2.text()).toString())) {
                        this.braces.pop(this.ts);
                    }
                    if (!this.doFormat() || (n = this.indentAfterLabel - this.ts.getTokenPosition() - this.ts.token().length()) <= 0) break;
                    Token<FortranTokenId> token5 = this.ts.lookNext();
                    if (token5 == null) {
                        this.ts.addAfterCurrent(token2, 0, n, true);
                        break;
                    }
                    if (token5.id() == FortranTokenId.WHITESPACE) {
                        this.ts.replaceNext(token2, token5, 0, n, true);
                        this.ts.moveNext();
                        token2 = this.ts.token();
                        break;
                    }
                    this.ts.addAfterCurrent(token2, 0, n, true);
                    break;
                }
                case SEMICOLON: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, false);
                    this.spaceAfter(token2, true);
                    break;
                }
                case DOUBLECOLON: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, true);
                    this.spaceAfter(token2, true);
                }
            }
            token = token2;
        }
        return this.diffs.getStorage();
    }

    int getParentIndent() {
        return this.continuationIndent(this.braces.getSelfIndent());
    }

    int getCaseIndent() {
        if (this.codeStyle.indentCasesFromSwitch()) {
            return this.getParentIndent() + this.codeStyle.indentSize();
        }
        return this.getParentIndent();
    }

    int getIndent() {
        return this.continuationIndent(this.braces.getIndent());
    }

    int continuationIndent(int n) {
        return n;
    }

    private void analyzeLine(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        Token<FortranTokenId> token3 = null;
        if (token == null || token.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            switch ((FortranTokenId)token2.id()) {
                case PREPROCESSOR_DIRECTIVE: 
                case NEW_LINE: 
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: {
                    break;
                }
                case WHITESPACE: {
                    token3 = this.ts.lookNextLineImportant();
                    break;
                }
                default: {
                    token3 = token2;
                    break;
                }
            }
        } else {
            token3 = this.ts.lookNextLineImportant();
        }
        boolean bl = false;
        if (token3 != null) {
            switch ((FortranTokenId)token3.id()) {
                case KW_ENDASSOCIATE: 
                case KW_ENDBLOCK: 
                case KW_ENDBLOCKDATA: 
                case KW_ENDDO: 
                case KW_ENDENUM: 
                case KW_ENDFILE: 
                case KW_ENDFORALL: 
                case KW_ENDFUNCTION: 
                case KW_ENDIF: 
                case KW_ENDINTERFACE: 
                case KW_ENDMAP: 
                case KW_ENDMODULE: 
                case KW_ENDPROGRAM: 
                case KW_ENDSELECT: 
                case KW_ENDSTRUCTURE: 
                case KW_ENDSUBROUTINE: 
                case KW_ENDTYPE: 
                case KW_ENDUNION: 
                case KW_ENDWHERE: 
                case KW_ENDWHILE: 
                case KW_END: {
                    this.braces.pop(this.ts);
                    bl = true;
                }
            }
        }
        if (this.doFormat()) {
            this.newLineFormat(token, token2, token3);
        }
        if (token3 != null) {
            FortranTokenId fortranTokenId;
            if (!this.codeStyle.isFreeFormatFortran() && token3.id() == FortranTokenId.NUM_LITERAL_INT && (fortranTokenId = this.ts.lookNextLineImportant(2)) != null) {
                token3 = fortranTokenId;
            }
            switch ((FortranTokenId)token3.id()) {
                case KW_INTERFACE: 
                case KW_STRUCTURE: 
                case KW_UNION: 
                case KW_ENUM: 
                case KW_TYPE: {
                    fortranTokenId = this.ts.lookNextLineImportantAfter((FortranTokenId)token3.id());
                    if (fortranTokenId != null && fortranTokenId.id() == FortranTokenId.LPAREN) break;
                    this.braces.push(token3, this.ts);
                    break;
                }
                case KW_PROCEDURE: 
                case KW_SUBROUTINE: 
                case KW_FUNCTION: {
                    fortranTokenId = this.ts.lookNextLineImportantAfter((FortranTokenId)token3.id());
                    if (fortranTokenId == null || fortranTokenId.id() != FortranTokenId.IDENTIFIER || (fortranTokenId = this.ts.lookPreviousLineImportant()) != null && fortranTokenId.id() == FortranTokenId.KW_MODULE) break;
                    this.braces.push(token3, this.ts);
                    break;
                }
                case KW_MODULE: {
                    fortranTokenId = this.ts.hasLineToken(FortranTokenId.KW_FUNCTION, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_PROCEDURE);
                    if (fortranTokenId != null) break;
                    this.braces.push(token3, this.ts);
                    break;
                }
                case KW_PROGRAM: 
                case KW_BLOCK: 
                case KW_BLOCKDATA: 
                case KW_MAP: {
                    this.braces.push(token3, this.ts);
                    break;
                }
                case KW_IF: {
                    if (!this.ts.hasLineToken(FortranTokenId.KW_THEN)) break;
                    this.braces.push(token3, this.ts);
                    break;
                }
                case KW_ELSEIF: 
                case KW_ELSE: 
                case KW_WHILE: 
                case KW_FORALL: 
                case KW_SELECT: 
                case KW_SELECTCASE: 
                case KW_SELECTTYPE: 
                case KW_WHERE: 
                case KW_DO: {
                    this.braces.push(token3, this.ts);
                    break;
                }
                default: {
                    if (bl || (fortranTokenId = this.ts.hasLineToken(FortranTokenId.KW_FUNCTION, FortranTokenId.KW_SUBROUTINE)) == null) break;
                    this.braces.push(fortranTokenId);
                    break;
                }
            }
        }
    }

    private void formatElse(Token<FortranTokenId> token) {
        if (this.ts.isFirstLineToken()) {
            FortranDiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                boolean bl = false;
                if (diffResult.after != null) {
                    diffResult.after.replaceSpaces(this.getParentIndent(), true);
                    bl = true;
                }
                if (diffResult.replace != null && token.id() == FortranTokenId.WHITESPACE) {
                    if (!bl) {
                        diffResult.replace.replaceSpaces(this.getParentIndent(), true);
                        bl = true;
                    } else {
                        diffResult.replace.replaceSpaces(0, false);
                    }
                }
                if (diffResult.before != null && token.id() == FortranTokenId.WHITESPACE) {
                    if (!bl) {
                        diffResult.before.replaceSpaces(this.getParentIndent(), true);
                        bl = true;
                    } else {
                        diffResult.before.replaceSpaces(0, false);
                    }
                }
                if (bl) {
                    return;
                }
            }
            if (token.id() == FortranTokenId.WHITESPACE) {
                Token<FortranTokenId> token2 = this.ts.lookPrevious(2);
                if (token2 != null && token2.id() == FortranTokenId.NEW_LINE) {
                    this.ts.replacePrevious(token, 0, this.getParentIndent(), true);
                } else {
                    this.ts.replacePrevious(token, 0, 0, false);
                }
            } else if (token.id() == FortranTokenId.NEW_LINE || token.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                this.ts.addBeforeCurrent(0, this.getParentIndent(), true);
            }
        }
    }

    private void indentLabel(Token<FortranTokenId> token) {
        int n = 0;
        if (!this.codeStyle.absoluteLabelIndent()) {
            n = this.braces.getSelfIndent();
        }
        if (this.doFormat()) {
            if (!this.ts.isFirstLineToken()) {
                this.ts.addBeforeCurrent(1, 0, true);
            } else {
                FortranDiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult == null) {
                    if (token != null && token.id() == FortranTokenId.WHITESPACE) {
                        this.ts.replacePrevious(token, 0, n, true);
                    }
                } else {
                    if (diffResult.after != null) {
                        diffResult.after.replaceSpaces(n, true);
                    }
                    if (diffResult.replace != null) {
                        diffResult.replace.replaceSpaces(n, true);
                    }
                }
            }
        }
    }

    private void newLineFormat(Token<FortranTokenId> token, Token<FortranTokenId> token2, Token<FortranTokenId> token3) {
        boolean bl;
        boolean bl2 = bl = token3 != null && token3.id() == FortranTokenId.NUM_LITERAL_INT && !this.codeStyle.isFreeFormatFortran();
        if (token != null && token.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            boolean bl3 = false;
            FortranDiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                if (diffResult.after != null) {
                    diffResult.after.replaceSpaces(0, false);
                    if (diffResult.replace != null) {
                        diffResult.replace.replaceSpaces(0, false);
                    }
                    bl3 = true;
                } else if (diffResult.replace != null) {
                    diffResult.replace.replaceSpaces(0, false);
                    bl3 = true;
                }
            }
            if (!bl3 && token.id() == FortranTokenId.WHITESPACE) {
                this.ts.replacePrevious(token, 0, 0, false);
            }
        } else {
            int n;
            if (bl) {
                n = 1;
                this.indentAfterLabel = this.getIndent();
            } else {
                n = this.getIndent();
            }
            if (token2.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceCurrent(token2, 0, n, true);
            } else if (n > 0) {
                this.ts.addBeforeCurrent(0, n, true);
            }
            return;
        }
        Token<FortranTokenId> token4 = this.ts.lookNext();
        if (token4 != null) {
            if (token4.id() == FortranTokenId.NEW_LINE) {
                return;
            }
            int n = -1;
            if (token3 != null) {
                switch ((FortranTokenId)token3.id()) {
                    case KW_DEFAULT: 
                    case KW_CASE: {
                        n = this.getCaseIndent();
                        break;
                    }
                    case KW_CONTAINS: {
                        n = this.getParentIndent();
                    }
                }
            }
            if (n < 0) {
                if (bl) {
                    n = 1;
                    this.indentAfterLabel = this.getIndent();
                } else {
                    n = this.getIndent();
                }
            }
            if (token4.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceNext(token2, token4, 0, n, true);
            } else if (n > 0) {
                this.ts.addAfterCurrent(token2, 0, n, true);
            }
        }
    }

    private void indentNewLine(Token<FortranTokenId> token) {
        if (token.id() == FortranTokenId.NEW_LINE) {
            return;
        }
        Token<FortranTokenId> token2 = this.ts.lookNextLineImportant();
        int n = token2 != null && (token2.id() == FortranTokenId.KW_CASE || token2.id() == FortranTokenId.KW_DEFAULT) ? this.getCaseIndent() : this.getIndent();
        if (token.id() == FortranTokenId.WHITESPACE) {
            this.ts.replaceCurrent(token, 0, n, true);
        } else {
            this.ts.addBeforeCurrent(0, n, true);
        }
    }

    private void processColumn(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        Token<FortranTokenId> token3 = this.ts.lookPreviousImportant();
        if (token3 != null && token3.id() == FortranTokenId.KW_DEFAULT) {
            this.spaceBefore(token, false);
            return;
        }
        Token<FortranTokenId> token4 = this.ts.lookPreviousImportant(2);
        if (token4 != null && token4.id() == FortranTokenId.KW_CASE) {
            this.spaceBefore(token, false);
            return;
        }
        this.spaceBefore(token, false);
    }

    private void reformatBlockComment(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        int n;
        if (!this.ts.isFirstLineToken()) {
            return;
        }
        int n2 = 0;
        if (token == null || token.id() == FortranTokenId.NEW_LINE || token.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
            n2 = 0;
        } else if (token.id() == FortranTokenId.WHITESPACE) {
            CharSequence charSequence = token.text();
            for (n = 0; n < token.length(); ++n) {
                if (charSequence.charAt(n) == ' ') {
                    ++n2;
                    continue;
                }
                if (charSequence.charAt(n) != '\t') continue;
                n2 = (n2 / this.tabSize + 1) * this.tabSize;
            }
        }
        int n3 = this.getIndent();
        n = -1;
        int n4 = -1;
        int n5 = 0;
        CharSequence charSequence = token2.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == '\n') {
                n = i;
                n4 = i;
                n5 = 0;
                continue;
            }
            if (charSequence.charAt(i) == ' ' || charSequence.charAt(i) == '\t') {
                n4 = i;
                if (charSequence.charAt(i) == ' ') {
                    ++n5;
                    continue;
                }
                if (charSequence.charAt(i) != '\t') continue;
                n5 = (n5 / this.tabSize + 1) * this.tabSize;
                continue;
            }
            if (n >= 0) {
                this.addCommentIndent(n, n4, charSequence.charAt(i), n3, n2, n5);
            }
            n = -1;
        }
        this.addCommentIndent(n, n4, '*', n3, n2, n5);
    }

    private void addCommentIndent(int n, int n2, char c, int n3, int n4, int n5) {
        if (n >= 0 && n2 >= n) {
            if (c == '*') {
                this.diffs.addFirst(this.ts.offset() + n + 1, this.ts.offset() + n2 + 1, 0, 1 + n3, true);
            } else {
                int n6 = n3 + n5 - n4;
                if (n6 < 0) {
                    n6 = n3;
                }
                this.diffs.addFirst(this.ts.offset() + n + 1, this.ts.offset() + n2 + 1, 0, n6, true);
            }
        }
    }

    private void whiteSpaceFormat(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        Object object;
        if (token != null) {
            object = this.diffs.getDiffs(this.ts, 0);
            if (object != null) {
                if (object.replace != null) {
                    return;
                }
                if (object.before != null) {
                    this.ts.replaceCurrent(token2, 0, 0, false);
                    return;
                }
            }
            if (token.id() == FortranTokenId.NEW_LINE || token.id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                return;
            }
        }
        if ((object = this.ts.lookNext()) != null && object.id() == FortranTokenId.NEW_LINE) {
            return;
        }
        if (token != null) {
            this.ts.replaceCurrent(token2, 0, 1, false);
        }
    }

    private void spaceBefore(Token<FortranTokenId> token, boolean bl) {
        if (token != null && !this.ts.isFirstLineToken()) {
            if (bl) {
                FortranDiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult != null) {
                    if (diffResult.after != null && !diffResult.after.hasNewLine()) {
                        diffResult.after.replaceSpaces(1, false);
                        if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                            diffResult.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                        diffResult.replace.replaceSpaces(1, false);
                        return;
                    }
                }
                if (token.id() != FortranTokenId.WHITESPACE && token.id() != FortranTokenId.NEW_LINE && token.id() != FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.ts.addBeforeCurrent(0, 1, false);
                }
            } else if (this.canRemoveSpaceBefore(token)) {
                FortranDiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult != null) {
                    if (diffResult.after != null && !diffResult.after.hasNewLine()) {
                        diffResult.after.replaceSpaces(0, false);
                        if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                            diffResult.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                        diffResult.replace.replaceSpaces(0, false);
                        return;
                    }
                }
                if (token.id() == FortranTokenId.WHITESPACE) {
                    this.ts.replacePrevious(token, 0, 0, false);
                }
            }
        }
    }

    private boolean canRemoveSpaceBefore(Token<FortranTokenId> token) {
        Token<FortranTokenId> token2;
        if (token == null) {
            return false;
        }
        if (token.id() == FortranTokenId.WHITESPACE) {
            token2 = this.ts.lookPrevious(2);
            if (token2 == null) {
                return true;
            }
            token = token2;
        }
        token2 = (Token<FortranTokenId>)token.id();
        FortranTokenId fortranTokenId = (FortranTokenId)this.ts.token().id();
        return this.canRemoveSpace((FortranTokenId)token2, fortranTokenId);
    }

    private boolean canRemoveSpace(FortranTokenId fortranTokenId, FortranTokenId fortranTokenId2) {
        if (fortranTokenId == FortranTokenId.IDENTIFIER && fortranTokenId2 == FortranTokenId.IDENTIFIER) {
            return false;
        }
        String string = fortranTokenId2.primaryCategory();
        String string2 = fortranTokenId.primaryCategory();
        if ("keyword".equals(string2)) {
            if ("special".equals(string)) {
                return true;
            }
            return fortranTokenId2 == FortranTokenId.COLON;
        }
        if ("operator".equals(string2)) {
            if ("operator".equals(string)) {
                return fortranTokenId == FortranTokenId.COLON || fortranTokenId2 == FortranTokenId.COLON;
            }
            return true;
        }
        return fortranTokenId != FortranTokenId.IDENTIFIER || !"number".equals(string) && !"literal".equals(string) && !"string".equals(string);
    }

    private boolean canRemoveSpaceAfter(Token<FortranTokenId> token) {
        Token<FortranTokenId> token2;
        Token<FortranTokenId> token3 = this.ts.lookNext();
        if (token3 == null) {
            return false;
        }
        if (token3.id() == FortranTokenId.WHITESPACE) {
            token2 = this.ts.lookNext(2);
            if (token2 == null) {
                return true;
            }
            token3 = token2;
        }
        token2 = (Token<FortranTokenId>)token3.id();
        FortranTokenId fortranTokenId = (FortranTokenId)token.id();
        return this.canRemoveSpace(fortranTokenId, (FortranTokenId)token2);
    }

    private void spaceAfter(Token<FortranTokenId> token, boolean bl) {
        Token<FortranTokenId> token2 = this.ts.lookNext();
        if (token2 != null) {
            if (bl) {
                if (token2.id() != FortranTokenId.WHITESPACE && token2.id() != FortranTokenId.NEW_LINE) {
                    this.ts.addAfterCurrent(token, 0, 1, false);
                }
            } else if (this.canRemoveSpaceAfter(token) && token2.id() == FortranTokenId.WHITESPACE) {
                this.ts.replaceNext(token, token2, 0, 0, false);
            }
        }
    }

    private void spaceAfterBefore(Token<FortranTokenId> token, boolean bl, FortranTokenId fortranTokenId) {
        Token<FortranTokenId> token2 = this.ts.lookNext();
        if (token2 != null) {
            if (token2.id() == FortranTokenId.WHITESPACE) {
                Token<FortranTokenId> token3 = this.ts.lookNext(2);
                if (token3 != null && token3.id() == fortranTokenId && !bl) {
                    this.ts.replaceNext(token, token2, 0, 0, false);
                }
            } else if (token2.id() == fortranTokenId && bl) {
                this.ts.addAfterCurrent(token, 0, 1, false);
            }
        }
    }

    private void formatLeftParen(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        if (token != null) {
            Token<FortranTokenId> token3 = this.ts.lookPreviousStatement();
            if (token3 != null) {
                switch ((FortranTokenId)token3.id()) {
                    case KW_IF: 
                    case KW_ELSEIF: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case KW_FORALL: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case KW_WHILE: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case KW_SELECT: 
                    case KW_SELECTCASE: 
                    case KW_SELECTTYPE: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                }
            }
            if ((token3 = this.ts.lookPreviousImportant()) != null && token3.id() == FortranTokenId.IDENTIFIER) {
                FortranStackEntry fortranStackEntry = this.braces.peek();
                if (fortranStackEntry == null) {
                    this.spaceBefore(token, this.codeStyle.spaceBeforeMethodDeclParen());
                    this.spaceAfter(token2, this.codeStyle.spaceWithinMethodDeclParens());
                    return;
                }
                switch (fortranStackEntry.getKind()) {
                    case KW_UNION: 
                    case KW_ENUM: 
                    case KW_TYPE: {
                        this.spaceBefore(token, this.codeStyle.spaceBeforeMethodDeclParen());
                        this.spaceAfter(token2, this.codeStyle.spaceWithinMethodDeclParens());
                        return;
                    }
                }
                this.spaceBefore(token, this.codeStyle.spaceBeforeMethodCallParen());
                this.spaceAfter(token2, this.codeStyle.spaceWithinMethodCallParens());
                return;
            }
            if (token3 != null && "keyword".equals(((FortranTokenId)token3.id()).primaryCategory())) {
                switch ((FortranTokenId)token3.id()) {
                    case KW_RETURN: {
                        this.spaceBefore(token, this.codeStyle.spaceBeforeKeywordParen());
                        return;
                    }
                }
                return;
            }
            this.spaceAfter(token2, this.codeStyle.spaceWithinParens());
        }
    }

    private void formatRightParen(Token<FortranTokenId> token, Token<FortranTokenId> token2) {
        if (token != null) {
            Token<FortranTokenId> token3 = this.ts.lookPreviousStatement();
            if (token3 != null) {
                switch ((FortranTokenId)token3.id()) {
                    case KW_IF: 
                    case KW_ELSEIF: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case KW_FORALL: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case KW_WHILE: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case KW_SELECT: 
                    case KW_SELECTCASE: 
                    case KW_SELECTTYPE: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                }
            }
            if ((token3 = this.getImportantBeforeBrace()) != null && token3.id() == FortranTokenId.IDENTIFIER) {
                FortranStackEntry fortranStackEntry = this.braces.peek();
                if (fortranStackEntry == null) {
                    this.spaceBefore(token, this.codeStyle.spaceWithinMethodDeclParens());
                    return;
                }
                switch (fortranStackEntry.getKind()) {
                    case KW_TYPE: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinMethodDeclParens());
                        return;
                    }
                }
                this.spaceBefore(token, this.codeStyle.spaceWithinMethodCallParens());
                return;
            }
            this.spaceBefore(token, this.codeStyle.spaceWithinParens());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token<FortranTokenId> getImportantBeforeBrace() {
        int n = this.ts.index();
        try {
            if (this.ts.token().id() == FortranTokenId.RPAREN) {
                int n2 = 1;
                while (this.ts.movePrevious()) {
                    switch ((FortranTokenId)this.ts.token().id()) {
                        case RPAREN: {
                            ++n2;
                            break;
                        }
                        case LPAREN: {
                            if (--n2 > 0) break;
                            Token<FortranTokenId> token = this.ts.lookPreviousImportant();
                            return token;
                        }
                    }
                }
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    boolean doFormat() {
        return this.ts.offset() >= this.startOffset;
    }
}

