/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.netbeans.modules.editor.settings.storage.fontscolors.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.fontscolors.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.keybindings.KeyBindingSettingsImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSettingsImpl
extends EditorSettings {
    private static final Logger LOG = Logger.getLogger(EditorSettingsImpl.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_HIGHLIGHT_COLORINGS = "editorFontColors";
    public static final String PROP_TOKEN_COLORINGS = "fontColors";
    public static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    public static final String EDITORS_FOLDER = "Editors";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    public static final String TEXT_BASE_MIME_TYPE = "text/base";
    private static final String[] EMPTY = new String[0];
    private static EditorSettingsImpl instance = null;
    private String currentFontColorProfile;
    private final Map<String, Map<String, AttributeSet>> highlightings = new HashMap<String, Map<String, AttributeSet>>();
    private final StorageImpl<String, AttributeSet> highlightingsStorage = new StorageImpl<String, AttributeSet>(new ColoringStorage(false), null);
    private String currentKeyMapProfile;

    public static synchronized EditorSettingsImpl getInstance() {
        if (instance == null) {
            instance = new EditorSettingsImpl();
        }
        return instance;
    }

    public void notifyMimeTypesChange(Object object, Object object2) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "mime-types", object, object2));
    }

    @Override
    public Set<String> getAllMimeTypes() {
        return MimeTypesTracker.get(null, EDITORS_FOLDER).getMimeTypes();
    }

    @Override
    public Set<String> getMimeTypes() {
        return MimeTypesTracker.get("FontsColors", EDITORS_FOLDER).getMimeTypes();
    }

    @Override
    public String getLanguageName(String string) {
        return MimeTypesTracker.get(null, EDITORS_FOLDER).getMimeTypeDisplayName(string);
    }

    public void notifyTokenFontColorChange(MimePath mimePath, String string) {
        this.pcs.firePropertyChange(PROP_TOKEN_COLORINGS, mimePath, string);
    }

    @Override
    public Set<String> getFontColorProfiles() {
        return ProfilesTracker.get("FontsColors", EDITORS_FOLDER).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomFontColorProfile(String string) {
        ProfilesTracker profilesTracker = ProfilesTracker.get("FontsColors", EDITORS_FOLDER);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription != null && !profileDescription.isRollbackAllowed();
    }

    @Override
    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            Object object;
            FileObject fileObject = FileUtil.getConfigFile((String)EDITORS_FOLDER);
            if (fileObject != null && (object = fileObject.getAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE)) instanceof String) {
                this.currentFontColorProfile = (String)object;
            }
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = DEFAULT_PROFILE;
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = DEFAULT_PROFILE;
        }
        return this.currentFontColorProfile;
    }

    @Override
    public void setCurrentFontColorProfile(String string) {
        String string2 = this.getCurrentFontColorProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentFontColorProfile = string;
        FileObject fileObject = FileUtil.getConfigFile((String)EDITORS_FOLDER);
        if (fileObject != null) {
            try {
                fileObject.setAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE, (Object)string);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't persist change in current font&colors profile.", iOException);
            }
        }
        this.pcs.firePropertyChange(FATTR_CURRENT_FONT_COLOR_PROFILE, string2, this.currentFontColorProfile);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColors(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColors(string);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColorDefaults(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColorDefaults(string);
    }

    @Override
    public void setDefaultFontColors(String string, Collection<AttributeSet> collection) {
        this.getFontColorSettings(new String[0]).setAllFontColors(string, collection);
    }

    @Override
    public Map<String, AttributeSet> getHighlightings(String string) {
        Map<String, AttributeSet> map;
        boolean bl = string.startsWith("test");
        string = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(string);
        if (!this.highlightings.containsKey(string)) {
            map = null;
            try {
                map = this.highlightingsStorage.load(MimePath.EMPTY, bl ? DEFAULT_PROFILE : string, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            Map<String, AttributeSet> map2 = null;
            if (!bl && !DEFAULT_PROFILE.equals(string)) {
                try {
                    map2 = this.highlightingsStorage.load(MimePath.EMPTY, DEFAULT_PROFILE, false);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
            if (map2 != null) {
                hashMap.putAll(map2);
            }
            if (map != null) {
                hashMap.putAll(map);
            }
            map = Collections.unmodifiableMap(hashMap);
            this.highlightings.put(string, map);
        }
        return (map = this.highlightings.get(string)) == null ? Collections.emptyMap() : map;
    }

    @Override
    public Map<String, AttributeSet> getHighlightingDefaults(String string) {
        string = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(string);
        try {
            return this.highlightingsStorage.load(MimePath.EMPTY, string, true);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return Collections.emptyMap();
        }
    }

    @Override
    public void setHighlightings(String string, Map<String, AttributeSet> map) {
        boolean bl = string.startsWith("test");
        string = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(string);
        if (map == null) {
            try {
                this.highlightingsStorage.delete(MimePath.EMPTY, string, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            this.highlightings.remove(string);
        } else {
            Map<String, AttributeSet> map2 = Utils.immutize(map, new Object[0]);
            if (!bl) {
                try {
                    this.highlightingsStorage.save(MimePath.EMPTY, string, false, map2);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            this.highlightings.put(string, map2);
        }
        this.pcs.firePropertyChange(PROP_HIGHLIGHT_COLORINGS, MimePath.EMPTY, string);
    }

    @Override
    public Set<String> getKeyMapProfiles() {
        return ProfilesTracker.get("Keybindings", EDITORS_FOLDER).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomKeymapProfile(String string) {
        ProfilesTracker profilesTracker = ProfilesTracker.get("Keybindings", EDITORS_FOLDER);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null || !profileDescription.isRollbackAllowed();
    }

    @Override
    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            Object object;
            FileObject fileObject = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
            if (fileObject != null && (object = fileObject.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
                this.currentKeyMapProfile = (String)object;
            }
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = DEFAULT_PROFILE;
            }
        }
        return this.currentKeyMapProfile;
    }

    @Override
    public void setCurrentKeyMapProfile(String string) {
        String string2 = this.getCurrentKeyMapProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentKeyMapProfile = string;
        try {
            FileObject fileObject = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
            if (fileObject == null) {
                fileObject = FileUtil.getConfigRoot().createFolder(KEYMAPS_FOLDER);
            }
            fileObject.setAttribute(FATTR_CURRENT_KEYMAP_PROFILE, (Object)string);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't persist change in current keybindings profile.", iOException);
        }
        this.pcs.firePropertyChange("currentKeyMapProfile", string2, this.currentKeyMapProfile);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private EditorSettingsImpl() {
    }

    @Override
    public KeyBindingSettingsFactory getKeyBindingSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return KeyBindingSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    @Override
    public FontColorSettingsFactory getFontColorSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return FontColorSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    private String[] filter(String[] stringArray) {
        if (stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            if (stringArray[0].contains(TEXT_BASE_MIME_TYPE)) {
                if (stringArray.length == 1) {
                    stringArray2 = EMPTY;
                } else {
                    stringArray2 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (stringArray[0].startsWith("test")) {
                stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[0] = stringArray[0].substring(stringArray[0].indexOf(95) + 1);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return stringArray2;
        }
        return stringArray;
    }

    private MimePath filter(MimePath mimePath) {
        if (mimePath.size() > 0) {
            MimePath mimePath2 = mimePath;
            String string = mimePath.getMimeType(0);
            if (string.contains(TEXT_BASE_MIME_TYPE)) {
                if (mimePath.size() == 1) {
                    mimePath2 = MimePath.EMPTY;
                } else {
                    String string2 = mimePath.getPath().substring(string.length() + 1);
                    mimePath2 = MimePath.parse((String)string2);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (string.startsWith("test")) {
                String string3 = string.substring(string.indexOf(95) + 1);
                String string4 = string3 + mimePath.getPath().substring(string.length() + 1);
                mimePath2 = MimePath.parse((String)string4);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return mimePath2;
        }
        return mimePath;
    }
}

