/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.mobility.j2meunit.TestUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCreator {
    private Map<JUnitPlugin.CreateTestParam, Object> parameters;
    private FileObject testSourceRoot;
    private Project mProject;
    private AntProjectHelper aph;
    private static final String J2MEUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String J2MEUNIT_FRAMEWORK_PACKAGE_NAME = "jmunit.framework.cldc10";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final EnumSet<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private static final EnumSet<Modifier> NO_MODIFIERS = EnumSet.noneOf(Modifier.class);
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private Set<Modifier> methodAccessModifiers = TestUtils.createModifierSet(Modifier.PUBLIC, Modifier.PROTECTED);
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateSetUp = true;
    private boolean generateTearDown = true;

    public TestCreator(Map<JUnitPlugin.CreateTestParam, Object> map, FileObject fileObject, Project project, AntProjectHelper antProjectHelper) {
        this.parameters = map;
        this.testSourceRoot = fileObject;
        this.aph = antProjectHelper;
        this.mProject = project;
        this.skipPkgPrivateClasses = !Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS));
        this.skipAbstractClasses = !Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_ABSTRACT_CLASS));
        this.skipExceptionClasses = !Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_EXCEPTION_CLASS));
        this.methodAccessModifiers.clear();
        if (Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_PUBLIC))) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_PROTECTED))) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE));
        this.generateDefMethodBody = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_METHOD_BODIES));
        this.generateMethodJavadoc = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_JAVADOC));
        this.generateSourceCodeHints = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_CODE_HINT));
        this.generateSetUp = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_SETUP));
        this.generateTearDown = Boolean.TRUE.equals(map.get(JUnitPlugin.CreateTestParam.INC_TEAR_DOWN));
    }

    public void setSkipPackagePrivateClasses(boolean bl) {
        this.skipPkgPrivateClasses = bl;
    }

    public void setSkipAbstractClasses(boolean bl) {
        this.skipAbstractClasses = bl;
    }

    public void setSkipExceptionClasses(boolean bl) {
        this.skipExceptionClasses = bl;
    }

    public void setTestPublicMethods(boolean bl) {
        if (bl) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PUBLIC);
        }
    }

    public void setTestProtectedMethods(boolean bl) {
        if (bl) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PROTECTED);
        }
    }

    public void setTestPackagePrivateMethods(boolean bl) {
        this.testPkgPrivateMethods = bl;
    }

    public void setGenerateDefMethodBody(boolean bl) {
        this.generateDefMethodBody = bl;
    }

    public void setGenerateMethodJavadoc(boolean bl) {
        this.generateMethodJavadoc = bl;
    }

    public void setGenerateMethodBodyComment(boolean bl) {
        this.generateSourceCodeHints = bl;
    }

    public void setGenerateSetUp(boolean bl) {
        this.generateSetUp = bl;
    }

    public void setGenerateTearDown(boolean bl) {
        this.generateTearDown = bl;
    }

    public FileObject[] generateTests(FileObject[] fileObjectArray) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        Enumeration<FileObject> enumeration = Collections.enumeration(Arrays.asList(fileObjectArray));
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            if (fileObject.isFolder()) {
                Enumeration enumeration2 = fileObject.getData(true);
                while (enumeration2.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration2.nextElement();
                    if (!TestUtils.isTestable(fileObject2)) continue;
                    linkedList.addAll(this.generateFromSingleSource(fileObject2));
                }
                continue;
            }
            if (!TestUtils.isTestable(fileObject)) continue;
            linkedList.addAll(this.generateFromSingleSource(fileObject));
        }
        return linkedList.toArray(new FileObject[linkedList.size()]);
    }

    private List<FileObject> generateFromFolder(FileObject fileObject) {
        assert (fileObject.isFolder());
        LinkedList linkedList = new LinkedList();
        Enumeration enumeration = fileObject.getData(true);
        return null;
    }

    private List<FileObject> generateFromSingleSource(FileObject fileObject) {
        Object object;
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.testSourceRoot});
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> hashMap = null;
        try {
            object = JavaSource.forFileObject((FileObject)fileObject);
            TestUtils.TestableTypeFinder testableTypeFinder = new TestUtils.TestableTypeFinder();
            object.runUserActionTask((Task)testableTypeFinder, true);
            if (!testableTypeFinder.isTestable()) {
                return Collections.EMPTY_LIST;
            }
            hashMap = TestUtils.findTopClasses((JavaSource)object, this.methodAccessModifiers, this.testPkgPrivateMethods, this.skipAbstractClasses, this.skipPkgPrivateClasses, this.skipExceptionClasses);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            object = TestUtils.getPackageName(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false));
            try {
                for (ElementHandle elementHandle : hashMap.keySet()) {
                    SaveCookie saveCookie;
                    boolean bl;
                    String string = TestUtils.getSimpleName(elementHandle.getQualifiedName().toString());
                    String string2 = TestUtils.getTestClassFullName(string, (String)object);
                    DataObject dataObject = null;
                    FileObject fileObject2 = classPath.findResource(string2 + ".java");
                    boolean bl2 = bl = fileObject2 == null;
                    if (fileObject2 == null) {
                        dataObject = this.createTestClassDataObj(string2, this.loadTestTemplate("PROP_emptyTestClassTemplate"));
                        fileObject2 = dataObject.getPrimaryFile();
                    }
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
                    SingleTestCreator singleTestCreator = new SingleTestCreator(elementHandle, hashMap.get(elementHandle), bl);
                    ModificationResult modificationResult = javaSource.runModificationTask((Task)singleTestCreator);
                    modificationResult.commit();
                    if (dataObject == null) {
                        dataObject = DataObject.find((FileObject)fileObject2);
                    }
                    if ((saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                        saveCookie.save();
                    }
                    linkedList.add(fileObject2);
                    TestUtils.addTestClassProperty(this.mProject, this.aph, object != null && ((String)object).trim().length() != 0 ? (String)object + "." + TestUtils.getTestClassName(string) : TestUtils.getTestClassName(string));
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return linkedList;
    }

    private DataObject createTestClassDataObj(String string, DataObject dataObject) throws DataObjectNotFoundException, IOException {
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        FileObject fileObject = n > -1 ? this.testSourceRoot.getFileObject(string.substring(0, n)) : this.testSourceRoot;
        return dataObject.createFromTemplate(DataFolder.findFolder((FileObject)fileObject), string2);
    }

    private DataObject loadTestTemplate(String string) {
        String string2 = NbBundle.getMessage(TestCreator.class, (String)string);
        try {
            FileObject fileObject = FileUtil.getConfigFile((String)string2);
            if (fileObject == null) {
                System.out.println("Cannot find template.");
                return null;
            }
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            System.out.println(dataObjectNotFoundException.getMessage());
            dataObjectNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SingleTestCreator
    implements CancellableTask<WorkingCopy> {
        private final ElementHandle classElem;
        private final List<ExecutableElement> srcMethods;
        private final boolean isNewTestClass;
        private List<String> processedClassNames;
        private volatile boolean cancelled = false;
        private TypeElement testCaseTypeElem;

        private SingleTestCreator() {
            this.srcMethods = null;
            this.classElem = null;
            this.isNewTestClass = true;
        }

        private SingleTestCreator(ElementHandle elementHandle, List<ExecutableElement> list, boolean bl) {
            this.classElem = elementHandle;
            this.srcMethods = list;
            this.isNewTestClass = bl;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            String string = workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(workingCopy.getFileObject(), '.', false);
            workingCopy.toPhase(JavaSource.Phase.UP_TO_DATE);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            List<ClassTree> list = TestUtils.findTopClasses(compilationUnitTree, workingCopy.getTreeUtilities());
            TypeElement typeElement = (TypeElement)this.classElem.resolve((CompilationInfo)workingCopy);
            TreePath treePath = new TreePath(compilationUnitTree);
            if (typeElement != null) {
                String string2 = typeElement.getSimpleName().toString();
                String string3 = TestUtils.getTestClassName(string2);
                boolean bl = !this.srcMethods.isEmpty();
                ClassTree classTree = null;
                for (ClassTree classTree2 : list) {
                    if (!classTree2.getSimpleName().contentEquals(string3)) continue;
                    classTree = classTree2;
                    break;
                }
                if (classTree != null) {
                    ClassTree classTree2;
                    TreePath treePath2 = new TreePath(treePath, classTree);
                    classTree2 = classTree;
                    if (bl) {
                        classTree = this.generateMissingTestMethods(workingCopy, classTree, treePath2, typeElement, this.srcMethods, this.isNewTestClass);
                    } else if (this.isNewTestClass) {
                        classTree = this.generateMissingInitMembers(classTree, treePath2, workingCopy);
                    }
                    if (classTree != classTree2) {
                        workingCopy.rewrite((Tree)classTree2, (Tree)classTree);
                    }
                }
            }
        }

        private ClassTree generateMissingInitMembers(ClassTree classTree, TreePath treePath, WorkingCopy workingCopy) {
            if (!TestCreator.this.generateSetUp && !TestCreator.this.generateTearDown) {
                return classTree;
            }
            if (!(TestCreator.this.generateSetUp && !TestUtils.hasSetUp(classTree) || TestCreator.this.generateTearDown && !TestUtils.hasTearDown(classTree))) {
                return classTree;
            }
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            List<? extends Tree> list = classTree.getMembers();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(list.size() + 2);
            arrayList.addAll(list);
            TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
            TypeMirror typeMirror = typeElement.getSuperclass();
            TypeElement typeElement2 = workingCopy.getElements().getTypeElement(((Object)typeMirror).toString());
            List<? extends Element> list2 = typeElement2.getEnclosedElements();
            for (Element element : list2) {
                if (element.toString().equals("tearDown()") && TestCreator.this.generateTearDown && !TestUtils.hasTearDown(classTree)) {
                    arrayList.add(GeneratorUtilities.get((WorkingCopy)workingCopy).createOverridingMethod(typeElement, (ExecutableElement)element));
                }
                if (!element.toString().equals("setUp()") || !TestCreator.this.generateSetUp || TestUtils.hasSetUp(classTree)) continue;
                arrayList.add(GeneratorUtilities.get((WorkingCopy)workingCopy).createOverridingMethod(typeElement, (ExecutableElement)element));
            }
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            return classTree2;
        }

        private ClassTree generateMissingTestMethods(WorkingCopy workingCopy, ClassTree classTree, TreePath treePath, TypeElement typeElement, List<ExecutableElement> list, boolean bl) {
            ArrayList<ExecutableElement> arrayList;
            Object object2;
            if (list.isEmpty()) {
                return classTree;
            }
            List<? extends Tree> list2 = classTree.getMembers();
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size() + 4);
            arrayList2.addAll(list2);
            MethodTree methodTree = this.getTestMethod(classTree);
            arrayList2.remove(methodTree);
            if (bl) {
                classTree = this.generateMissingInitMembers(classTree, treePath, workingCopy);
            }
            Boolean bl2 = null;
            HashMap<Object, ArrayList<ExecutableElement>> hashMap = new HashMap<Object, ArrayList<ExecutableElement>>();
            if (bl2 == null) {
                bl2 = this.hasAccessibleNoArgConstructor(typeElement);
            }
            for (ExecutableElement object2 : list) {
                object2 = TestUtils.createTestMethodName(object2.getSimpleName().toString());
                if (TestUtils.testMethodExists(classTree, (String)object2)) continue;
                arrayList = (ArrayList<ExecutableElement>)hashMap.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<ExecutableElement>();
                    hashMap.put(object2, arrayList);
                }
                arrayList.add(object2);
            }
            for (String string : hashMap.keySet()) {
                object2 = this.generateTestMethod(workingCopy, typeElement, string, (List)hashMap.get(string), bl2);
                arrayList2.add(object2);
            }
            if (list2.containsAll(arrayList2)) {
                return classTree;
            }
            Object object3 = new LinkedList();
            for (Object object2 : arrayList2) {
                if (object2.getKind() != Tree.Kind.METHOD || !TestUtils.isTestMethod((MethodTree)((Object)(arrayList = (MethodTree)object2)))) continue;
                object3.add(arrayList);
            }
            arrayList2.add(1, this.generateOverrideTestMethod(workingCopy, (List<MethodTree>)object3));
            object3 = workingCopy.getTreeMaker().Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList2);
            return object3;
        }

        private MethodTree getTestMethod(ClassTree classTree) {
            MethodTree methodTree = null;
            for (Tree tree : classTree.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD) continue;
                methodTree = (MethodTree)tree;
                if (methodTree.getName().toString().equals(NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method"))) break;
                methodTree = null;
            }
            return methodTree;
        }

        private List<MethodTree> generateTestMethods(WorkingCopy workingCopy, TypeElement typeElement, List<ExecutableElement> list) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            boolean bl = this.hasAccessibleNoArgConstructor(typeElement);
            ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>(list.size());
            for (ExecutableElement executableElement : list) {
                ArrayList<ExecutableElement> arrayList2 = new ArrayList<ExecutableElement>(1);
                arrayList2.add(executableElement);
                arrayList.add(this.generateTestMethod(workingCopy, typeElement, TestUtils.createTestMethodName(executableElement.getSimpleName().toString()), arrayList2, bl));
            }
            return arrayList;
        }

        private MethodTree generateOverrideTestMethod(WorkingCopy workingCopy, List<MethodTree> list) {
            Tree tree2;
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)workingCopy.getCompilationUnit().getTypeDecls().get(0);
            StringBuffer stringBuffer = new StringBuffer("{\nswitch(" + NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method_param") + ") {\n");
            int n = 0;
            for (Tree tree2 : list) {
                stringBuffer.append("case " + n + ":" + tree2.getName().toString() + "();break;\n");
                ++n;
            }
            stringBuffer.append("default: break;\n}\n}\n");
            List<IdentifierTree> list2 = Collections.singletonList(treeMaker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_throwable")));
            tree2 = treeMaker.Modifiers(Collections.emptySet(), Collections.emptyList());
            VariableTree variableTree = treeMaker.Variable((ModifiersTree)tree2, (CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method_param"), (Tree)treeMaker.PrimitiveType(TypeKind.INT), null);
            MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC)), (CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method"), (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(variableTree), (List)list2, stringBuffer.toString(), null);
            this.updateTestClassConctructor(workingCopy, n);
            return methodTree;
        }

        private void updateTestClassConctructor(WorkingCopy workingCopy, int n) {
            ClassTree classTree = (ClassTree)workingCopy.getCompilationUnit().getTypeDecls().get(0);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            MethodTree methodTree = null;
            for (Tree tree2 : classTree.getMembers()) {
                if (tree2.getKind() == Tree.Kind.METHOD && (methodTree = (MethodTree)tree2).getName().toString().equals("<init>")) break;
            }
            String string = "{\nsuper(" + n + ",\"" + classTree.getSimpleName() + "\");\n}\n";
            BlockTree blockTree = methodTree.getBody();
            TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
            StatementTree statementTree = treeUtilities.parseStatement(string, new SourcePositions[1]);
            assert (Tree.Kind.BLOCK == statementTree.getKind());
            workingCopy.rewrite((Tree)blockTree, (Tree)statementTree);
        }

        private MethodTree generateTestMethod(WorkingCopy workingCopy, TypeElement typeElement, String string, List<ExecutableElement> list, boolean bl) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ModifiersTree modifiersTree = treeMaker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC));
            LinkedList<IdentifierTree> linkedList = new LinkedList<IdentifierTree>();
            linkedList.add(treeMaker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_test_method_exception")));
            for (ExecutableElement executableElement : list) {
                if (!this.throwsNonRuntimeExceptions((CompilationInfo)workingCopy, executableElement)) continue;
                linkedList.add(treeMaker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_nonrte")));
            }
            MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)string, (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), linkedList, this.generateTestMethodBody(workingCopy, typeElement, list, bl), null);
            if (TestCreator.this.generateMethodJavadoc) {
                ExecutableElement executableElement;
                executableElement = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)NbBundle.getMessage(TestCreator.class, (String)"PROP_src_code_javadoc", (Object)string, (Object)typeElement.getSimpleName().toString()));
                treeMaker.addComment((Tree)methodTree, (Comment)executableElement, true);
            }
            return methodTree;
        }

        private MethodTree generateSuiteMethod(String string, List<String> list, WorkingCopy workingCopy) {
            Types types = workingCopy.getTypes();
            Elements elements = workingCopy.getElements();
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ArrayList arrayList = new ArrayList(list.size() + 2);
            return treeMaker.Method(treeMaker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC)), (CharSequence)"test", (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), treeMaker.Block(arrayList, false), null);
        }

        private BlockTree generateTestMethodBody(WorkingCopy workingCopy, TypeElement typeElement, List<ExecutableElement> list, boolean bl) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ArrayList<Object> arrayList = new ArrayList<Object>(8);
            boolean bl2 = true;
            int n = 0;
            for (ExecutableElement executableElement : list) {
                Tree tree;
                Object object;
                Tree tree2;
                boolean bl3 = executableElement.getModifiers().contains((Object)Modifier.STATIC);
                bl2 &= bl3;
                ++n;
                if (!TestCreator.this.generateDefMethodBody) continue;
                List<VariableTree> list2 = this.generateParamVariables(treeMaker, executableElement, n);
                if (n == 1) {
                    tree2 = this.generateSystemOutPrintln(treeMaker, executableElement.getSimpleName().toString());
                    arrayList.add(tree2);
                }
                arrayList.addAll(list2);
                tree2 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(bl3 ? treeMaker.QualIdent((Element)typeElement) : treeMaker.Identifier((CharSequence)TestCreator.INSTANCE_VAR_NAME), (CharSequence)executableElement.getSimpleName()), this.createIdentifiers(treeMaker, list2));
                TypeMirror typeMirror = executableElement.getReturnType();
                TypeKind typeKind = typeMirror.getKind();
                if (typeKind == TypeKind.VOID) {
                    object = treeMaker.ExpressionStatement((ExpressionTree)tree2);
                    arrayList.add(object);
                } else {
                    MethodInvocationTree methodInvocationTree;
                    object = treeMaker.Type(typeMirror);
                    tree = treeMaker.Variable(treeMaker.Modifiers((Set)NO_MODIFIERS), (CharSequence)("expResult_" + n), (Tree)object, this.getDefaultValue(treeMaker, typeMirror));
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers((Set)NO_MODIFIERS), (CharSequence)("result_" + n), (Tree)object, (ExpressionTree)tree2);
                    ArrayList<ExpressionTree> arrayList2 = new ArrayList<ExpressionTree>(2);
                    if (typeKind == TypeKind.FLOAT || typeKind == TypeKind.DOUBLE) {
                        arrayList2.add(treeMaker.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)treeMaker.Identifier((CharSequence)tree.getName().toString()), (ExpressionTree)treeMaker.Identifier((CharSequence)variableTree.getName().toString())));
                        methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"assertTrue"), arrayList2);
                    } else {
                        arrayList2.add(treeMaker.Identifier((CharSequence)tree.getName().toString()));
                        arrayList2.add(treeMaker.Identifier((CharSequence)variableTree.getName().toString()));
                        methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"assertEquals"), arrayList2);
                    }
                    ExpressionStatementTree expressionStatementTree = treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree);
                    arrayList.add(tree);
                    arrayList.add(variableTree);
                    arrayList.add(expressionStatementTree);
                }
                object = NbBundle.getMessage(TestCreator.class, (String)"PROP_src_code_sample_msg");
                tree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"fail"), Collections.singletonList(treeMaker.Literal(object)));
                arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)tree));
            }
            if (!bl2 && TestCreator.this.generateDefMethodBody) {
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet()), (CharSequence)TestCreator.INSTANCE_VAR_NAME, (Tree)treeMaker.QualIdent((Element)typeElement), bl ? this.generateNoArgConstructorCall(treeMaker, typeElement) : treeMaker.Literal(null));
                arrayList.add(1, variableTree);
            }
            return treeMaker.Block(arrayList, false);
        }

        private StatementTree generateSystemOutPrintln(TreeMaker treeMaker, String string) {
            MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"System"), (CharSequence)"out"), (CharSequence)"println"), Collections.singletonList(treeMaker.Literal((Object)string)));
            return treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree);
        }

        private List<VariableTree> generateParamVariables(TreeMaker treeMaker, ExecutableElement executableElement, int n) {
            List<? extends VariableElement> list = executableElement.getParameters();
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            Set set = Collections.emptySet();
            ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>(list.size());
            String[] stringArray = this.getTestSkeletonVarNames(list);
            int n2 = 0;
            for (VariableElement variableElement : list) {
                TypeMirror typeMirror = variableElement.asType();
                arrayList.add(treeMaker.Variable(treeMaker.Modifiers(set), (CharSequence)(stringArray[n2++] + '_' + n), treeMaker.Type(typeMirror), this.getDefaultValue(treeMaker, typeMirror)));
            }
            return arrayList;
        }

        private List<IdentifierTree> createIdentifiers(TreeMaker treeMaker, List<VariableTree> list) {
            List<IdentifierTree> list2;
            if (list.isEmpty()) {
                list2 = Collections.emptyList();
            } else {
                list2 = new ArrayList<IdentifierTree>(list.size());
                for (VariableTree variableTree : list) {
                    list2.add(treeMaker.Identifier((CharSequence)variableTree.getName().toString()));
                }
            }
            return list2;
        }

        private String[] getTestSkeletonVarNames(List<? extends VariableElement> list) {
            String string;
            int n;
            if (list.isEmpty()) {
                return new String[0];
            }
            int n2 = list.size();
            String[] stringArray = new String[n2];
            boolean[] blArray = new boolean[n2];
            boolean bl = false;
            HashSet<String> hashSet = new HashSet<String>((int)((double)(n2 + 2) * 1.4));
            hashSet.add(TestCreator.INSTANCE_VAR_NAME);
            hashSet.add(TestCreator.RESULT_VAR_NAME);
            hashSet.add(TestCreator.EXP_RESULT_VAR_NAME);
            Iterator<? extends VariableElement> iterator = list.iterator();
            for (n = 0; n < n2; ++n) {
                stringArray[n] = string = iterator.next().getSimpleName().toString();
                if (string == null) {
                    bl = true;
                    continue;
                }
                if (!hashSet.add(string)) {
                    blArray[n] = true;
                    bl = true;
                    continue;
                }
                blArray[n] = false;
            }
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    if (stringArray[n] == null) {
                        string = TestCreator.ARTIFICAL_VAR_NAME_BASE + n;
                        if (hashSet.add(string)) {
                            stringArray[n] = string;
                            continue;
                        }
                        blArray[n] = true;
                    }
                    if (!blArray[n]) continue;
                    String string2 = stringArray[n] + '_';
                    int n3 = 2;
                    while (!hashSet.add(string = string2 + n3++)) {
                    }
                    stringArray[n] = string;
                }
            }
            return stringArray;
        }

        private ExpressionTree getDefaultValue(TreeMaker treeMaker, TypeMirror typeMirror) {
            LiteralTree literalTree;
            TypeKind typeKind = typeMirror.getKind();
            if (typeKind.isPrimitive()) {
                switch (typeKind) {
                    case BOOLEAN: {
                        literalTree = treeMaker.Literal((Object)Boolean.FALSE);
                        break;
                    }
                    case CHAR: {
                        literalTree = treeMaker.Literal((Object)new Character(' '));
                        break;
                    }
                    case BYTE: {
                        literalTree = treeMaker.Literal((Object)new Byte(0));
                        break;
                    }
                    case SHORT: {
                        literalTree = treeMaker.Literal((Object)new Short(0));
                        break;
                    }
                    case INT: {
                        literalTree = treeMaker.Literal((Object)new Integer(0));
                        break;
                    }
                    case FLOAT: {
                        literalTree = treeMaker.Literal((Object)new Float(0.0f));
                        break;
                    }
                    case LONG: {
                        literalTree = treeMaker.Literal((Object)new Long(0L));
                        break;
                    }
                    case DOUBLE: {
                        literalTree = treeMaker.Literal((Object)new Double(0.0));
                        break;
                    }
                    default: {
                        assert (false) : "unknown primitive type";
                        literalTree = treeMaker.Literal((Object)new Integer(0));
                        break;
                    }
                }
            } else {
                literalTree = typeKind == TypeKind.DECLARED && ((Object)typeMirror).toString().equals("java.lang.String") ? treeMaker.Literal((Object)"") : treeMaker.Literal(null);
            }
            return literalTree;
        }

        private ExpressionTree generateNoArgConstructorCall(TreeMaker treeMaker, TypeElement typeElement) {
            return treeMaker.NewClass(null, Collections.emptyList(), treeMaker.QualIdent((Element)typeElement), Collections.emptyList(), null);
        }

        private boolean hasAccessibleNoArgConstructor(TypeElement typeElement) {
            boolean bl;
            List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
            if (list.isEmpty()) {
                bl = true;
            } else {
                bl = false;
                for (ExecutableElement executableElement : list) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = !executableElement.getModifiers().contains((Object)Modifier.PRIVATE);
                    break;
                }
            }
            return bl;
        }

        private boolean throwsNonRuntimeExceptions(CompilationInfo compilationInfo, ExecutableElement executableElement) {
            List<? extends TypeMirror> list = executableElement.getThrownTypes();
            if (list.isEmpty()) {
                return false;
            }
            String string = "java.lang.RuntimeException";
            TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
            if (typeElement == null) {
                return true;
            }
            Types types = compilationInfo.getTypes();
            TypeMirror typeMirror = typeElement.asType();
            for (TypeMirror typeMirror2 : list) {
                if (types.isSubtype(typeMirror2, typeMirror)) continue;
                return true;
            }
            return false;
        }

        private TypeElement getTestCaseTypeElem(Elements elements) {
            if (this.testCaseTypeElem == null) {
                this.testCaseTypeElem = this.getElemForClassName(TestCreator.J2MEUNIT_FRAMEWORK_PACKAGE_NAME, elements);
            }
            return this.testCaseTypeElem;
        }

        private TypeElement getElemForClassName(String string, Elements elements) {
            TypeElement typeElement = elements.getTypeElement(string);
            if (typeElement == null) {
                ErrorManager.getDefault().log(65536, "Could not find TypeElement for " + string);
            }
            return typeElement;
        }

        public void cancel() {
            this.cancelled = true;
        }

        private void classProcessed(ClassTree classTree) {
            if (this.processedClassNames == null) {
                this.processedClassNames = new ArrayList<String>(4);
            }
            this.processedClassNames.add(classTree.getSimpleName().toString());
        }

        List<String> getProcessedClassNames() {
            return this.processedClassNames != null ? this.processedClassNames : Collections.emptyList();
        }
    }
}

