/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainProjectManager
implements ProjectActionPerformer,
PropertyChangeListener {
    public static final String PROP_MAIN_PROJECT = "mainProject";
    public static final String PROP_SELECTED_PROJECT = "selectedProject";
    private static MainProjectManager mainProjectManager = new MainProjectManager();
    private Action a;
    private Project currentProject;
    private Reference<Project> lastSelectedProjectRef = new WeakReference<Object>(null);
    private boolean isMainProject;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static MainProjectManager getDefault() {
        return mainProjectManager;
    }

    private MainProjectManager() {
        this.a = ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)this, (String)"x", null);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.currentProject = OpenProjects.getDefault().getMainProject();
        this.isMainProject = this.currentProject != null;
        this.a.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainProjectManager.this.a.isEnabled();
            }
        });
    }

    public synchronized Project getMainProject() {
        Project project = this.lastSelectedProjectRef.get();
        if (this.isMainProject && project != null && !MainProjectManager.isDependent(project, this.currentProject)) {
            return project;
        }
        return this.currentProject;
    }

    public void perform(Project project) {
        assert (false) : "Fake action should never really be called";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable(Project project) {
        Project project2 = project;
        Project project3 = project;
        MainProjectManager mainProjectManager = this;
        synchronized (mainProjectManager) {
            if (this.isMainProject) {
                project3 = this.lastSelectedProjectRef.get();
            }
            this.lastSelectedProjectRef = new WeakReference<Project>(project);
            if (!this.isMainProject && this.currentProject != project) {
                project2 = this.currentProject;
                this.currentProject = project;
            }
        }
        if (project2 != project) {
            this.pcs.firePropertyChange(PROP_MAIN_PROJECT, project2, project);
        }
        if (project3 != project) {
            this.pcs.firePropertyChange(PROP_SELECTED_PROJECT, project3, project);
        }
        return true;
    }

    private static boolean isDependent(Project project, Project project2) {
        Set<URL> set = MainProjectManager.getProjectRoots(project);
        Set<URL> set2 = MainProjectManager.getProjectRoots(project2);
        for (URL uRL : set2) {
            Set set3 = SourceUtils.getDependentRoots((URL)uRL);
            for (URL uRL2 : set) {
                if (!set3.contains(uRL2)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<URL> getProjectRoots(Project project) {
        SourceGroup[] sourceGroupArray;
        HashSet<URL> hashSet = new HashSet<URL>();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            try {
                URL uRL = sourceGroup.getRootFolder().getURL();
                hashSet.add(uRL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (NullPointerException nullPointerException) {
                NullPointerException nullPointerException2;
                if (sourceGroup == null) {
                    nullPointerException2 = (NullPointerException)Exceptions.attachMessage((Throwable)nullPointerException, (String)("Null source group returned from " + sources + " of class " + sources.getClass()));
                } else if (sourceGroup.getRootFolder() == null) {
                    nullPointerException2 = (NullPointerException)Exceptions.attachMessage((Throwable)nullPointerException, (String)("Null root folder returned from " + sourceGroup + " of class " + sourceGroup.getClass()));
                }
                Exceptions.printStackTrace((Throwable)nullPointerException2);
            }
        }
        return hashSet;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
            Project project;
            Project project2 = project = OpenProjects.getDefault().getMainProject();
            MainProjectManager mainProjectManager = this;
            synchronized (mainProjectManager) {
                this.isMainProject = project != null;
                project2 = this.currentProject;
                this.currentProject = this.isMainProject ? project : this.lastSelectedProjectRef.get();
            }
            if (project2 != project) {
                this.pcs.firePropertyChange(PROP_MAIN_PROJECT, project2, project);
            }
        }
    }
}

