/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.EnumDescriptor;
import org.netbeans.modules.vmd.api.model.EnumDescriptorFactory;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;

final class EnumDescriptorFactoryRegistry {
    private static final Lookup.Result<EnumDescriptorFactory> factoriesLookupResult = Lookup.getDefault().lookupResult(EnumDescriptorFactory.class);

    EnumDescriptorFactoryRegistry() {
    }

    static EnumDescriptor getDescriptor(String string, TypeID typeID) {
        assert (Debug.isFriend(PropertyValue.class));
        assert (typeID.getKind() == TypeID.Kind.ENUM);
        assert (typeID.getDimension() == 0);
        for (EnumDescriptorFactory enumDescriptorFactory : factoriesLookupResult.allInstances()) {
            EnumDescriptor enumDescriptor;
            if (string == null || !string.equals(enumDescriptorFactory.getProjectType()) || (enumDescriptor = enumDescriptorFactory.getDescriptorForTypeIDString(typeID.getString())) == null) continue;
            return enumDescriptor;
        }
        throw Debug.error("No EnumDescriptorFactory found", typeID);
    }
}

