/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.IdentifiablePresenter;
import org.netbeans.modules.vmd.api.model.presenters.OrderablePresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentSupport {
    public static List<DesignComponent> gatherAllComponentsOfTypeID(DesignDocument designDocument, TypeID typeID) {
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        DocumentSupport.gatherAllComponentsOfTypeID(arrayList, typeID, designDocument.getRootComponent());
        return arrayList;
    }

    public static <T extends Presenter> List<DesignComponent> gatherAllComponentsContainingPresenterClass(DesignDocument designDocument, Class<T> clazz) {
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        DesignComponent designComponent = designDocument.getRootComponent();
        if (designComponent != null) {
            DocumentSupport.gatherAllComponentsContainingPresenterClass(arrayList, designComponent, clazz);
        }
        return arrayList;
    }

    private static <T extends Presenter> void gatherAllComponentsContainingPresenterClass(ArrayList<DesignComponent> arrayList, DesignComponent designComponent, Class<T> clazz) {
        if (designComponent.getPresenter(clazz) != null) {
            arrayList.add(designComponent);
        }
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            DocumentSupport.gatherAllComponentsContainingPresenterClass(arrayList, designComponent2, clazz);
        }
    }

    public static List<DesignComponent> gatherAllComponentsOfTypeID(DesignComponent designComponent, TypeID typeID) {
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        DocumentSupport.gatherAllComponentsOfTypeID(arrayList, typeID, designComponent);
        return arrayList;
    }

    private static void gatherAllComponentsOfTypeID(Collection<? super DesignComponent> collection, TypeID typeID, DesignComponent designComponent) {
        if (designComponent.getDocument().getDescriptorRegistry().isInHierarchy(typeID, designComponent.getType())) {
            collection.add(designComponent);
        }
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            DocumentSupport.gatherAllComponentsOfTypeID(collection, typeID, designComponent2);
        }
    }

    public static void removePresentersOfClass(ArrayList<? super Presenter> arrayList, Class clazz) {
        Iterator<? super Presenter> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Presenter presenter = iterator.next();
            if (!clazz.isInstance(presenter)) continue;
            iterator.remove();
        }
    }

    public static void removePresenter(ArrayList<? super Presenter> arrayList, Presenter presenter) {
        Iterator<? super Presenter> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Presenter presenter2 = iterator.next();
            if (presenter != presenter2) continue;
            iterator.remove();
            return;
        }
    }

    public static void removePresentersOfPresenterID(ArrayList<Presenter> arrayList, String string) {
        if (string == null) {
            return;
        }
        Iterator<Presenter> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Presenter presenter = iterator.next();
            if (!(presenter instanceof IdentifiablePresenter) || !string.equals(((IdentifiablePresenter)((Object)presenter)).getPresenterID())) continue;
            iterator.remove();
        }
    }

    public static void sortPresentersByOrder(ArrayList<? extends OrderablePresenter> arrayList) {
        Collections.sort(arrayList, new Comparator<OrderablePresenter>(){

            @Override
            public int compare(OrderablePresenter orderablePresenter, OrderablePresenter orderablePresenter2) {
                return orderablePresenter.getOrder() - orderablePresenter2.getOrder();
            }
        });
    }

    public static List<DesignComponent> gatherSubComponentsOfType(DesignComponent designComponent, TypeID typeID) {
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            if (!typeID.equals(designComponent2.getType())) continue;
            arrayList.add(designComponent2);
        }
        return arrayList;
    }

    public static <T extends Presenter> Collection<T> gatherAllPresentersOfClass(DesignDocument designDocument, Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        DocumentSupport.gatherAllPresentersOfClass(arrayList, designDocument.getRootComponent(), clazz);
        return arrayList;
    }

    private static <T extends Presenter> void gatherAllPresentersOfClass(ArrayList<T> arrayList, DesignComponent designComponent, Class<T> clazz) {
        arrayList.addAll(designComponent.getPresenters(clazz));
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            DocumentSupport.gatherAllPresentersOfClass(arrayList, designComponent2, clazz);
        }
    }

    public static <T extends Presenter> Collection<T> filterPresentersForClass(Collection<? extends Presenter> collection, Class<T> clazz) {
        ArrayList<Presenter> arrayList = new ArrayList<Presenter>();
        for (Presenter presenter : collection) {
            if (!clazz.isInstance(presenter)) continue;
            arrayList.add(presenter);
        }
        return arrayList;
    }

    public static Collection<ComponentProducer> getComponentProducers(DesignDocument designDocument, TypeID typeID) {
        HashSet<ComponentProducer> hashSet = new HashSet<ComponentProducer>();
        DescriptorRegistry descriptorRegistry = designDocument.getDescriptorRegistry();
        for (ComponentProducer componentProducer : descriptorRegistry.getComponentProducers()) {
            if (!descriptorRegistry.isInHierarchy(typeID, componentProducer.getMainComponentTypeID())) continue;
            hashSet.add(componentProducer);
        }
        return hashSet;
    }

    public static ComponentProducer getComponentProducer(DesignDocument designDocument, String string) {
        for (ComponentProducer componentProducer : designDocument.getDescriptorRegistry().getComponentProducers()) {
            if (!componentProducer.getProducerID().equals(string)) continue;
            return componentProducer;
        }
        return null;
    }
}

