/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationPanel
extends JPanel {
    static final String RUN_ACTION = "run-action";
    static final String RUN_IN_BACKGROUND = "run-in-background";
    private ButtonGroup bgRestartButtons;
    private JCheckBox cbRunInBackground;
    private JLabel lDetailLabel;
    private JLabel lMainLabel;
    private JPanel pAboveSpace;
    private JPanel pProgress;
    private JProgressBar pbPlaceHolder;
    private JRadioButton rbRestartLater;
    private JRadioButton rbRestartNow;

    public OperationPanel(boolean bl) {
        this.initComponents();
        this.rbRestartNow.setSelected(true);
        this.cbRunInBackground.setVisible(bl);
        if (bl) {
            this.cbRunInBackground.setSelected(false);
        }
        this.setRestartButtonsVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                OperationPanel.this.firePropertyChange(OperationPanel.RUN_ACTION, null, Boolean.TRUE);
            }
        }, 200);
    }

    public void waitAndSetProgressComponents(final JLabel jLabel, final JComponent jComponent, final JLabel jLabel2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponents(jLabel, jComponent, jLabel2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OperationPanel.this.setProgressComponents(jLabel, jComponent, jLabel2);
                }
            });
        }
    }

    public void setRestartButtonsVisible(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rbRestartLater.setVisible(bl);
            this.rbRestartNow.setVisible(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OperationPanel.this.rbRestartLater.setVisible(bl);
                    OperationPanel.this.rbRestartNow.setVisible(bl);
                }
            });
        }
    }

    public boolean restartNow() {
        return this.rbRestartNow.isSelected();
    }

    public void hideRunInBackground() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cbRunInBackground.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OperationPanel.this.cbRunInBackground.setVisible(false);
                }
            });
        }
    }

    private void setProgressComponents(JLabel jLabel, JComponent jComponent, JLabel jLabel2) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        jLabel.setPreferredSize(new Dimension(0, 20));
        jLabel2.setPreferredSize(new Dimension(0, 20));
        jComponent.setPreferredSize(new Dimension(0, 20));
        this.pProgress.removeAll();
        this.pProgress.add((Component)jLabel, "North");
        this.pProgress.add((Component)jComponent, "Center");
        this.pProgress.add((Component)jLabel2, "South");
        this.pAboveSpace.setVisible(true);
        this.revalidate();
    }

    public void setBody(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBodyInEQ(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OperationPanel.this.setBodyInEQ(string, string2);
                }
            });
        }
    }

    public void setBody(final String string, Set<UpdateElement> set) {
        final ArrayList<UpdateElement> arrayList = new ArrayList<UpdateElement>(set);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBodyInEQ(string, arrayList);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OperationPanel.this.setBodyInEQ(string, arrayList);
                }
            });
        }
    }

    private void setBodyInEQ(String string, List<UpdateElement> list) {
        this.pProgress.removeAll();
        this.pProgress.add((Component)this.getTitleComponent(string), "North");
        this.pProgress.add((Component)this.getElementsComponent(list), "Center");
        this.pAboveSpace.setVisible(false);
        this.revalidate();
    }

    private void setBodyInEQ(String string, String string2) {
        this.pProgress.removeAll();
        this.pProgress.add((Component)this.getTitleComponent(string), "North");
        this.pProgress.add((Component)this.getElementsComponent(string2), "Center");
        this.pAboveSpace.setVisible(false);
        this.revalidate();
    }

    private JComponent getTitleComponent(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        return jTextArea;
    }

    private JComponent getElementsComponent(List<UpdateElement> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (UpdateElement updateElement : list) {
            stringBuilder.append(updateElement.getDisplayName() + "<br>");
        }
        return this.getElementsComponent(stringBuilder.toString());
    }

    private JComponent getElementsComponent(String string) {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setContentType("text/html");
        jTextPane.setText(string);
        jTextPane.setOpaque(false);
        return jTextPane;
    }

    private void initComponents() {
        this.bgRestartButtons = new ButtonGroup();
        this.pAboveSpace = new JPanel();
        this.pProgress = new JPanel();
        this.pbPlaceHolder = new JProgressBar();
        this.lMainLabel = new JLabel();
        this.lDetailLabel = new JLabel();
        this.rbRestartNow = new JRadioButton();
        this.rbRestartLater = new JRadioButton();
        this.cbRunInBackground = new JCheckBox();
        this.pAboveSpace.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.pAboveSpace);
        this.pAboveSpace.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 148, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 65, Short.MAX_VALUE));
        this.pProgress.setLayout(new BorderLayout());
        this.pbPlaceHolder.setPreferredSize(new Dimension(0, 20));
        this.pProgress.add((Component)this.pbPlaceHolder, "Center");
        this.pProgress.add((Component)this.lMainLabel, "North");
        this.pProgress.add((Component)this.lDetailLabel, "South");
        this.bgRestartButtons.add(this.rbRestartNow);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartNow, (String)NbBundle.getMessage(OperationPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartNow"));
        this.rbRestartNow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationPanel.this.rbRestartNowActionPerformed(actionEvent);
            }
        });
        this.bgRestartButtons.add(this.rbRestartLater);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartLater, (String)NbBundle.getMessage(OperationPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartLater"));
        this.rbRestartLater.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartLater.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationPanel.this.rbRestartLaterActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRunInBackground, (String)NbBundle.getMessage(OperationPanel.class, (String)"OperationPanel.cbRunInBackground.text"));
        this.cbRunInBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationPanel.this.cbRunInBackgroundActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.pProgress, -1, 148, Short.MAX_VALUE).add((Component)this.pAboveSpace, -1, -1, Short.MAX_VALUE).add((Component)this.cbRunInBackground).add((Component)this.rbRestartNow, -1, 148, Short.MAX_VALUE).add((Component)this.rbRestartLater, -1, 148, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.pAboveSpace, -2, -1, -2).addPreferredGap(0).add((Component)this.pProgress, -2, -1, -2).addPreferredGap(0).add((Component)this.cbRunInBackground).addPreferredGap(0).add((Component)this.rbRestartNow).addPreferredGap(0).add((Component)this.rbRestartLater).addContainerGap(45, Short.MAX_VALUE)));
    }

    private void rbRestartLaterActionPerformed(ActionEvent actionEvent) {
    }

    private void rbRestartNowActionPerformed(ActionEvent actionEvent) {
    }

    private void cbRunInBackgroundActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(RUN_IN_BACKGROUND, null, Boolean.TRUE);
    }
}

