/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEvaluator
implements Evaluator<JavaExpression> {
    private final JPDADebuggerImpl debugger;

    public JavaEvaluator(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Evaluator.Result evaluate(Evaluator.Expression<JavaExpression> expression, final Evaluator.Context context) throws InvalidExpressionException {
        JavaExpression javaExpression = (JavaExpression)expression.getPreprocessedObject();
        if (javaExpression == null) {
            javaExpression = JavaExpression.parse(expression.getExpression(), "1.5.0");
            expression.setPreprocessedObject((Object)javaExpression);
        }
        Value value = this.evaluateIn(javaExpression, context.getStackFrame(), context.getStackDepth(), context.getContextObject(), this.debugger.methodCallsUnsupportedExc == null, new Runnable(){

            public void run() {
                context.notifyMethodToBeInvoked();
            }
        });
        return new Evaluator.Result(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evaluateIn(JavaExpression javaExpression, StackFrame stackFrame, int n, ObjectReference objectReference, boolean bl, Runnable runnable) throws InvalidExpressionException {
        Value value;
        block12: {
            if (stackFrame == null) {
                throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContext"));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("java.lang.*");
            arrayList.addAll(Arrays.asList(EditorContextBridge.getContext().getImports(this.debugger.getEngineContext().getURL(stackFrame, "Java"))));
            ThreadReference threadReference = StackFrameWrapper.thread(stackFrame);
            Object object = this.debugger.getThread(threadReference);
            EvaluationContext evaluationContext = new EvaluationContext((JPDAThreadImpl)object, stackFrame, n, objectReference, arrayList, arrayList2, bl, runnable, this.debugger);
            TreeEvaluator treeEvaluator = javaExpression.evaluator(evaluationContext);
            try {
                value = treeEvaluator.evaluate();
                if (this.debugger.methodCallsUnsupportedExc != null || evaluationContext.canInvokeMethods()) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (this.debugger.methodCallsUnsupportedExc == null && !evaluationContext.canInvokeMethods()) {
                        this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                    }
                    throw throwable;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    throw new InvalidExpressionException(internalExceptionWrapper.getLocalizedMessage());
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_disconnected"));
                }
                catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"));
                }
                catch (EvaluationException evaluationException) {
                    object = new InvalidExpressionException((Throwable)evaluationException);
                    object.initCause((Throwable)evaluationException);
                    Exceptions.attachMessage((Throwable)object, (String)("Expression = '" + javaExpression.getExpression() + "'"));
                    throw object;
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    object = new InvalidExpressionException(incompatibleThreadStateException.getLocalizedMessage());
                    object.initCause((Throwable)incompatibleThreadStateException);
                    throw object;
                }
            }
            this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
        }
        return value;
    }
}

