/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ListSelector
extends JPanel {
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availableScrollPane;
    private JButton downButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectedLabel;
    private JList selectedList;
    private JScrollPane selectedScrollPane;
    private JButton upButton;

    public ListSelector() {
        this.initComponents();
        ListDataListener listDataListener = new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getSource() == ListSelector.this.availableList.getModel()) {
                    ListSelector.this.addAllButton.setEnabled(ListSelector.this.availableList.getModel().getSize() != 0);
                } else if (listDataEvent.getSource() == ListSelector.this.selectedList.getModel()) {
                    ListSelector.this.removeAllButton.setEnabled(ListSelector.this.selectedList.getModel().getSize() != 0);
                }
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }
        };
        this.availableList.getModel().addListDataListener(listDataListener);
        this.selectedList.getModel().addListDataListener(listDataListener);
    }

    public void setItems(List list, List list2) {
        DefaultListModel defaultListModel = (DefaultListModel)this.availableList.getModel();
        defaultListModel.clear();
        for (Object e : list) {
            defaultListModel.addElement(e);
        }
        defaultListModel = (DefaultListModel)this.selectedList.getModel();
        defaultListModel.clear();
        for (Object e : list2) {
            defaultListModel.addElement(e);
        }
    }

    public List getSelectedItems() {
        DefaultListModel defaultListModel = (DefaultListModel)this.selectedList.getModel();
        return Arrays.asList(defaultListModel.toArray());
    }

    private void initComponents() {
        this.availableLabel = new JLabel();
        this.availableScrollPane = new JScrollPane();
        this.availableList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.selectedScrollPane = new JScrollPane();
        this.selectedList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.selectedLabel = new JLabel();
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available"));
        this.availableList.setModel(new DefaultListModel());
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelector.this.availableListValueChanged(listSelectionEvent);
            }
        });
        this.availableScrollPane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available_ACSN"));
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available_ACSD"));
        this.addButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Add"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.addAllButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_AddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        this.removeAllButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_RemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.removeAllButtonActionPerformed(actionEvent);
            }
        });
        this.selectedList.setModel(new DefaultListModel());
        this.selectedList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelector.this.selectedListValueChanged(listSelectionEvent);
            }
        });
        this.selectedScrollPane.setViewportView(this.selectedList);
        this.selectedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected_ACSN"));
        this.selectedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Up"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.upButtonActionPerformed(actionEvent);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Down"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelector.this.downButtonActionPerformed(actionEvent);
            }
        });
        this.selectedLabel.setLabelFor(this.selectedList);
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.availableLabel).add((Component)this.availableScrollPane, -1, 207, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.addButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE).add((Component)this.addAllButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeAllButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.selectedScrollPane, -1, 207, Short.MAX_VALUE).add((Component)this.selectedLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.downButton, -1, -1, Short.MAX_VALUE).add((Component)this.upButton, -1, -1, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.availableLabel).add((Component)this.selectedLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 33, Short.MAX_VALUE).add((Component)this.upButton).addPreferredGap(0).add((Component)this.downButton).addContainerGap(43, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 5, Short.MAX_VALUE).add((Component)this.addButton).addPreferredGap(0).add((Component)this.addAllButton).addPreferredGap(0).add((Component)this.removeButton).addPreferredGap(0).add((Component)this.removeAllButton).addContainerGap(17, Short.MAX_VALUE)).add((Component)this.availableScrollPane).add((Component)this.selectedScrollPane))));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Add_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Remove_ACSD"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_AddAll_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_RemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Up_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Down_ACSD"));
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.selectedList.getModel();
        int n = this.selectedList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n + 1, e);
        this.selectedList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.selectedList.getModel();
        int n = this.selectedList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n - 1, e);
        this.selectedList.setSelectedIndex(n - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        ListSelector.moveListItems(this.selectedList, this.availableList, false);
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        ListSelector.moveListItems(this.availableList, this.selectedList, false);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        ListSelector.moveListItems(this.selectedList, this.availableList, true);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        ListSelector.moveListItems(this.availableList, this.selectedList, true);
    }

    private void selectedListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.removeButton.setEnabled(this.selectedList.getSelectedIndex() != -1);
        int[] nArray = this.selectedList.getSelectedIndices();
        this.upButton.setEnabled(nArray.length == 1 && nArray[0] != 0);
        this.downButton.setEnabled(nArray.length == 1 && nArray[0] != this.selectedList.getModel().getSize() - 1);
    }

    private void availableListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.addButton.setEnabled(this.availableList.getSelectedIndex() != -1);
    }

    private static void moveListItems(JList jList, JList jList2, boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)jList2.getModel();
        if (bl) {
            int n;
            int[] nArray = jList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                Object e = defaultListModel.getElementAt(nArray[n]);
                defaultListModel2.addElement(e);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                defaultListModel.removeElementAt(nArray[n]);
            }
        } else {
            Enumeration enumeration = defaultListModel.elements();
            while (enumeration.hasMoreElements()) {
                defaultListModel2.addElement(enumeration.nextElement());
            }
            defaultListModel.clear();
        }
    }
}

