/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import org.netbeans.modules.form.CodeCustomEditor;
import org.netbeans.modules.form.ConnectionCustomEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RADConnectionPropertyEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    private Type editorType;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Class propertyType;
    private FormModel formModel = null;
    private FormProperty property;
    private RADConnectionDesignValue designValue = null;
    private Object realValue = null;
    public static final String XML_CONNECTION = "Connection";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CODE = "code";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_REQUIRED_TYPE = "valueType";
    public static final String VALUE_VALUE = "value";
    public static final String VALUE_PROPERTY = "property";
    public static final String VALUE_METHOD = "method";
    public static final String VALUE_BEAN = "bean";
    public static final String VALUE_CODE = "code";

    public RADConnectionPropertyEditor(Class clazz) {
        this.propertyType = clazz;
        this.editorType = Type.FormConnection;
    }

    public RADConnectionPropertyEditor(Class clazz, Type type) {
        this.propertyType = clazz;
        this.editorType = type;
    }

    public Type getEditorType() {
        return this.editorType;
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.formModel = formModel;
        this.property = formProperty;
    }

    public void updateFormVersionLevel() {
    }

    public Object getValue() {
        return this.designValue != null ? this.designValue : this.realValue;
    }

    public void setValue(Object object) {
        if (object instanceof RADConnectionDesignValue) {
            String string;
            this.designValue = (RADConnectionDesignValue)object;
            Type type = this.editorType = this.designValue.getType() == 2 ? Type.CustomCode : Type.FormConnection;
            if (this.editorType == Type.CustomCode && ((string = this.designValue.getCode()) == null || string.trim().length() == 0)) {
                this.setValue(this.property.getDefaultValue());
            }
        } else {
            this.designValue = null;
            this.realValue = object;
        }
        this.support.firePropertyChange("", null, null);
    }

    public void setAsText(String string) {
    }

    public String getAsText() {
        return null;
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.getValueString(), rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    public boolean supportsCustomEditor() {
        return !this.formModel.isReadOnly();
    }

    public Component getCustomEditor() {
        if (this.editorType == Type.FormConnection) {
            ConnectionCustomEditor connectionCustomEditor = new ConnectionCustomEditor(this, this.formModel, this.propertyType);
            connectionCustomEditor.setValue(this.designValue);
            return connectionCustomEditor;
        }
        CodeCustomEditor codeCustomEditor = new CodeCustomEditor(this, this.formModel, this.property);
        codeCustomEditor.setValue(this.designValue);
        return codeCustomEditor;
    }

    public String getJavaInitializationString() {
        if (this.designValue != null) {
            if (this.designValue.needsInit) {
                this.designValue.initialize();
            }
            if (this.designValue.type == 3) {
                if ("java.lang.String".equals(this.designValue.requiredTypeName)) {
                    return "\"" + this.designValue.value + "\"";
                }
                if ("long".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "L";
                }
                if ("float".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "F";
                }
                if ("double".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "D";
                }
                if ("char".equals(this.designValue.requiredTypeName)) {
                    return "'" + this.designValue.value + "'";
                }
                return this.designValue.value;
            }
            if (this.designValue.type == 2) {
                return this.designValue.userCode;
            }
            if (this.designValue.radComponent == null || this.designValue.radComponent.getCodeExpression() == null) {
                return null;
            }
            if (this.designValue.type == 0) {
                PropertyDescriptor propertyDescriptor = this.designValue.getProperty();
                if (propertyDescriptor == null) {
                    return null;
                }
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return propertyDescriptor.getReadMethod().getName() + "()";
                }
                return this.designValue.radComponent.getName() + "." + propertyDescriptor.getReadMethod().getName() + "()";
            }
            if (this.designValue.type == 1) {
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return this.designValue.methodName + "()";
                }
                return this.designValue.radComponent.getName() + "." + this.designValue.methodName + "()";
            }
            if (this.designValue.type == 4) {
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return "this";
                }
                return this.designValue.radComponent.getName();
            }
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String getDisplayName() {
        return FormUtils.getBundleString(this.editorType == Type.FormConnection ? "CTL_FormConnection_DisplayName" : "CTL_CustomCode_DisplayName");
    }

    private String getValueString() {
        String string = this.designValue != null ? this.designValue.getName() : (this.realValue != null ? (this.realValue instanceof Number || this.realValue instanceof Boolean || this.realValue instanceof String || this.realValue instanceof Character ? this.realValue.toString() : (this.realValue.getClass().isArray() ? "[" + FormUtils.getBundleString("CTL_ArrayOf") + " " + this.realValue.getClass().getComponentType().getName() + "]" : "[" + Utilities.getShortClassName(this.realValue.getClass()) + "]")) : "null");
        return string;
    }

    private static Object parseValue(String string, String string2) {
        try {
            if ("java.lang.String".equals(string)) {
                return string2;
            }
            if ("int".equals(string)) {
                return Integer.valueOf(string2);
            }
            if ("short".equals(string)) {
                return Short.valueOf(string2);
            }
            if ("long".equals(string)) {
                return Long.valueOf(string2);
            }
            if ("byte".equals(string)) {
                return Byte.valueOf(string2);
            }
            if ("float".equals(string)) {
                return Float.valueOf(string2);
            }
            if ("double".equals(string)) {
                return Double.valueOf(string2);
            }
            if ("boolean".equals(string)) {
                return Boolean.valueOf(string2);
            }
            if ("char".equals(string) && string2.length() > 0) {
                return new Character(string2.charAt(0));
            }
            return FormDesignValue.IGNORED_VALUE;
        }
        catch (Exception exception) {
            return FormDesignValue.IGNORED_VALUE;
        }
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_CONNECTION.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
            if ("value".equals(string)) {
                String string2 = namedNodeMap.getNamedItem("value").getNodeValue();
                String string3 = namedNodeMap.getNamedItem(ATTR_REQUIRED_TYPE).getNodeValue();
                this.setValue(new RADConnectionDesignValue(string3, string2));
            } else if (VALUE_PROPERTY.equals(string)) {
                String string4 = namedNodeMap.getNamedItem(ATTR_COMPONENT).getNodeValue();
                String string5 = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
                this.setValue(new RADConnectionDesignValue(string4, 0, string5, this.formModel));
            } else if (VALUE_METHOD.equals(string)) {
                String string6 = namedNodeMap.getNamedItem(ATTR_COMPONENT).getNodeValue();
                String string7 = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
                this.setValue(new RADConnectionDesignValue(string6, 1, string7, this.formModel));
            } else if (VALUE_BEAN.equals(string)) {
                String string8 = namedNodeMap.getNamedItem(ATTR_COMPONENT).getNodeValue();
                this.setValue(new RADConnectionDesignValue(string8, 4, null, this.formModel));
            } else {
                String string9 = namedNodeMap.getNamedItem("code").getNodeValue();
                this.setValue(new RADConnectionDesignValue(string9));
            }
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            iOException.initCause(nullPointerException);
            throw iOException;
        }
    }

    public Node storeToXML(Document document) {
        String string;
        String string2;
        if (this.designValue == null) {
            return null;
        }
        String string3 = string2 = this.designValue.radComponent != null ? this.designValue.radComponent.getName() : this.designValue.radComponentName;
        if (string2 == null && this.designValue.radComponent != null) {
            return null;
        }
        Element element = document.createElement(XML_CONNECTION);
        switch (this.designValue.type) {
            case 3: {
                string = "value";
                break;
            }
            case 0: {
                string = VALUE_PROPERTY;
                break;
            }
            case 1: {
                string = VALUE_METHOD;
                break;
            }
            case 4: {
                string = VALUE_BEAN;
                break;
            }
            default: {
                string = "code";
            }
        }
        element.setAttribute(ATTR_TYPE, string);
        switch (this.designValue.type) {
            case 3: {
                element.setAttribute("value", this.designValue.value);
                element.setAttribute(ATTR_REQUIRED_TYPE, this.designValue.requiredTypeName);
                break;
            }
            case 0: {
                element.setAttribute(ATTR_COMPONENT, string2);
                element.setAttribute(ATTR_NAME, this.designValue.propertyName);
                break;
            }
            case 1: {
                element.setAttribute(ATTR_COMPONENT, string2);
                element.setAttribute(ATTR_NAME, this.designValue.methodName);
                break;
            }
            case 4: {
                element.setAttribute(ATTR_COMPONENT, string2);
                break;
            }
            case 2: {
                element.setAttribute("code", this.designValue.userCode);
            }
        }
        return element;
    }

    public static class RADConnectionDesignValue
    implements FormDesignValue {
        public static final int TYPE_PROPERTY = 0;
        public static final int TYPE_METHOD = 1;
        public static final int TYPE_CODE = 2;
        public static final int TYPE_VALUE = 3;
        public static final int TYPE_BEAN = 4;
        int type;
        private transient RADComponent radComponent = null;
        String radComponentName = null;
        private transient MethodDescriptor method = null;
        String methodName = null;
        private transient PropertyDescriptor property = null;
        String propertyName = null;
        String userCode = null;
        String value = null;
        String requiredTypeName = null;
        private transient boolean needsInit = false;
        private transient FormModel formModel;
        static final long serialVersionUID = 147134837271021412L;

        RADConnectionDesignValue(RADComponent rADComponent) {
            this.radComponent = rADComponent;
            this.radComponentName = this.radComponent.getName();
            this.type = 4;
        }

        RADConnectionDesignValue(RADComponent rADComponent, MethodDescriptor methodDescriptor) {
            this.radComponent = rADComponent;
            this.radComponentName = this.radComponent.getName();
            this.method = methodDescriptor;
            this.methodName = methodDescriptor.getName();
            this.type = 1;
        }

        RADConnectionDesignValue(RADComponent rADComponent, PropertyDescriptor propertyDescriptor) {
            this.radComponent = rADComponent;
            this.radComponentName = this.radComponent.getName();
            this.property = propertyDescriptor;
            this.propertyName = propertyDescriptor.getName();
            this.type = 0;
        }

        RADConnectionDesignValue(String string, String string2) {
            this.requiredTypeName = string;
            this.value = string2;
            this.type = 3;
        }

        private RADConnectionDesignValue(String string, int n, String string2, FormModel formModel) {
            this.radComponentName = string;
            this.formModel = formModel;
            if (n == 0) {
                this.needsInit = true;
                this.type = 0;
                this.propertyName = string2;
            } else if (n == 1) {
                this.needsInit = true;
                this.type = 1;
                this.methodName = string2;
            } else if (n == 4) {
                this.needsInit = true;
                this.type = 4;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public RADConnectionDesignValue(Class clazz, String string) {
            this.requiredTypeName = clazz.getName();
            this.value = string;
            this.type = 3;
        }

        public RADConnectionDesignValue(String string) {
            this.userCode = string;
            this.type = 2;
        }

        public FormDesignValue copy(FormProperty formProperty) {
            switch (this.type) {
                case 2: {
                    return new RADConnectionDesignValue(this.userCode);
                }
                case 3: {
                    return new RADConnectionDesignValue(this.requiredTypeName, this.value);
                }
            }
            return null;
        }

        String getName() {
            if (this.needsInit) {
                this.initialize();
            }
            if (this.type == 3) {
                return FormUtils.getFormattedBundleString("FMT_VALUE_CONN", new Object[]{this.value});
            }
            if (this.type == 2) {
                return FormUtils.getBundleString("CTL_CODE_CONN");
            }
            if (this.radComponent == null || this.radComponent.getCodeExpression() == null) {
                return FormUtils.getBundleString("CTL_CONNECTION_INVALID");
            }
            if (this.radComponent == null) {
                return null;
            }
            if (this.type == 0) {
                return FormUtils.getFormattedBundleString("FMT_PROPERTY_CONN", new Object[]{this.radComponent.getName(), this.propertyName});
            }
            if (this.type == 1) {
                return FormUtils.getFormattedBundleString("FMT_METHOD_CONN", new Object[]{this.radComponent.getName(), this.methodName});
            }
            if (this.type == 4) {
                return FormUtils.getFormattedBundleString("FMT_BEAN_CONN", new Object[]{this.radComponent.getName()});
            }
            throw new IllegalStateException();
        }

        public PropertyDescriptor getProperty() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.property;
        }

        public MethodDescriptor getMethod() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.method;
        }

        public String getCode() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.userCode;
        }

        public String getValue() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.value;
        }

        public RADComponent getRADComponent() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.radComponent;
        }

        private boolean initialize() {
            boolean bl = false;
            this.radComponent = this.formModel.findRADComponent(this.radComponentName);
            if (this.radComponent != null) {
                if (this.type == 4) {
                    bl = true;
                } else if (this.type == 0) {
                    PropertyDescriptor[] propertyDescriptorArray = this.radComponent.getBeanInfo().getPropertyDescriptors();
                    for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                        if (!propertyDescriptorArray[i].getName().equals(this.propertyName)) continue;
                        this.property = propertyDescriptorArray[i];
                        bl = true;
                        break;
                    }
                } else {
                    MethodDescriptor[] methodDescriptorArray = this.radComponent.getBeanInfo().getMethodDescriptors();
                    for (int i = 0; i < methodDescriptorArray.length; ++i) {
                        if (!methodDescriptorArray[i].getName().equals(this.methodName)) continue;
                        this.method = methodDescriptorArray[i];
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) {
                this.needsInit = false;
            }
            return bl;
        }

        public Object getDesignValue() {
            switch (this.type) {
                case 0: {
                    try {
                        return this.getProperty().getReadMethod().invoke(this.getRADComponent().getBeanInstance(), new Object[0]);
                    }
                    catch (Exception exception) {
                        return FormDesignValue.IGNORED_VALUE;
                    }
                }
                case 1: {
                    try {
                        return this.getMethod().getMethod().invoke(this.getRADComponent().getBeanInstance(), new Object[0]);
                    }
                    catch (Exception exception) {
                        return FormDesignValue.IGNORED_VALUE;
                    }
                }
                case 3: {
                    return RADConnectionPropertyEditor.parseValue(this.requiredTypeName, this.value);
                }
                case 4: {
                    RADComponent rADComponent = this.getRADComponent();
                    return rADComponent == null ? FormDesignValue.IGNORED_VALUE : rADComponent.getBeanInstance();
                }
                case 2: {
                    return FormDesignValue.IGNORED_VALUE;
                }
            }
            return FormDesignValue.IGNORED_VALUE;
        }

        public Object getDesignValue(Object object) {
            return null;
        }

        public Object getValueForBean(Object object) {
            if (object != null) {
                switch (this.type) {
                    case 0: {
                        try {
                            return this.getProperty().getReadMethod().invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 1: {
                        try {
                            return this.getMethod().getMethod().invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 4: {
                        return object;
                    }
                }
            }
            return null;
        }

        public String getDescription() {
            return this.getName();
        }

        public int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FormConnection,
        CustomCode;

    }
}

