/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class SvnProgressSupport
implements Runnable,
Cancellable {
    private Cancellable delegate;
    private volatile boolean canceled;
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName = "";
    private OutputLogger logger;
    private SVNUrl repositoryRoot;
    private RequestProcessor.Task task;

    public RequestProcessor.Task start(RequestProcessor requestProcessor, SVNUrl sVNUrl, String string) {
        this.setDisplayName(string);
        this.repositoryRoot = sVNUrl;
        this.startProgress();
        this.setProgressQueued();
        this.task = requestProcessor.post((Runnable)this);
        this.task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SvnProgressSupport.this.delegate = null;
            }
        });
        return this.task;
    }

    public void setRepositoryRoot(SVNUrl sVNUrl) {
        this.repositoryRoot = sVNUrl;
        this.logger = null;
    }

    public void run() {
        this.setProgress();
        this.performIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIntern() {
        try {
            SvnProgressSupport.log("Start - " + this.displayName);
            if (!this.canceled) {
                this.perform();
            }
        }
        finally {
            SvnProgressSupport.log("End - " + this.displayName);
            this.finnishProgress();
            this.getLogger().closeLog();
        }
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        if (this.canceled) {
            return false;
        }
        this.getLogger().flushLog();
        if (this.delegate != null) {
            this.delegate.cancel();
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.getProgressHandle().finish();
        this.canceled = true;
        return true;
    }

    public void setCancellableDelegate(Cancellable cancellable) {
        this.delegate = cancellable;
    }

    public void setDisplayName(String string) {
        if (this.originalDisplayName.equals("")) {
            this.originalDisplayName = string;
        }
        this.logChangedDisplayName(this.displayName, string);
        this.displayName = string;
        this.setProgress();
    }

    private void setProgressQueued() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage(SvnProgressSupport.class, (String)"LBL_Queued", (Object)this.displayName));
        }
    }

    private void setProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.displayName);
        }
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this, (Action)this.getLogger().getOpenOuptutAction());
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
        this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName);
    }

    protected void finnishProgress() {
        this.getProgressHandle().finish();
        if (!this.isCanceled()) {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Finished"));
        } else {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Canceled"));
        }
    }

    protected OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Subversion.getInstance().getLogger(this.repositoryRoot);
        }
        return this.logger;
    }

    private static void log(String string) {
        SvnUtils.logT9Y(string);
        Subversion.LOG.log(Level.FINE, string);
    }

    private void logChangedDisplayName(String string, String string2) {
        if (string != null && !string.equals(string2) && !string.equals("")) {
            SvnProgressSupport.log("End - " + string);
            SvnProgressSupport.log("Start - " + string2);
        }
    }

    public void annotate(SVNClientException sVNClientException) {
        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), !this.isCanceled(), true);
    }
}

