/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String propertyName;
    private final String revision;
    private final String title;
    private String mimeType;
    private boolean initialized;
    private File remoteFile;
    private MultiDiffPanel.Property propertyValue;

    public DiffStreamSource(File file, String string, String string2, String string3) {
        this.baseFile = file;
        this.propertyName = string;
        this.revision = string2;
        this.title = string3;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.propertyName != null) {
            if (this.propertyValue != null) {
                return this.propertyValue.toReader();
            }
            return null;
        }
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return this.propertyName == null && "LOCAL".equals(this.revision) && this.isPrimary();
    }

    private boolean isPrimary() {
        FileObject fileObject = FileUtil.toFileObject((File)this.baseFile);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return fileObject.equals(dataObject.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.propertyName != null || this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.remoteFile);
        if (fileObject == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{fileObject});
    }

    synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.propertyValue != null || this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.propertyName != null) {
            this.initProperty();
            return;
        }
        if (this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = SvnUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File file = Utils.getTempFolder();
                Set set = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file2 : set) {
                    boolean bl = file2.equals(this.baseFile);
                    try {
                        File file3 = VersionsCache.getInstance().getFileRevision(file2, this.revision);
                        if (file3 == null) {
                            this.remoteFile = null;
                            return;
                        }
                        File file4 = new File(file, file2.getName());
                        file4.deleteOnExit();
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file4), (InputStream)new FileInputStream(file3));
                        if (!bl) continue;
                        this.remoteFile = file4;
                        Utils.associateEncoding((File)file2, (File)file4);
                    }
                    catch (Exception exception) {
                        if (!bl) continue;
                        throw exception;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = SvnUtils.getMimeType(this.remoteFile);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Can not load remote file for " + this.baseFile);
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void initProperty() throws IOException {
        PropertiesClient propertiesClient = new PropertiesClient(this.baseFile);
        if ("BASE".equals(this.revision)) {
            byte[] byArray = propertiesClient.getBaseProperties().get(this.propertyName);
            this.propertyValue = byArray != null ? new MultiDiffPanel.Property(byArray) : null;
        } else if ("LOCAL".equals(this.revision)) {
            byte[] byArray = propertiesClient.getProperties().get(this.propertyName);
            this.propertyValue = byArray != null ? new MultiDiffPanel.Property(byArray) : null;
        }
        this.mimeType = this.propertyValue != null ? this.propertyValue.getMIME() : "content/unknown";
    }
}

