/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.event.FocusEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportPanel;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ImportStep
extends AbstractStep
implements DocumentListener,
WizardDescriptor.AsynchronousValidatingPanel,
WizardDescriptor.FinishablePanel {
    private ImportPanel importPanel;
    private RepositoryPaths repositoryPaths;
    private BrowserAction[] actions;
    private File importDirectory;
    private WizardStepProgressSupport support;

    public ImportStep(BrowserAction[] browserActionArray, File file) {
        this.actions = browserActionArray;
        this.importDirectory = file;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportStep.class);
    }

    protected JComponent createComponent() {
        if (this.importPanel == null) {
            this.importPanel = new ImportPanel();
            this.importPanel.messageTextArea.getDocument().addDocumentListener(this);
            this.importPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
        }
        return this.importPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            this.support = new ImportProgressSupport(this.importPanel.progressPanel, this.importPanel.progressLabel);
            SVNUrl sVNUrl = this.getUrl();
            if (sVNUrl == null) {
                return;
            }
            this.support.setRepositoryRoot(sVNUrl);
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
            RequestProcessor.Task task = this.support.start(requestProcessor, sVNUrl, NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_Progress"));
            task.waitFinished();
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        RepositoryFile repositoryFile = this.getRepositoryFile();
        return repositoryFile == null ? null : repositoryFile.getRepositoryUrl();
    }

    public boolean validateUserInput() {
        boolean bl;
        this.invalid(null);
        String string = this.importPanel.repositoryPathTextField.getText().trim();
        if (string.length() == 0) {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"BK2014"), true));
            return false;
        }
        string = this.importPanel.messageTextArea.getText().trim();
        boolean bl2 = bl = string.length() > 0;
        if (bl) {
            this.valid();
        } else {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_MessageRequired"), true));
        }
        return bl;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateUserInput();
    }

    public String getImportMessage() {
        return SvnUtils.fixLineEndings(this.importPanel.messageTextArea.getText());
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.importPanel.repositoryPathTextField.getText().trim().equals("")) {
            if (this.repositoryPaths == null) {
                this.repositoryPaths = new RepositoryPaths(repositoryFile, this.importPanel.repositoryPathTextField, this.importPanel.browseRepositoryButton, null, null);
                String string = NbBundle.getMessage(ImportStep.class, (String)"LBL_BrowserMessage");
                int n = 2;
                this.repositoryPaths.setupBehavior(string, n, this.actions, "org.netbeans.modules.subversion.ui.browser.import", null);
            } else {
                this.repositoryPaths.setRepositoryFile(repositoryFile);
            }
        }
        this.importPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.validateUserInput();
    }

    public RepositoryFile getRepositoryFile() {
        try {
            return this.repositoryPaths.getRepositoryFiles()[0];
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
            this.invalid(new AbstractStep.WizardMessage(malformedURLException.getLocalizedMessage(), false));
            return null;
        }
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.getRepositoryFile().getFileUrl();
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public boolean isFinishPanel() {
        return true;
    }

    private class ImportProgressSupport
    extends WizardStepProgressSupport {
        public ImportProgressSupport(JPanel jPanel, JLabel jLabel) {
            super(jPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void perform() {
            AbstractStep.WizardMessage wizardMessage;
            block45: {
                block44: {
                    Object object;
                    SVNUrl sVNUrl;
                    RepositoryFile repositoryFile;
                    SvnClient svnClient;
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    wizardMessage = null;
                                    try {
                                        if (ImportStep.this.validateUserInput()) break block40;
                                        Subversion.getInstance().versionedFilesChanged();
                                    }
                                    catch (Throwable throwable) {
                                        Subversion.getInstance().versionedFilesChanged();
                                        if (this.isCanceled()) {
                                            ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                                        } else if (wizardMessage != null) {
                                            ImportStep.this.valid(wizardMessage);
                                        } else {
                                            ImportStep.this.valid();
                                        }
                                        throw throwable;
                                    }
                                    if (this.isCanceled()) {
                                        ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                                    } else if (wizardMessage != null) {
                                        ImportStep.this.valid(wizardMessage);
                                    } else {
                                        ImportStep.this.valid();
                                    }
                                    return;
                                }
                                ImportStep.this.invalid(null);
                                try {
                                    svnClient = Subversion.getInstance().getClient(ImportStep.this.repositoryPaths.getRepositoryUrl(), (SvnProgressSupport)this);
                                }
                                catch (SVNClientException sVNClientException) {
                                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                                    wizardMessage = new AbstractStep.WizardMessage(SvnClientExceptionHandler.parseExceptionMessage(sVNClientException), false);
                                    Subversion.getInstance().versionedFilesChanged();
                                    if (this.isCanceled()) {
                                        ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                                    } else if (wizardMessage != null) {
                                        ImportStep.this.valid(wizardMessage);
                                    } else {
                                        ImportStep.this.valid();
                                    }
                                    return;
                                }
                                repositoryFile = ImportStep.this.getRepositoryFile();
                                sVNUrl = repositoryFile.getRepositoryUrl();
                                if (this.importIntoExisting(svnClient, repositoryFile.getFileUrl())) break block41;
                                wizardMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_TargetFolderExists"), true);
                                Subversion.getInstance().versionedFilesChanged();
                                if (this.isCanceled()) {
                                    ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                                } else if (wizardMessage != null) {
                                    ImportStep.this.valid(wizardMessage);
                                } else {
                                    ImportStep.this.valid();
                                }
                                return;
                            }
                            try {
                                FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + SvnUtils.SVN_ADMIN_DIR));
                                object = new File(System.getProperty("java.io.tmpdir") + "/svn_dummy/" + ImportStep.this.importDirectory.getName());
                                ((File)object).mkdirs();
                                ((File)object).deleteOnExit();
                                svnClient.doImport((File)object, repositoryFile.getFileUrl(), ImportStep.this.getImportMessage(), false);
                            }
                            catch (SVNClientException sVNClientException) {
                                if (SvnClientExceptionHandler.isFileAlreadyExists(sVNClientException.getMessage())) break block42;
                                throw sVNClientException;
                            }
                        }
                        if (!this.isCanceled()) break block43;
                        Subversion.getInstance().versionedFilesChanged();
                        if (this.isCanceled()) {
                            ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                        } else if (wizardMessage != null) {
                            ImportStep.this.valid(wizardMessage);
                        } else {
                            ImportStep.this.valid();
                        }
                        return;
                    }
                    object = new RepositoryFile[]{repositoryFile};
                    CheckoutAction.checkout(svnClient, sVNUrl, (RepositoryFile[])object, ImportStep.this.importDirectory, true, this);
                    Subversion.getInstance().versionedFilesChanged();
                    SvnUtils.refreshParents(ImportStep.this.importDirectory);
                    Subversion.getInstance().getStatusCache().refreshRecursively(ImportStep.this.importDirectory);
                    if (!this.isCanceled()) break block44;
                    FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + SvnUtils.SVN_ADMIN_DIR));
                    Subversion.getInstance().versionedFilesChanged();
                    if (this.isCanceled()) {
                        ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
                    } else if (wizardMessage != null) {
                        ImportStep.this.valid(wizardMessage);
                    } else {
                        ImportStep.this.valid();
                    }
                    return;
                }
                break block45;
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                    wizardMessage = new AbstractStep.WizardMessage(SvnClientExceptionHandler.parseExceptionMessage(sVNClientException), false);
                }
            }
            Subversion.getInstance().versionedFilesChanged();
            if (this.isCanceled()) {
                ImportStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"), false));
            } else if (wizardMessage != null) {
                ImportStep.this.valid(wizardMessage);
            } else {
                ImportStep.this.valid();
            }
        }

        public void setEditable(boolean bl) {
            ((ImportStep)ImportStep.this).importPanel.browseRepositoryButton.setEnabled(bl);
            ((ImportStep)ImportStep.this).importPanel.messageTextArea.setEditable(bl);
            ((ImportStep)ImportStep.this).importPanel.repositoryPathTextField.setEditable(bl);
        }

        private void deleteDirectory(File file) {
            File[] fileArray = file.listFiles();
            if (fileArray != null || fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        this.deleteDirectory(fileArray[i]);
                        continue;
                    }
                    fileArray[i].delete();
                }
            }
            file.delete();
        }

        private boolean importIntoExisting(SvnClient svnClient, SVNUrl sVNUrl) {
            try {
                ISVNInfo iSVNInfo = svnClient.getInfo(sVNUrl);
                if (iSVNInfo != null) {
                    boolean[] blArray = new boolean[]{true};
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(ImportStep.class, (String)"MSG_ImportIntoExisting", (Object)sVNUrl.toString()), NbBundle.getMessage(ImportStep.class, (String)"CTL_TargetFolderExists"), 1, 3, null, NotifyDescriptor.YES_OPTION);
                    if (DialogDisplayer.getDefault().notify(notifyDescriptor) != NotifyDescriptor.YES_OPTION) {
                        blArray[0] = false;
                    }
                    return blArray[0];
                }
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            return true;
        }
    }
}

