/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.jaxb.ui.JAXBBindingInfoPnl;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JAXBWizBindingCfgPanel
implements WizardDescriptor.Panel,
WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    public static final int MODE_WIZARD = 0;
    public static final int MODE_EDITING = 1;
    private static final String WIZ_NEW_FILE_TITLE = "NewFileWizard_Title";
    private WizardDescriptor wd = null;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JAXBBindingInfoPnl bindingInfoPnl = null;
    private List<String> existingSchemaNames = null;
    private File projDir = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public JAXBWizBindingCfgPanel() {
        this.initUI();
    }

    private void initUI() {
        this.bindingInfoPnl = new JAXBBindingInfoPnl(this);
        this.bindingInfoPnl.setName(NbBundle.getMessage(this.getClass(), (String)"LBL_JAXBWizTitle"));
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void validate() throws WizardValidationException {
        this.logger.log(Level.FINEST, "validate() called.");
    }

    private boolean isEmpty(String string) {
        boolean bl = true;
        if (string != null && !"".equals(string.trim())) {
            bl = false;
        }
        return bl;
    }

    private void setError(String string) {
        this.wd.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private boolean isValid(StringBuffer stringBuffer) {
        this.logger.log(Level.FINEST, "isValidate() called.");
        boolean bl = true;
        if (this.isEmpty(this.bindingInfoPnl.getSchemaName())) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaName"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        Map<String, Boolean> map = this.bindingInfoPnl.getSchemaName();
        if (this.existingSchemaNames != null && this.existingSchemaNames.contains(map)) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_SchemaNameExists"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        if (((String)((Object)map)).indexOf(",") > -1 || ((String)((Object)map)).indexOf(".") > -1 || ((String)((Object)map)).indexOf("\\") > -1 || ((String)((Object)map)).indexOf("/") > -1 || ((String)((Object)map)).indexOf(";") > -1 || ((String)((Object)map)).indexOf(":") > -1) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_InvalidCharInSchemaName"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        if (this.isEmpty(this.bindingInfoPnl.getSchemaFile()) && this.isEmpty(this.bindingInfoPnl.getSchemaURL())) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        if (this.bindingInfoPnl.isFromURLSelected() && (this.isEmpty((String)((Object)(map = (map = this.bindingInfoPnl.getSchemaURL()) != null ? ((String)((Object)map)).trim() : ""))) || "http://".equalsIgnoreCase((String)((Object)map)))) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        if (this.bindingInfoPnl.isFromFSSelected()) {
            map = this.bindingInfoPnl.getSchemaFile();
            map = map != null ? ((String)((Object)map)).trim() : "";
            if (this.isEmpty((String)((Object)map))) {
                stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
                bl = false;
                this.setError(stringBuffer.toString());
                return bl;
            }
            File file = null;
            file = ((String)((Object)map)).startsWith("\\") || ((String)((Object)map)).startsWith("/") || ((String)((Object)map)).indexOf(":") == 1 ? new File((String)((Object)map)) : new File(this.projDir, (String)((Object)map));
            if (((String)((Object)map)).startsWith(".") || ((String)((Object)map)).startsWith("..")) {
                // empty if block
            }
            if (!file.exists()) {
                stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_enterValidSchemaFile"));
                bl = false;
                this.setError(stringBuffer.toString());
                return bl;
            }
            if (!file.isFile()) {
                stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_enterValidSchemaFile"));
                bl = false;
                this.setError(stringBuffer.toString());
                return bl;
            }
        }
        if (!(this.isEmpty(this.bindingInfoPnl.getPackageName()) || ((String)((Object)(map = this.bindingInfoPnl.getPackageName()))).indexOf(",") <= -1 && ((String)((Object)map)).indexOf("\\") <= -1 && ((String)((Object)map)).indexOf("/") <= -1 && ((String)((Object)map)).indexOf(";") <= -1 && ((String)((Object)map)).indexOf(":") <= -1)) {
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_InvalidCharInPackageName"));
            bl = false;
            this.setError(stringBuffer.toString());
            return bl;
        }
        map = this.bindingInfoPnl.getOptions();
        if (Boolean.TRUE.equals(map.get("-quiet")) && Boolean.TRUE.equals(map.get("-verbose"))) {
            bl = false;
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"MSG_CanNotSelectQuietAndVerbose"));
            this.setError(stringBuffer.toString());
            return bl;
        }
        if (bl) {
            this.setError(null);
            return bl;
        }
        this.setError(stringBuffer.toString());
        return bl;
    }

    public boolean isValid() {
        StringBuffer stringBuffer = new StringBuffer();
        return this.isValid(stringBuffer);
    }

    public boolean isFinishPanel() {
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JAXBWizBindingCfgPanel.class);
    }

    public Component getComponent() {
        return this.bindingInfoPnl;
    }

    public void setMode(int n) {
        switch (n) {
            case 1: {
                break;
            }
        }
    }

    public void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        try {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "fireChangeEvent()", exception);
        }
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        wizardDescriptor.putProperty(WIZ_NEW_FILE_TITLE, null);
        if (this.bindingInfoPnl.getSchemaName() != null) {
            wizardDescriptor.putProperty("schema.name", (Object)this.bindingInfoPnl.getSchemaName());
        }
        if (this.bindingInfoPnl.getPackageName() != null) {
            wizardDescriptor.putProperty("xsd.package.name", (Object)this.bindingInfoPnl.getPackageName());
        }
        if (this.bindingInfoPnl.getSchemaType() != null) {
            wizardDescriptor.putProperty("jaxb.schema.type", (Object)this.bindingInfoPnl.getSchemaType());
        }
        Map<String, Boolean> map = this.bindingInfoPnl.getOptions();
        wizardDescriptor.putProperty("jaxb.xjc.options", map);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.bindingInfoPnl.getSchemaFile();
        if (string == null) {
            arrayList.add(this.bindingInfoPnl.getSchemaURL());
            wizardDescriptor.putProperty("xsd.locatiom.type", (Object)"url");
        } else {
            arrayList.add(this.bindingInfoPnl.getSchemaFile());
            wizardDescriptor.putProperty("xsd.locatiom.type", (Object)"fileSystem");
        }
        wizardDescriptor.putProperty("xsd.file.list", arrayList);
        List<String> list = this.bindingInfoPnl.getBindingFiles();
        wizardDescriptor.putProperty("jaxb.binding.files", list);
        String string2 = this.bindingInfoPnl.getCatalogFile();
        wizardDescriptor.putProperty("jaxb.catalog.file", (Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings(Object object) {
        try {
            String string;
            Iterator iterator;
            Map map;
            this.wd = (WizardDescriptor)object;
            this.bindingInfoPnl.setInitializing(true);
            if (this.wd.getProperty("schema.name") != null) {
                this.bindingInfoPnl.setSchemaName((String)this.wd.getProperty("schema.name"));
            }
            if (this.wd.getProperty("project.name") != null) {
                this.bindingInfoPnl.setProjectName((String)this.wd.getProperty("project.name"));
            }
            if (this.wd.getProperty("project.dir") != null) {
                this.bindingInfoPnl.setProjectDir((File)this.wd.getProperty("project.dir"));
                this.projDir = (File)this.wd.getProperty("project.dir");
            }
            if (this.wd.getProperty("xsd.package.name") != null) {
                this.bindingInfoPnl.setPackageName((String)this.wd.getProperty("xsd.package.name"));
            }
            if (this.wd.getProperty("jaxb.schema.type") != null) {
                this.bindingInfoPnl.setSchemaType((String)this.wd.getProperty("jaxb.schema.type"));
            }
            if ((map = (Map)this.wd.getProperty("jaxb.xjc.options")) != null) {
                this.bindingInfoPnl.setOptions(map);
            }
            String string2 = (String)this.wd.getProperty("xsd.locatiom.type");
            List list = (List)this.wd.getProperty("xsd.file.list");
            if (string2 != null && "url".equals(string2)) {
                if (list != null && list.size() > 0) {
                    iterator = list.iterator();
                    string = (String)iterator.next();
                    this.bindingInfoPnl.setSchemaURL(string);
                }
            } else if (list != null && list.size() > 0) {
                iterator = list.iterator();
                string = (String)iterator.next();
                this.bindingInfoPnl.setSchemaFile(string);
            }
            if ((iterator = (List)this.wd.getProperty("jaxb.binding.files")) != null) {
                this.bindingInfoPnl.setBindingFiles((List<String>)((Object)iterator));
            }
            if ((string = (String)this.wd.getProperty("jaxb.catalog.file")) != null) {
                this.bindingInfoPnl.setCatalogFile(string);
            }
            this.existingSchemaNames = (List)this.wd.getProperty("jaxb.cfg.existingSchemaNames");
            if (this.wd instanceof TemplateWizard) {
                this.wd.putProperty(WIZ_NEW_FILE_TITLE, (Object)NbBundle.getMessage(this.getClass(), (String)"LBL_TemplateWizardTitle"));
            }
        }
        finally {
            this.bindingInfoPnl.setInitializing(false);
        }
    }
}

