/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource;

import java.awt.Component;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.components.general.ClassCode;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.ResourceEditorPanel;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.FontEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.ImageEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.TickerEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditorResourceLazyInit
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private Map<String, DesignComponent> createdComponents;
    private final TypeID componentTypeID;
    private String noneComponentAsText;
    private String newComponentAsText;
    private ResourceEditorPanel rePanel;
    private JRadioButton radioButton;
    private PropertyEditorResourceElement perElement;
    private DatabindingElement databindingElement;
    private boolean databinding;
    private WeakReference<DesignComponent> component;

    public static final DesignPropertyEditor createFontPropertyEditor() {
        return new PropertyEditorResourceLazyInit(FontCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_FONTRESOURCEPE_UCLABEL"), false){

            protected PropertyEditorResourceElement createElement() {
                return new FontEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createTickerPropertyEditor() {
        return new PropertyEditorResourceLazyInit(TickerCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_TICKERRESOURCEPE_UCLABEL"), false){

            protected PropertyEditorResourceElement createElement() {
                return new TickerEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createImagePropertyEditor() {
        return new PropertyEditorResourceLazyInit(ImageCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), false){

            protected PropertyEditorResourceElement createElement() {
                return new ImageEditorElement();
            }
        };
    }

    public static final DesignPropertyEditor createImagePropertyEditorWithDatabinding() {
        return new PropertyEditorResourceLazyInit(ImageCD.TYPEID, NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), true){

            protected PropertyEditorResourceElement createElement() {
                return new ImageEditorElement();
            }
        };
    }

    public PropertyEditorResourceLazyInit(TypeID typeID, String string, String string2, String string3, boolean bl) {
        super(string3);
        this.databinding = bl;
        if (string == null || string2 == null) {
            throw Debug.illegalArgument((Object[])new Object[]{"Argument can not be null"});
        }
        if (string.equals(string2)) {
            throw Debug.illegalArgument((Object[])new Object[]{"Arguments can not be equal"});
        }
        this.componentTypeID = typeID;
        this.newComponentAsText = string;
        this.noneComponentAsText = string2;
        this.createdComponents = new HashMap<String, DesignComponent>();
    }

    protected abstract PropertyEditorResourceElement createElement();

    @Override
    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.createdComponents != null) {
            this.createdComponents.clear();
            this.createdComponents = null;
        }
        if (this.rePanel != null) {
            this.rePanel.clean(designComponent);
            this.rePanel = null;
        }
        this.radioButton = null;
        if (this.perElement != null && this.perElement instanceof CleanUp) {
            ((CleanUp)((Object)this.perElement)).clean(designComponent);
            this.perElement = null;
        }
        if (this.databindingElement != null) {
            this.databindingElement.clean(designComponent);
            this.databindingElement = null;
        }
    }

    @Override
    public void setAsText(String string) {
        this.saveValue(string);
    }

    @Override
    public final Component getCustomEditor() {
        Serializable serializable;
        if (this.perElement == null) {
            serializable = this.component != null ? (DesignComponent)this.component.get() : null;
            this.perElement = this.createElement();
            this.perElement.setDesignComponent((DesignComponent)serializable);
            this.perElement.setPropertyEditorMessageAwareness(this);
        }
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton();
            this.rePanel = new ResourceEditorPanel(this.perElement, this.noneComponentAsText, this.radioButton);
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"LBL_RB_RESOURCE"));
            this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"ACSN_RB_RESOURCE"));
            this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorResourceLazyInit.class, (String)"ACSD_RB_RESOURCE"));
            this.perElement.addPropertyEditorResourceElementListener(this.rePanel);
            if (this.databinding) {
                serializable = new ArrayList(2);
                this.databindingElement = new DatabindingElement(this);
                serializable.add(this);
                serializable.add(this.databindingElement);
                this.initElements((Collection<PropertyEditorElement>)((Object)serializable));
            } else {
                this.initElements(Collections.singleton(this));
            }
        }
        serializable = super.getCustomEditor();
        if (this.getValue() instanceof PropertyValue) {
            this.updateState((PropertyValue)this.getValue());
        }
        this.perElement.getCustomEdiotrNotification();
        return serializable;
    }

    protected Map<String, DesignComponent> getComponentsMap() {
        final TreeMap<String, DesignComponent> treeMap = new TreeMap<String, DesignComponent>();
        if (this.component == null || this.component.get() == null) {
            return treeMap;
        }
        final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                Collection collection = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID).getComponents();
                for (DesignComponent designComponent : collection) {
                    if (!designComponent.getType().equals((Object)PropertyEditorResourceLazyInit.this.componentTypeID)) continue;
                    treeMap.put(PropertyEditorResourceLazyInit.this.getComponentDisplayName(designComponent), designComponent);
                }
            }
        });
        return treeMap;
    }

    private String getComponentDisplayName(DesignComponent designComponent) {
        if (designComponent == null) {
            return this.noneComponentAsText;
        }
        if (designComponent.getParentComponent() == null && designComponent.getDocument().getRootComponent() != designComponent) {
            return this.noneComponentAsText;
        }
        return MidpValueSupport.getHumanReadableString(designComponent);
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.component == null || this.getPropertyNames() == null) {
            return null;
        }
        String string = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return this.getDecodeValue(propertyValue);
    }

    private void setValue(PropertyValue propertyValue) {
        super.setValue((Object)propertyValue);
        if (this.perElement == null) {
            return;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (!NULL_VALUE.equals(propertyValue) && this.perElement.isPostSetValueSupported(designComponent)) {
            this.perElement.postSetValue(designComponent, propertyValue.getComponent());
        } else if (NULL_VALUE.equals(propertyValue)) {
            this.perElement.nullValueSet(designComponent);
        }
    }

    private void saveValue(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        Map<String, DesignComponent> map = this.getComponentsMap();
        if (map.get(string) != null) {
            this.setValue(PropertyValue.createComponentReference((DesignComponent)map.get(string)));
        } else if (string.equals(this.noneComponentAsText)) {
            this.setValue(NULL_VALUE);
        } else if (string.equals(this.newComponentAsText)) {
            designDocument.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent;
                    ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                    if (componentProducer == null) {
                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                    }
                    DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID);
                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)designComponent2, (ComponentProducer)componentProducer, null);
                    DesignComponent designComponent3 = designComponent = result != null ? result.getMainComponent() : null;
                    if (designComponent != null) {
                        PropertyEditorResourceLazyInit.this.initInstanceNameForComponent(designComponent);
                        PropertyEditorResourceLazyInit.this.setValue(PropertyValue.createComponentReference((DesignComponent)designComponent));
                    }
                }
            });
        } else {
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> map2 = this.rePanel.getWrappersMap();
            for (String string2 : map2.keySet()) {
                if (!string2.equals(string)) continue;
                DesignComponent designComponent = this.createdComponents.get(string);
                this.setValue(PropertyValue.createComponentReference((DesignComponent)designComponent));
                this.createdComponents.clear();
                break;
            }
        }
    }

    private void initInstanceNameForComponent(DesignComponent designComponent) {
        String string = ClassCode.getSuggestedMainName(this.componentTypeID);
        PropertyValue propertyValue = InstanceNameResolver.createFromSuggested(designComponent, string);
        designComponent.writeProperty("instanceName", propertyValue);
    }

    private String getDecodeValue(final PropertyValue propertyValue) {
        if (propertyValue == null || propertyValue.getKind() == PropertyValue.Kind.NULL) {
            return this.noneComponentAsText;
        }
        if (this.component == null || this.component.get() == null) {
            return this.noneComponentAsText;
        }
        final String[] stringArray = new String[1];
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = propertyValue.getComponent();
                stringArray[0] = PropertyEditorResourceLazyInit.this.getComponentDisplayName(designComponent);
            }
        });
        return stringArray[0] != null ? stringArray[0] : "n/a";
    }

    @Override
    public void init(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
        if (this.perElement != null) {
            this.perElement.setDesignComponent(designComponent);
        }
        super.init(designComponent);
    }

    public String[] getTags() {
        Set<String> set = this.getComponentsMap().keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size() + 2);
        if (this.isCurrentValueAUserCodeType()) {
            arrayList.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            arrayList.add(this.noneComponentAsText);
            arrayList.addAll(set);
            arrayList.add(this.newComponentAsText);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.getRadioButton().isSelected()) {
            this.saveChanges();
            this.saveValue(this.getTextForPropertyValue());
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(designComponent);
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(designComponent);
        }
    }

    public boolean executeInsideWriteTransaction() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return false;
        }
        return super.executeInsideWriteTransaction();
    }

    @Override
    public boolean isExecuteInsideWriteTransactionUsed() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return true;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    @Override
    public String getTextForPropertyValue() {
        return this.rePanel.getTextForPropertyValue();
    }

    private void saveChanges() {
        if (this.rePanel.wasAnyDesignComponentChanged()) {
            Map<String, DesignComponent> map = this.getComponentsMap();
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> map2 = this.rePanel.getWrappersMap();
            final ArrayList arrayList = new ArrayList();
            for (final String string : map2.keySet()) {
                DesignComponent designComponent;
                final PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = map2.get(string);
                if (designComponentWrapper.hasChanges()) {
                    designComponent = map.get(string);
                    if (designComponent != null) {
                        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                            public void run() {
                                if (designComponentWrapper.getComponent() != null) {
                                    Map<String, PropertyValue> map = designComponentWrapper.getChanges();
                                    for (String string : map.keySet()) {
                                        PropertyValue propertyValue = map.get(string);
                                        designComponent.writeProperty(string, propertyValue);
                                    }
                                } else {
                                    arrayList.add(designComponent);
                                }
                            }
                        });
                    } else {
                        if (designComponentWrapper.isDeleted()) continue;
                        if (this.component != null && this.component.get() != null) {
                            final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
                            designDocument.getTransactionManager().writeAccess(new Runnable(){

                                public void run() {
                                    DesignComponent designComponent;
                                    ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                                    if (componentProducer == null) {
                                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResourceLazyInit.this.componentTypeID.toString());
                                    }
                                    DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID);
                                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)designComponent2, (ComponentProducer)componentProducer, null);
                                    DesignComponent designComponent3 = designComponent = result != null ? result.getMainComponent() : null;
                                    if (designComponent != null) {
                                        designComponent.writeProperty("instanceName", MidpTypes.createStringValue(string));
                                        Map<String, PropertyValue> map = designComponentWrapper.getChanges();
                                        for (String string2 : map.keySet()) {
                                            PropertyValue propertyValue = map.get(string2);
                                            designComponent.writeProperty(string2, propertyValue);
                                        }
                                        PropertyEditorResourceLazyInit.this.createdComponents.put(string, designComponent);
                                    }
                                }
                            });
                        }
                    }
                }
                if (arrayList.isEmpty() || this.component == null || this.component.get() == null) continue;
                designComponent = ((DesignComponent)this.component.get()).getDocument();
                designComponent.getTransactionManager().writeAccess(new Runnable((DesignDocument)designComponent, arrayList){
                    final /* synthetic */ DesignDocument val$document;
                    final /* synthetic */ Collection val$toBeDeleted;
                    {
                        this.val$document = designDocument;
                        this.val$toBeDeleted = collection;
                    }

                    public void run() {
                        DeleteSupport.invokeDirectUserDeletion((DesignDocument)this.val$document, (Collection)this.val$toBeDeleted, (boolean)false);
                    }
                });
            }
            this.perElement.postSaveValue((DesignComponent)this.component.get());
        }
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.rePanel;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public void updateState(PropertyValue propertyValue) {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(designComponent);
        }
        if (this.getPropertyDisplayName() != null && MidpDatabindingSupport.getDatabaindingAsText(designComponent, (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(designComponent);
        } else if (this.rePanel.needsUpdate()) {
            this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
            this.rePanel.update(this.getComponentsMap(), this.getDecodeValue(propertyValue));
        }
    }

    public boolean isResetToDefaultAutomatically() {
        if (this.component == null) {
            super.isResetToDefaultAutomatically();
        }
        return this.perElement.isResetToDefaultAutomatically((DesignComponent)this.component.get());
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (this.component != null && this.component.get() != null) {
            this.perElement.preResetToDefaultValue((DesignComponent)this.component.get());
        }
        super.customEditorResetToDefaultButtonPressed();
    }

    @Override
    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }
}

