/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedefImpl
extends OffsetableDeclarationBase<CsmTypedef>
implements CsmTypedef,
Disposable,
CsmScopeElement {
    private final CharSequence name;
    private final CsmType type;
    private boolean typeUnnamed = false;
    private CsmObject containerRef;
    private CsmUID<CsmIdentifiable> containerUID;

    public TypedefImpl(AST aST, CsmFile csmFile, CsmObject csmObject, CsmType csmType, String string, boolean bl) {
        super(aST, csmFile);
        if (UIDCsmConverter.isIdentifiable(csmObject)) {
            this.containerUID = UIDCsmConverter.identifiableToUID((CsmIdentifiable)csmObject);
            assert (this.containerUID != null || csmObject == null);
            this.containerRef = null;
        } else {
            this.containerRef = csmObject;
        }
        this.type = csmType == null ? this.createType(aST) : csmType;
        if (string.length() == 0) {
            string = this.fixBuiltInTypedef(aST);
        }
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
        if (!bl) {
            Utils.setSelfUID(this);
        }
    }

    private String fixBuiltInTypedef(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            AST aST3 = null;
            while (aST2 != null && aST2.getType() != 134 && aST2.getType() != 136) {
                aST3 = aST2;
                aST2 = aST2.getNextSibling();
            }
            if (aST3 != null) {
                for (aST2 = aST3.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                    if (aST2.getText() == null || aST2.getText().length() <= 0 || !Character.isJavaIdentifierStart(aST2.getText().charAt(0))) continue;
                    aST3 = aST2;
                }
                if (aST3.getText() != null && aST3.getText().length() > 0 && Character.isJavaIdentifierStart(aST3.getText().charAt(0))) {
                    return aST3.getText();
                }
            }
        }
        return "";
    }

    public boolean isTypeUnnamed() {
        return this.typeUnnamed;
    }

    public void setTypeUnnamed() {
        this.typeUnnamed = true;
    }

    public CsmScope getScope() {
        CsmObject csmObject = this._getContainer();
        if (csmObject instanceof CsmNamespace) {
            return (CsmNamespace)csmObject;
        }
        if (csmObject instanceof CsmClass) {
            return (CsmClass)csmObject;
        }
        return this.getContainingFile();
    }

    @Override
    public void dispose() {
        CsmScope csmScope;
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if ((csmScope = this.getScope()) instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        FileImpl fileImpl = (FileImpl)this.getContainingFile();
        fileImpl.getProjectImpl(true).unregisterDeclaration(this);
    }

    private synchronized void onDispose() {
        if (this.containerRef == null) {
            CsmObject csmObject = this.containerRef = this.containerRef != null ? this.containerRef : (CsmObject)UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (this.containerRef != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmObject csmObject = this._getContainer();
        if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
            return CharSequenceKey.create((CharSequence)(((CsmClass)csmObject).getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
        }
        if (CsmKindUtilities.isNamespace((Object)csmObject) && (charSequence = ((CsmNamespace)csmObject).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.TYPEDEF;
    }

    private final CsmType createType(AST aST) {
        AST aST2 = null;
        int n = 0;
        AST aST3 = null;
        for (AST aST4 = aST.getFirstChild(); aST4 != null; aST4 = aST4.getNextSibling()) {
            switch (aST4.getType()) {
                case 256: 
                case 257: {
                    aST3 = aST4;
                    break;
                }
                case 74: {
                    AST aST5 = aST4.getNextSibling();
                    if (aST5 == null || aST5.getType() != 289) break;
                    aST3 = aST5;
                }
            }
            if (aST3 != null) break;
        }
        if (aST3 != null) {
            return TypeFactory.createType(aST3, this.getContainingFile(), aST2, n);
        }
        return null;
    }

    public CsmType getType() {
        return this.type;
    }

    private synchronized CsmObject _getContainer() {
        CsmObject csmObject = this.containerRef;
        if (csmObject == null) {
            csmObject = UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (csmObject != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
        return csmObject;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        dataOutput.writeBoolean(this.typeUnnamed);
        assert (this.type != null);
        PersistentUtils.writeType(this.type, dataOutput);
        if (this.containerUID == null) {
            System.err.println("trying to write non-writable typedef:" + this.getContainingFile() + this.toString());
            if (this.containerRef == null) {
                System.err.println("typedef doesn't have container at all");
            }
        } else {
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, dataOutput);
        }
    }

    public TypedefImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.typeUnnamed = dataInput.readBoolean();
        this.type = PersistentUtils.readType(dataInput);
        assert (this.type != null);
        this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        if (this.containerUID == null) {
            System.err.println("non-writable object was read:" + this.getContainingFile() + this.toString());
        }
        this.containerRef = null;
    }
}

