/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeepReparsingUtils {
    private DeepReparsingUtils() {
    }

    public static void reparseOnEdit(FileImpl fileImpl, ProjectBase projectBase) {
        DeepReparsingUtils.reparseOnEdit(fileImpl, projectBase, true);
    }

    public static void reparseOnEdit(FileImpl fileImpl, ProjectBase projectBase, boolean bl) {
        GraphContainer.ParentFiles parentFiles = projectBase.getGraph().getTopParentFiles(fileImpl);
        Set<CsmFile> set = parentFiles.getCompilationUnits();
        Set<CsmFile> set2 = parentFiles.getParentFiles();
        if (set.size() > 0) {
            fileImpl.clearStateCache();
            Set<CsmFile> set3 = projectBase.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles();
            for (CsmFile csmFile : set3) {
                if (set.contains(csmFile)) {
                    ((FileImpl)csmFile).clearStateCache();
                    continue;
                }
                if (set2.contains(csmFile)) {
                    ((FileImpl)csmFile).clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
            }
            if (bl) {
                DeepReparsingUtils.addToReparse(projectBase, set, new HashSet<CsmFile>(0), false);
            }
        } else if (bl) {
            ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.HEAD);
        }
    }

    static void reparseOnEdit(Collection<FileImpl> collection, ProjectBase projectBase, boolean bl) {
        Object object;
        HashSet<CsmUID<CsmFile>> hashSet = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> hashSet2 = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> hashSet3 = new HashSet<CsmUID<CsmFile>>();
        for (FileImpl object2 : collection) {
            GraphContainer.ParentFiles parentFiles = projectBase.getGraph().getTopParentFiles(object2);
            object = parentFiles.getCompilationUnitsUids();
            if (object.size() > 0) {
                hashSet.addAll((Collection<CsmUID<CsmFile>>)object);
                hashSet2.addAll(parentFiles.getParentFilesUids());
                hashSet3.addAll(projectBase.getGraph().getCoherenceFiles(object2).getCoherenceFilesUids());
                continue;
            }
            if (!bl) continue;
            ParserQueue.instance().add(object2, projectBase.getPreprocHandler(object2.getBuffer().getFile()).getState(), ParserQueue.Position.HEAD);
        }
        if (hashSet.size() > 0) {
            HashSet hashSet4 = new HashSet();
            for (CsmUID csmUID : hashSet3) {
                object = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (object == null) continue;
                if (hashSet.contains(csmUID)) {
                    hashSet4.add(object);
                    ((FileImpl)object).clearStateCache();
                    continue;
                }
                if (hashSet2.contains(csmUID)) {
                    ((FileImpl)object).clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, (CsmFile)object);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, (CsmFile)object);
            }
            if (bl) {
                DeepReparsingUtils.addToReparse(projectBase, hashSet4, new HashSet<CsmFile>(0), false);
            }
        }
    }

    public static void reparseOnPropertyChanged(NativeFileItem nativeFileItem, ProjectBase projectBase) {
        FileImpl fileImpl = projectBase.getFile(nativeFileItem.getFile(), false);
        if (fileImpl == null) {
            return;
        }
        fileImpl.clearStateCache();
        Set<CsmFile> set = projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits();
        Set<CsmFile> set2 = projectBase.getGraph().getIncludedFiles(fileImpl);
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        for (CsmFile csmFile : set2) {
            if (set.contains(csmFile)) continue;
            CsmProject csmProject = csmFile.getProject();
            if (projectBase.equals(csmProject)) {
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                continue;
            }
            hashSet.add(csmFile);
        }
        if (!TraceFlags.DEEP_REPARSING_OPTIMISTIC) {
            DeepReparsingUtils.gatherCoherenceLibrary(hashSet);
            DeepReparsingUtils.invalidateFileAndPreprocState(hashSet);
        }
        DeepReparsingUtils.addToReparse(projectBase, nativeFileItem, fileImpl);
        set.remove(fileImpl);
        DeepReparsingUtils.addToReparse(projectBase, set, new HashSet<CsmFile>(0), false);
    }

    private static void gatherCoherenceLibrary(Set<CsmFile> set) {
        while (true) {
            HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
            for (CsmFile csmFile : set) {
                hashSet.add(csmFile);
                ProjectBase projectBase = (ProjectBase)csmFile.getProject();
                hashSet.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            if (hashSet.size() == set.size()) {
                return;
            }
            set.addAll(hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reparseOnPropertyChanged(Collection<NativeFileItem> collection, ProjectBase projectBase) {
        try {
            FileImpl fileImpl;
            ParserQueue.instance().onStartAddingProjectFiles(projectBase);
            HashMap<FileImpl, NativeFileItem> hashMap = new HashMap<FileImpl, NativeFileItem>();
            HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            for (NativeFileItem nativeFileItem : collection) {
                if (!projectBase.acceptNativeItem(nativeFileItem) || (fileImpl = projectBase.getFile(nativeFileItem.getFile(), false)) == null) continue;
                fileImpl.clearStateCache();
                hashMap.put(fileImpl, nativeFileItem);
                hashSet.addAll(projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits());
                hashSet2.addAll(projectBase.getGraph().getIncludedFiles(fileImpl));
            }
            for (CsmFile csmFile : hashSet2) {
                if (hashSet.contains(csmFile)) continue;
                fileImpl = csmFile.getProject();
                if (projectBase.equals(fileImpl)) {
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                    continue;
                }
                hashSet3.add(csmFile);
            }
            if (!TraceFlags.DEEP_REPARSING_OPTIMISTIC) {
                DeepReparsingUtils.gatherCoherenceLibrary(hashSet3);
                DeepReparsingUtils.invalidateFileAndPreprocState(hashSet3);
            }
            for (CsmFile csmFile : hashSet) {
                if (csmFile.getProject() != projectBase) continue;
                fileImpl = (FileImpl)csmFile;
                if (hashMap.containsKey(fileImpl)) {
                    NativeFileItem nativeFileItem = (NativeFileItem)hashMap.get(fileImpl);
                    DeepReparsingUtils.addToReparse(projectBase, nativeFileItem, fileImpl);
                    continue;
                }
                DeepReparsingUtils.addToReparse(projectBase, fileImpl, true);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(projectBase);
        }
    }

    public static void reparseOnAdded(NativeFileItem nativeFileItem, ProjectBase projectBase) {
        DeepReparsingUtils.reparseOnAdded(nativeFileItem.getFile().getName(), projectBase);
    }

    public static void reparseOnAdded(FileObject fileObject, ProjectBase projectBase) {
        DeepReparsingUtils.reparseOnAdded(fileObject.getNameExt(), projectBase);
    }

    private static void reparseOnAdded(String string, ProjectBase projectBase) {
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        block0: for (CsmFile object : projectBase.getAllFiles()) {
            for (CsmInclude csmInclude : object.getIncludes()) {
                if (!((Object)csmInclude.getIncludeName()).toString().endsWith(string)) continue;
                hashSet.add(object);
                continue block0;
            }
        }
        if (hashSet.size() > 0) {
            HashSet hashSet2 = new HashSet();
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            for (CsmFile csmFile : hashSet) {
                hashSet2.addAll(projectBase.getGraph().getTopParentFiles(csmFile).getCompilationUnits());
                hashSet3.add(csmFile);
                hashSet3.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            DeepReparsingUtils.addToReparse(projectBase, hashSet2, hashSet3, true);
        }
    }

    static void reparseOnAdded(List<NativeFileItem> list, ProjectBase projectBase) {
        HashSet<String> hashSet = new HashSet<String>();
        for (NativeFileItem object2 : list) {
            hashSet.add(object2.getFile().getName());
        }
        HashSet hashSet2 = new HashSet();
        for (CsmFile csmFile : projectBase.getSourceFiles()) {
            DeepReparsingUtils.findResolved(hashSet, hashSet2, csmFile);
        }
        for (CsmFile csmFile : projectBase.getHeaderFiles()) {
            DeepReparsingUtils.findResolved(hashSet, hashSet2, csmFile);
        }
        if (hashSet2.size() > 0) {
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet4 = new HashSet<CsmFile>();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                CsmFile csmFile = (CsmFile)iterator.next();
                hashSet3.addAll(projectBase.getGraph().getTopParentFiles(csmFile).getCompilationUnits());
                hashSet4.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            DeepReparsingUtils.addToReparse(projectBase, hashSet3, hashSet4, true);
        }
    }

    private static void findResolved(Set<String> set, Set<CsmFile> set2, CsmFile csmFile) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            String string = ((Object)csmInclude.getIncludeName()).toString();
            int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
            if (n > 0) {
                string = string.substring(n);
            }
            if (!set.contains(string)) continue;
            set2.add(csmFile);
            break;
        }
    }

    public static void reparseOnRemoved(FileImpl fileImpl, ProjectBase projectBase) {
        Set<CsmFile> set = projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits();
        Set<CsmFile> set2 = projectBase.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles();
        projectBase.getGraph().removeFile(fileImpl);
        set.remove(fileImpl);
        set2.remove(fileImpl);
        DeepReparsingUtils.addToReparse(projectBase, set, set2, false);
    }

    static void reparseOnRemoved(List<FileImpl> list, ProjectBase projectBase) {
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
        for (FileImpl fileImpl : list) {
            hashSet.addAll(projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits());
            hashSet2.addAll(projectBase.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles());
            projectBase.getGraph().removeFile(fileImpl);
            hashSet.remove(fileImpl);
            hashSet2.remove(fileImpl);
        }
        DeepReparsingUtils.addToReparse(projectBase, hashSet, hashSet2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToReparse(ProjectBase projectBase, Set<CsmFile> set, Set<CsmFile> set2, boolean bl) {
        for (CsmFile csmFile : set2) {
            if (set.contains(csmFile)) continue;
            DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
        }
        try {
            ParserQueue.instance().onStartAddingProjectFiles(projectBase);
            for (CsmFile csmFile : set) {
                if (csmFile.getProject() != projectBase) continue;
                FileImpl fileImpl = (FileImpl)csmFile;
                DeepReparsingUtils.addToReparse(projectBase, fileImpl, bl);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(projectBase);
        }
    }

    private static void addToReparse(ProjectBase projectBase, FileImpl fileImpl, boolean bl) {
        fileImpl.markReparseNeeded(bl);
        ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.HEAD);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
        }
    }

    private static void addToReparse(ProjectBase projectBase, NativeFileItem nativeFileItem, FileImpl fileImpl) {
        if (nativeFileItem.getFile() != null) {
            fileImpl.markReparseNeeded(true);
            APTPreprocHandler.State state = projectBase.setChangedFileState(nativeFileItem);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
            }
            ParserQueue.instance().add(fileImpl, state, ParserQueue.Position.HEAD);
        } else assert (false);
    }

    private static void invalidateFileAndPreprocState(ProjectBase projectBase, CsmFile csmFile) {
        if (csmFile.getProject() == projectBase) {
            FileImpl fileImpl = (FileImpl)csmFile;
            fileImpl.clearStateCache();
            projectBase.invalidatePreprocState(fileImpl.getBuffer().getFile());
            fileImpl.markReparseNeeded(false);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Invalidate file to reparse " + csmFile.getAbsolutePath());
            }
        }
    }

    private static void invalidateFileAndPreprocState(Set<CsmFile> set) {
        for (CsmFile csmFile : set) {
            CsmProject csmProject = csmFile.getProject();
            if (!(csmProject instanceof ProjectBase)) continue;
            FileImpl fileImpl = (FileImpl)csmFile;
            fileImpl.clearStateCache();
            ((ProjectBase)csmProject).invalidatePreprocState(fileImpl.getBuffer().getFile());
            fileImpl.markReparseNeeded(false);
            if (!TraceFlags.USE_DEEP_REPARSING_TRACE) continue;
            System.out.println("Invalidate file to reparse " + csmFile.getAbsolutePath());
        }
    }
}

