/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThread;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ParserThreadManager {
    private static ParserThreadManager instance;
    private static final String threadNameBase = "Code Model Parser";
    private RequestProcessor processor;
    private final Set<Wrapper> wrappers = new CopyOnWriteArraySet<Wrapper>();
    private int currThread = 0;
    private boolean started = false;

    private ParserThreadManager() {
    }

    public static synchronized ParserThreadManager instance() {
        if (instance == null) {
            instance = new ParserThreadManager();
        }
        return instance;
    }

    public boolean isStandalone() {
        return this.processor == null;
    }

    synchronized void startup(boolean bl) {
        if (this.started) {
            this.shutdown();
        }
        ParserQueue.instance().startup();
        int n = CndUtils.getNumberCndWorkerThreads();
        if (!bl) {
            this.processor = new RequestProcessor(threadNameBase, n);
        }
        for (int i = 0; i < n; ++i) {
            Wrapper wrapper = new Wrapper(new ParserThread());
            if (bl) {
                new Thread(wrapper).start();
                continue;
            }
            this.processor.post((Runnable)wrapper);
        }
        this.started = true;
    }

    synchronized void shutdown() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("=== ParserThreadManager.shutdown");
        }
        for (Wrapper wrapper : this.wrappers) {
            wrapper.stop();
        }
        for (Wrapper wrapper : this.wrappers) {
            while (!wrapper.isStoped()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
        }
        ParserQueue.instance().shutdown();
        this.currThread = 0;
        this.started = false;
    }

    public boolean isParserThread() {
        if (this.isStandalone()) {
            Thread thread = Thread.currentThread();
            for (Wrapper wrapper : this.wrappers) {
                if (wrapper.thread != thread) continue;
                return true;
            }
            return false;
        }
        return this.processor.isRequestProcessorThread();
    }

    public void waitEmptyProjectQueue(ProjectBase projectBase) {
        ParserQueue.instance().waitEmpty(projectBase);
    }

    private class Wrapper
    implements Runnable {
        private ParserThread delegate;
        private Thread thread;

        public Wrapper(ParserThread parserThread) {
            this.delegate = parserThread;
        }

        public void stop() {
            assert (this.delegate != null);
            this.delegate.stop();
        }

        public boolean isStoped() {
            assert (this.delegate != null);
            return this.delegate.isStoped();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.thread = Thread.currentThread();
                    this.thread.setName("Code Model Parser " + ParserThreadManager.this.currThread++);
                    ParserThreadManager.this.wrappers.add(this);
                    this.delegate.run();
                }
                catch (Throwable throwable) {
                    DiagnosticExceptoins.register(throwable);
                    Object var3_2 = null;
                    ParserThreadManager.this.wrappers.remove(this);
                    return;
                }
                Object var3_1 = null;
                ParserThreadManager.this.wrappers.remove(this);
                return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ParserThreadManager.this.wrappers.remove(this);
                throw throwable;
            }
        }
    }
}

