/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resolver3
implements Resolver {
    private final ProjectBase project;
    private final CsmFile file;
    private final CsmFile startFile;
    private int offset;
    private final int origOffset;
    private Resolver parentResolver;
    private final List<CharSequence> usedNamespaces = new ArrayList<CharSequence>();
    private final Map<CharSequence, CsmNamespace> namespaceAliases = new HashMap<CharSequence, CsmNamespace>();
    private final Map<CharSequence, CsmDeclaration> usingDeclarations = new HashMap<CharSequence, CsmDeclaration>();
    private CsmTypedef currTypedef;
    private CsmClassifier currLocalClassifier;
    private CharSequence[] names;
    private int currNamIdx;
    private int interestedKind;
    private boolean resolveInBaseClass;
    private boolean inLocalContext = false;
    private CsmNamespace containingNamespace;
    private CsmClass containingClass;
    private boolean contextFound = false;
    private Set<CsmFile> visitedFiles = new HashSet<CsmFile>();

    private CharSequence currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : CharSequenceKey.empty();
    }

    private CsmNamespace getContainingNamespace() {
        if (!this.contextFound) {
            this.findContext();
        }
        return this.containingNamespace;
    }

    private CsmClass getContainingClass() {
        if (!this.contextFound) {
            this.findContext();
        }
        return this.containingClass;
    }

    private void findContext() {
        this.contextFound = true;
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(0, this.offset);
        this.findContext(CsmSelect.getDeclarations((CsmFile)this.file, (CsmSelect.CsmFilter)csmFilter), csmFilter);
    }

    public Resolver3(CsmFile csmFile, int n, Resolver resolver, CsmFile csmFile2) {
        this.file = csmFile;
        this.offset = n;
        this.origOffset = n;
        this.parentResolver = resolver;
        this.project = (ProjectBase)csmFile.getProject();
        this.startFile = csmFile2;
    }

    public Resolver3(CsmFile csmFile, int n, Resolver resolver) {
        this(csmFile, n, resolver, resolver == null ? csmFile : resolver.getStartFile());
    }

    public Resolver3(CsmOffsetable csmOffsetable, Resolver resolver) {
        this(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset(), resolver, resolver == null ? csmOffsetable.getContainingFile() : resolver.getStartFile());
    }

    private CsmClassifier findClassifier(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmClassifier csmClassifier = null;
        while (csmNamespace != null && csmClassifier == null) {
            String string = csmNamespace.getQualifiedName() + "::" + charSequence;
            csmClassifier = this.findClassifier(string);
            csmNamespace = csmNamespace.getParent();
        }
        return csmClassifier;
    }

    private CsmClassifier findClassifier(CharSequence charSequence) {
        CsmClassifier csmClassifier = CsmClassifierResolver.getDefault().findClassifierUsedInFile(charSequence, this.getStartFile(), this.needClasses());
        return csmClassifier;
    }

    @Override
    public CsmFile getStartFile() {
        return this.startFile;
    }

    private CsmNamespace findNamespace(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmNamespace csmNamespace2 = null;
        if (csmNamespace == null) {
            csmNamespace2 = this.findNamespace(charSequence);
        } else {
            for (CsmNamespace csmNamespace3 = csmNamespace; csmNamespace3 != null && csmNamespace2 == null; csmNamespace3 = csmNamespace3.getParent()) {
                String string = (csmNamespace3.isGlobal() ? "" : csmNamespace3.getQualifiedName() + "::") + charSequence;
                csmNamespace2 = this.findNamespace(string);
            }
        }
        return csmNamespace2;
    }

    private CsmNamespace findNamespace(CharSequence charSequence) {
        CsmNamespace csmNamespace = this.project.findNamespace(charSequence);
        if (csmNamespace == null) {
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && csmNamespace == null) {
                CsmProject csmProject = iterator.next();
                csmNamespace = csmProject.findNamespace(charSequence);
            }
        }
        return csmNamespace;
    }

    @Override
    public Collection<CsmProject> getLibraries() {
        return Resolver3.getSearchLibraries(this.startFile.getProject());
    }

    public static Collection<CsmProject> getSearchLibraries(CsmProject csmProject) {
        if (csmProject.isArtificial() && csmProject instanceof ProjectBase) {
            List<ProjectBase> list = ((ProjectBase)csmProject).getDependentProjects();
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
            for (ProjectBase projectBase : list) {
                if (projectBase.isArtificial()) continue;
                hashSet.addAll(projectBase.getLibraries());
            }
            return hashSet;
        }
        return csmProject.getLibraries();
    }

    @Override
    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        AntiLoop antiLoop = new AntiLoop(100);
        while (true) {
            CsmClassForwardDeclaration csmClassForwardDeclaration;
            antiLoop.add(csmClassifier);
            CsmClass csmClass = null;
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                csmClassForwardDeclaration = (CsmClassForwardDeclaration)csmClassifier;
                csmClass = csmClassForwardDeclaration instanceof ClassForwardDeclarationImpl ? ((ClassForwardDeclarationImpl)csmClassForwardDeclaration).getCsmClass(this) : csmClassForwardDeclaration.getCsmClass();
                if (csmClass == null) {
                    break;
                }
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmClassForwardDeclaration = ((CsmTypedef)csmClassifier).getType();
                csmClass = csmClassForwardDeclaration instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)csmClassForwardDeclaration).getClassifier(this) : csmClassForwardDeclaration.getClassifier();
                if (csmClass == null) {
                    break;
                }
            } else {
                if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier)) break;
                csmClass = this.findClassifier(csmClassifier.getQualifiedName());
            }
            if (antiLoop.contains((CsmClassifier)csmClass) && ((csmClass = Resolver3.findOtherClassifier(csmClassifier)) == null || antiLoop.contains((CsmClassifier)csmClass))) break;
            csmClassifier = csmClass;
        }
        return csmClassifier;
    }

    public static CsmClassifier findOtherClassifier(CsmClassifier csmClassifier) {
        CsmClassifier csmClassifier2;
        block1: {
            CsmOffsetableDeclaration csmOffsetableDeclaration;
            CsmNamespace csmNamespace = CsmBaseUtilities.getClassNamespace((CsmClassifier)csmClassifier);
            csmClassifier2 = null;
            if (csmNamespace == null) break block1;
            CsmUID csmUID = UIDs.get((Object)csmClassifier);
            CharSequence charSequence = csmClassifier.getQualifiedName();
            Collection<CsmOffsetableDeclaration> collection = null;
            collection = csmNamespace instanceof NamespaceImpl ? ((NamespaceImpl)csmNamespace).getDeclarationsRange(charSequence, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TEMPLATE_DECLARATION, CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION}) : csmNamespace.getDeclarations();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && (!CsmKindUtilities.isClassifier((CsmObject)(csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next())) || !csmOffsetableDeclaration.getQualifiedName().equals(charSequence) || UIDs.get((Object)csmOffsetableDeclaration).equals(csmUID) || ForwardClass.isForwardClass((CsmDeclaration)(csmClassifier2 = (CsmClassifier)csmOffsetableDeclaration)))) {
            }
        }
        return csmClassifier2;
    }

    private void findContext(Iterator iterator, CsmSelect.CsmFilter csmFilter) {
        while (iterator.hasNext()) {
            CsmFunction csmFunction;
            CsmNamespaceDefinition csmNamespaceDefinition;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                csmNamespaceDefinition = (CsmNamespaceDefinition)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingNamespace = csmNamespaceDefinition.getNamespace();
                this.findContext(CsmSelect.getDeclarations((CsmNamespaceDefinition)csmNamespaceDefinition, (CsmSelect.CsmFilter)csmFilter), csmFilter);
                continue;
            }
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.CLASS || csmDeclaration.getKind() == CsmDeclaration.Kind.STRUCT || csmDeclaration.getKind() == CsmDeclaration.Kind.UNION) {
                csmNamespaceDefinition = (CsmClass)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingClass = csmNamespaceDefinition;
                this.findContext(CsmSelect.getClassMembers((CsmClass)this.containingClass, (CsmSelect.CsmFilter)csmFilter), csmFilter);
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.FUNCTION_DEFINITION && csmDeclaration.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION || (csmNamespaceDefinition = (CsmFunctionDefinition)csmDeclaration).getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
            CsmNamespace csmNamespace = CsmBaseUtilities.getFunctionNamespace((CsmFunction)csmNamespaceDefinition);
            if (csmNamespace != null && !csmNamespace.isGlobal()) {
                this.containingNamespace = csmNamespace;
            }
            if ((csmFunction = this.getFunctionDeclaration((CsmFunctionDefinition)csmNamespaceDefinition)) == null || !CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction)) continue;
            this.containingClass = ((CsmMethod)csmFunction).getContainingClass();
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunctionDefinition csmFunctionDefinition) {
        if (csmFunctionDefinition instanceof FunctionDefinitionImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            return ((FunctionDefinitionImpl)csmFunctionDefinition).getDeclaration(this);
        }
        return csmFunctionDefinition.getDeclaration();
    }

    @Override
    public boolean isRecursionOnResolving(int n) {
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        int n2 = 0;
        while (resolver3 != null) {
            if (resolver3.origOffset == this.origOffset && resolver3.file.equals(this.file)) {
                return true;
            }
            resolver3 = (Resolver3)resolver3.parentResolver;
            if (++n2 <= n) continue;
            return true;
        }
        return false;
    }

    private CsmObject resolveInUsings(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmUsingDirective csmUsingDirective2;
        String string;
        CsmClassifier csmClassifier = null;
        Iterator iterator = CsmUsingResolver.getDefault().findUsingDirectives(csmNamespace).iterator();
        while (iterator.hasNext() && (csmClassifier = this.findClassifier(string = (csmUsingDirective2 = (CsmUsingDirective)iterator.next()).getName() + "::" + charSequence)) == null) {
        }
        if (csmClassifier == null) {
            for (CsmUsingDirective csmUsingDirective2 : CsmUsingResolver.getDefault().findUsedDeclarations(csmNamespace)) {
                if (CharSequenceKey.Comparator.compare(charSequence, csmUsingDirective2.getName()) != 0) continue;
                if (CsmKindUtilities.isClassifier((CsmObject)csmUsingDirective2) && this.needClassifiers()) {
                    csmClassifier = csmUsingDirective2;
                    break;
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmUsingDirective2) || !this.needClasses()) continue;
                csmClassifier = csmUsingDirective2;
                break;
            }
        }
        return csmClassifier;
    }

    private void traceRecursion() {
        System.out.println("Detected recursion in resolver:");
        System.out.println("\t" + this);
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        while (resolver3 != null) {
            System.out.println("\t" + resolver3);
            resolver3 = (Resolver3)resolver3.parentResolver;
        }
        new Exception().printStackTrace();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.file.getAbsolutePath() + ":" + this.origOffset);
        stringBuilder.append(":Looking for ");
        if (this.needClassifiers()) {
            if (this.needClasses()) {
                stringBuilder.append("c");
            } else {
                stringBuilder.append("C");
            }
        }
        if (this.needNamespaces()) {
            stringBuilder.append("N");
        }
        stringBuilder.append(":" + this.currName());
        for (int i = 0; i < this.names.length; ++i) {
            if (i == 0) {
                stringBuilder.append("?");
            } else {
                stringBuilder.append("::");
            }
            stringBuilder.append(this.names[i]);
        }
        if (this.containingClass != null) {
            stringBuilder.append(":Class=" + this.containingClass.getName());
        }
        if (this.containingNamespace != null) {
            stringBuilder.append(":NS=" + this.containingNamespace.getName());
        }
        return stringBuilder.toString();
    }

    private void gatherMaps(CsmFile csmFile) {
        if (csmFile == null || this.visitedFiles.contains(csmFile)) {
            return;
        }
        this.visitedFiles.add(csmFile);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(0, this.offset);
        Iterator iterator = CsmSelect.getIncludes((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmInclude csmInclude = (CsmInclude)iterator.next();
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            int n = this.offset;
            this.offset = Integer.MAX_VALUE;
            this.gatherMaps(csmFile2);
            this.offset = n;
        }
        this.gatherMaps(CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter));
    }

    private void gatherMaps(Iterable<? extends CsmObject> iterable) {
        this.gatherMaps(iterable.iterator());
    }

    private void gatherMaps(Iterator<? extends CsmObject> iterator) {
        while (iterator.hasNext()) {
            CsmObject csmObject = iterator.next();
            assert (csmObject instanceof CsmOffsetable);
            try {
                int n = ((CsmOffsetable)csmObject).getStartOffset();
                int n2 = ((CsmOffsetable)csmObject).getEndOffset();
                if (n >= this.offset) break;
                if (csmObject instanceof CsmScopeElement) {
                    boolean bl = this.inLocalContext;
                    if (!this.inLocalContext && CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                        this.inLocalContext = true;
                    }
                    this.gatherMaps((CsmScopeElement)csmObject, n2);
                    this.inLocalContext = bl;
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + csmObject);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    private CsmClassifier findNestedClassifier(CsmClassifier csmClassifier) {
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
            Iterator iterator = CsmSelect.getClassMembers((CsmClass)((CsmClass)csmClassifier), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.currName(), true, true, false));
            while (iterator.hasNext()) {
                CsmMember csmMember = (CsmMember)iterator.next();
                if (CharSequenceKey.Comparator.compare(this.currName(), csmMember.getName()) != 0 || !CsmKindUtilities.isClassifier((CsmObject)csmMember)) continue;
                return (CsmClassifier)csmMember;
            }
        }
        return null;
    }

    private void doProcessTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.TYPEDEF});
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespaceDefinition)csmNamespaceDefinition, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                this.processTypedefsInUpperNamespaces((CsmNamespaceDefinition)csmDeclaration);
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.TYPEDEF) continue;
            CsmTypedef csmTypedef = (CsmTypedef)csmDeclaration;
            if (CharSequenceKey.Comparator.compare(this.currName(), csmTypedef.getName()) != 0) continue;
            this.currTypedef = csmTypedef;
        }
    }

    private void processTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        if (CharSequenceKey.Comparator.compare(csmNamespaceDefinition.getName(), this.currName()) == 0) {
            ++this.currNamIdx;
            this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
        } else {
            CsmNamespace csmNamespace = this.getContainingNamespace();
            if (csmNamespace != null && csmNamespace.equals(csmNamespaceDefinition.getNamespace())) {
                this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        }
    }

    private void gatherMaps(CsmScopeElement csmScopeElement, int n) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = csmScopeElement instanceof CsmDeclaration ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                this.usedNamespaces.add(csmNamespaceDefinition.getQualifiedName());
            }
            if (this.offset < n || this.isInContext((CsmScope)csmNamespaceDefinition)) {
                this.gatherMaps(csmNamespaceDefinition.getDeclarations());
            } else if (this.needClassifiers()) {
                this.processTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            this.namespaceAliases.put(csmNamespaceAlias.getAlias(), csmNamespaceAlias.getReferencedNamespace());
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmDeclaration csmDeclaration = this.resolveUsingDeclaration((CsmUsingDeclaration)csmScopeElement);
            if (csmDeclaration != null) {
                CharSequence charSequence = csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND ? ((CsmFunction)csmDeclaration).getSignature() : csmDeclaration.getName();
                this.usingDeclarations.put(charSequence, csmDeclaration);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            this.usedNamespaces.add(csmUsingDirective.getName());
        } else if (csmScopeElement instanceof CsmDeclarationStatement) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < this.offset) {
                this.gatherMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators());
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement)) {
            if (this.inLocalContext && this.needClassifiers() && CsmKindUtilities.isClassifier((CsmObject)csmScopeElement) && CharSequenceKey.Comparator.compare(this.currName(), ((CsmClassifier)csmScopeElement).getName()) == 0) {
                this.currLocalClassifier = (CsmClassifier)csmScopeElement;
            }
            if (this.offset < n || this.isInContext((CsmScope)csmScopeElement)) {
                this.gatherMaps(((CsmScope)csmScopeElement).getScopeElements());
            }
        } else if (kind == CsmDeclaration.Kind.TYPEDEF && this.needClassifiers()) {
            CsmTypedef csmTypedef = (CsmTypedef)csmScopeElement;
            if (CharSequenceKey.Comparator.compare(this.currName(), csmTypedef.getName()) == 0) {
                this.currTypedef = csmTypedef;
            }
        }
    }

    private boolean isInContext(CsmScope csmScope) {
        if (!CsmKindUtilities.isClass((CsmObject)csmScope) && !CsmKindUtilities.isNamespace((Object)csmScope)) {
            return false;
        }
        CsmQualifiedNamedElement csmQualifiedNamedElement = (CsmQualifiedNamedElement)csmScope;
        CsmNamespace csmNamespace = this.getContainingNamespace();
        if (csmNamespace != null && this.startsWith(csmNamespace.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName())) {
            return true;
        }
        CsmClass csmClass = this.getContainingClass();
        return csmClass != null && this.startsWith(csmClass.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName());
    }

    private boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() < charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return charSequence.length() == charSequence2.length() || charSequence.charAt(charSequence2.length()) == ':';
    }

    private CsmDeclaration resolveUsingDeclaration(CsmUsingDeclaration csmUsingDeclaration) {
        CsmDeclaration csmDeclaration = null;
        if (csmUsingDeclaration instanceof UsingDeclarationImpl) {
            if (this.isRecursionOnResolving(5)) {
                return null;
            }
            csmDeclaration = ((UsingDeclarationImpl)csmUsingDeclaration).getReferencedDeclaration(this);
        }
        return csmDeclaration;
    }

    @Override
    public CsmObject resolve(CharSequence charSequence, int n) {
        return this.resolve(Utils.splitQualifiedName(((Object)charSequence).toString()), n);
    }

    @Override
    public CsmObject resolve(CharSequence[] charSequenceArray, int n) {
        Object object = null;
        this.names = charSequenceArray;
        this.currNamIdx = 0;
        this.interestedKind = n;
        CsmNamespace csmNamespace = null;
        if (charSequenceArray.length == 1) {
            Object object2;
            if (object == null && this.needClassifiers() && (object = this.resolveInClass((CsmClass)(object2 = this.getContainingClass()), charSequenceArray[0])) == null && (this.parentResolver == null || !((Resolver3)this.parentResolver).resolveInBaseClass)) {
                object = this.resolveInBaseClasses((CsmClass)object2, charSequenceArray[0]);
            }
            if (object == null && this.needClassifiers() && (object = this.findClassifier(csmNamespace = this.getContainingNamespace(), charSequenceArray[0])) == null && csmNamespace != null) {
                object = this.resolveInUsings(csmNamespace, charSequenceArray[0]);
            }
            if (object == null && this.needNamespaces()) {
                csmNamespace = this.getContainingNamespace();
                object = this.findNamespace(csmNamespace, charSequenceArray[0]);
            }
            if (object == null && this.needClassifiers()) {
                object = this.findClassifier(charSequenceArray[0]);
            }
            if (object == null) {
                String string;
                String string2;
                this.currTypedef = null;
                this.currLocalClassifier = null;
                this.gatherMaps(this.file);
                if (this.currLocalClassifier != null && this.needClassifiers()) {
                    object = this.currLocalClassifier;
                }
                if (this.currTypedef != null && this.needClassifiers()) {
                    object = this.currTypedef;
                }
                if (object == null && (object2 = this.usingDeclarations.get(CharSequenceKey.create((CharSequence)charSequenceArray[0]))) != null) {
                    object = object2;
                }
                if (object == null && this.needClassifiers()) {
                    object2 = this.usedNamespaces.iterator();
                    while (object2.hasNext()) {
                        CsmNamespace csmNamespace2;
                        string2 = ((Object)((CharSequence)object2.next())).toString();
                        string = string2 + "::" + charSequenceArray[0];
                        object = this.findClassifier(string);
                        if (object == null) {
                            object = this.findClassifier(csmNamespace, string);
                        }
                        if (object == null && (csmNamespace2 = this.findNamespace(string2)) != null) {
                            object = this.resolveInUsings(csmNamespace2, charSequenceArray[0]);
                        }
                        if (object == null) continue;
                        break;
                    }
                }
                if (object == null && this.needNamespaces() && (object2 = this.namespaceAliases.get(CharSequenceKey.create((CharSequence)charSequenceArray[0]))) instanceof CsmNamespace) {
                    object = (CsmNamespace)object2;
                }
                if (object == null && this.needNamespaces()) {
                    object2 = this.usedNamespaces.iterator();
                    while (object2.hasNext() && (object = this.findNamespace(string = (string2 = ((Object)((CharSequence)object2.next())).toString()) + "::" + charSequenceArray[0])) == null) {
                    }
                }
            }
        } else if (charSequenceArray.length > 1) {
            CsmObject csmObject;
            Object object3;
            StringBuilder stringBuilder = new StringBuilder(charSequenceArray[0]);
            for (int i = 1; i < charSequenceArray.length; ++i) {
                stringBuilder.append("::");
                stringBuilder.append(charSequenceArray[i]);
            }
            if (this.needClassifiers()) {
                object = this.findClassifier(stringBuilder.toString());
            }
            if (object == null && this.needClassifiers()) {
                csmNamespace = this.getContainingNamespace();
                object = this.findClassifier(csmNamespace, stringBuilder.toString());
            }
            if (object == null && this.needNamespaces()) {
                csmNamespace = this.getContainingNamespace();
                object = this.findNamespace(csmNamespace, stringBuilder.toString());
            }
            if (object == null && this.needClassifiers()) {
                CsmObject csmObject2;
                String string;
                CsmType csmType;
                this.gatherMaps(this.file);
                if (this.currTypedef != null && (csmType = this.currTypedef.getType()) != null) {
                    object3 = this.getTypeClassifier(csmType);
                    while (this.currNamIdx < this.names.length - 1 && object3 != null) {
                        ++this.currNamIdx;
                        if (!CsmKindUtilities.isTypedef((CsmObject)(object3 = this.findNestedClassifier((CsmClassifier)object3)))) continue;
                        string = ((CsmTypedef)object3).getType();
                        object3 = string == null ? null : this.getTypeClassifier((CsmType)string);
                    }
                    if (this.currNamIdx == this.names.length - 1) {
                        object = object3;
                    }
                }
                if (object == null) {
                    Iterator<CharSequence> iterator = this.usedNamespaces.iterator();
                    while (iterator.hasNext() && (object = this.findClassifier(string = (String)(object3 = ((Object)iterator.next()).toString()) + "::" + stringBuilder)) == null) {
                    }
                }
                if (object == null && (csmObject2 = new Resolver3(this.file, this.origOffset, this).resolve(charSequenceArray[0], 1)) != null) {
                    if (csmObject2 instanceof CsmNamespace) {
                        int n2;
                        object3 = (NamespaceImpl)csmObject2;
                        stringBuilder = new StringBuilder(((NamespaceImpl)object3).getQualifiedName());
                        for (n2 = 1; n2 < charSequenceArray.length; ++n2) {
                            stringBuilder.append("::");
                            stringBuilder.append(charSequenceArray[n2]);
                        }
                        object = this.findClassifier(stringBuilder.toString());
                        if (object == null) {
                            stringBuilder = new StringBuilder(charSequenceArray[1]);
                            for (n2 = 2; n2 < charSequenceArray.length; ++n2) {
                                stringBuilder.append("::");
                                stringBuilder.append(charSequenceArray[n2]);
                            }
                            object = this.resolveInUsings((CsmNamespace)object3, stringBuilder.toString());
                        }
                    } else if (csmObject2 instanceof CsmClass) {
                        // empty if block
                    }
                }
            }
            if (object == null && this.needNamespaces() && (csmObject = new Resolver3(this.file, this.origOffset, this).resolve(charSequenceArray[0], 1)) instanceof CsmNamespace) {
                object3 = (CsmNamespace)csmObject;
                for (int i = 1; i < charSequenceArray.length; ++i) {
                    CsmNamespace csmNamespace3 = null;
                    CharSequence charSequence = charSequenceArray[i];
                    Collection collection = CsmUsingResolver.getDefault().findNamespaceAliases((CsmNamespace)object3);
                    for (Object object4 : collection) {
                        if (!((Object)object4.getAlias()).toString().equals(((Object)charSequence).toString())) continue;
                        csmNamespace3 = object4.getReferencedNamespace();
                        break;
                    }
                    if (csmNamespace3 == null) {
                        Object object4;
                        Collection collection2 = object3.getNestedNamespaces();
                        object4 = collection2.iterator();
                        while (object4.hasNext()) {
                            CsmNamespace csmNamespace4 = (CsmNamespace)object4.next();
                            if (!((Object)csmNamespace4.getName()).toString().equals(((Object)charSequence).toString())) continue;
                            csmNamespace3 = csmNamespace4;
                            break;
                        }
                    }
                    if ((object3 = csmNamespace3) == null) break;
                }
                object = object3;
            }
        }
        return object;
    }

    private CsmClassifier getTypeClassifier(CsmType csmType) {
        if (csmType instanceof Resolver.SafeClassifierProvider) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            return ((Resolver.SafeClassifierProvider)csmType).getClassifier(this);
        }
        return csmType.getClassifier();
    }

    private CsmObject resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence) {
        this.resolveInBaseClass = true;
        CsmObject csmObject = this._resolveInBaseClasses(csmClass, charSequence, new HashSet<CharSequence>(), 0);
        this.resolveInBaseClass = false;
        return csmObject;
    }

    private CsmObject _resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence, Set<CharSequence> set, int n) {
        if (n == 50) {
            new Exception("Too many loops in resolver!!!").printStackTrace(System.err);
            return null;
        }
        if (this.isNotNullNotUnresolved(csmClass)) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                for (CsmInheritance csmInheritance : csmClass2.getBaseClasses()) {
                    CsmClass csmClass3 = this.getInheritanceClass(csmInheritance);
                    if (csmClass3 == null || set.contains(csmClass3.getQualifiedName())) continue;
                    set.add(csmClass3.getQualifiedName());
                    CsmObject csmObject = this.resolveInClass(csmClass3, charSequence);
                    if (csmObject != null) {
                        return csmObject;
                    }
                    csmObject = this._resolveInBaseClasses(csmClass3, charSequence, set, n + 1);
                    if (csmObject == null) continue;
                    return csmObject;
                }
            }
        }
        return null;
    }

    private CsmClass getInheritanceClass(CsmInheritance csmInheritance) {
        if (csmInheritance instanceof InheritanceImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            CsmClassifier csmClassifier = ((InheritanceImpl)csmInheritance).getClassifier(this);
            if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
                return (CsmClass)csmClassifier;
            }
        }
        return this.getCsmClass(csmInheritance);
    }

    private CsmClass getCsmClass(CsmInheritance csmInheritance) {
        CsmClassifier csmClassifier = csmInheritance instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)csmInheritance).getClassifier(this) : csmInheritance.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
            return (CsmClass)csmClassifier;
        }
        return null;
    }

    private boolean isNotNullNotUnresolved(Object object) {
        return object != null && !Unresolved.isUnresolved(object);
    }

    private CsmObject resolveInClass(CsmClass csmClass, CharSequence charSequence) {
        if (this.isNotNullNotUnresolved(csmClass)) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                CsmClassifier csmClassifier = null;
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(charSequence, true, true, false);
                Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass2, (CsmSelect.CsmFilter)csmFilter);
                while (iterator.hasNext()) {
                    CsmMember csmMember = (CsmMember)iterator.next();
                    if (!CsmKindUtilities.isClassifier((CsmObject)csmMember) || CsmKindUtilities.isClassForwardDeclaration((CsmObject)(csmClassifier = (CsmClassifier)csmMember))) continue;
                    return csmClassifier;
                }
                if (csmClassifier == null) continue;
                return csmClassifier;
            }
        }
        return null;
    }

    private List<CsmClass> getClassesContainers(CsmClass csmClass) {
        ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>();
        CsmClass csmClass2 = csmClass;
        while (CsmKindUtilities.isClass((CsmObject)csmClass2)) {
            arrayList.add(csmClass2);
            csmClass2 = csmClass2.getScope();
        }
        return arrayList;
    }

    private boolean needClassifiers() {
        return (this.interestedKind & 2) == 2 || this.needClasses();
    }

    private boolean needNamespaces() {
        return (this.interestedKind & 1) == 1;
    }

    private boolean needClasses() {
        return (this.interestedKind & 4) == 4;
    }
}

