/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

public final class Unresolved
implements Disposable {
    private static final CharSequence UNRESOLVED = CharSequenceKey.create((CharSequence)"$unresolved file$");
    private static final String UNRESOLVED_FILE_FAKE_PATH = new File(System.getProperty("java.io.tmpdir"), "$_UNRESOLVED_CND_MODEL_FILE_5858$").getAbsolutePath();
    private ProjectBase projectRef;
    private final CsmUID<CsmProject> projectUID;
    private final UnresolvedFile unresolvedFile;
    private final UnresolvedNamespace unresolvedNamespace;
    private final Map<CharSequence, Reference<UnresolvedClass>> dummiesForUnresolved = new HashMap<CharSequence, Reference<UnresolvedClass>>();

    public static final boolean isUnresolved(Object object) {
        return object instanceof UnresolvedClass || object instanceof UnresolvedFile || object instanceof UnresolvedNamespace;
    }

    public Unresolved(ProjectBase projectBase) {
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        this.projectRef = null;
        this.unresolvedFile = new UnresolvedFile();
        this.unresolvedNamespace = new UnresolvedNamespace(projectBase);
    }

    public void dispose() {
        this.disposeAll();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.projectRef == null) {
            this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
            assert (this.projectRef != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
        }
    }

    private void disposeAll() {
        this.unresolvedFile.dispose();
    }

    public CsmClass getDummyForUnresolved(CharSequence[] charSequenceArray) {
        return this.getDummyForUnresolved(this.getName(charSequenceArray));
    }

    public CsmClass getDummyForUnresolved(CharSequence charSequence) {
        UnresolvedClass unresolvedClass;
        charSequence = NameCache.getManager().getString(charSequence);
        Reference<UnresolvedClass> reference = this.dummiesForUnresolved.get(charSequence);
        UnresolvedClass unresolvedClass2 = unresolvedClass = reference == null ? null : reference.get();
        if (unresolvedClass == null) {
            unresolvedClass = new UnresolvedClass(((Object)charSequence).toString());
            this.dummiesForUnresolved.put(charSequence, new SoftReference<UnresolvedClass>(unresolvedClass));
            unresolvedClass.register();
        }
        return unresolvedClass;
    }

    public CsmNamespace getUnresolvedNamespace() {
        return this.unresolvedNamespace;
    }

    public CsmFile getUnresolvedFile() {
        return this.unresolvedFile;
    }

    private String getName(CharSequence[] charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequenceArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append("::");
            }
            stringBuilder.append(charSequenceArray[i]);
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class UnresolvedFile
    implements CsmFile,
    CsmIdentifiable,
    Disposable {
        private CsmUID<CsmFile> uid = null;

        private UnresolvedFile() {
        }

        public String getText(int n, int n2) {
            return "";
        }

        public String getText() {
            return "";
        }

        public List<CsmScopeElement> getScopeElements() {
            return Collections.emptyList();
        }

        public CsmProject getProject() {
            return this._getProject();
        }

        private synchronized CsmProject _getProject() {
            if (Unresolved.this.projectRef == null) {
                assert (Unresolved.this.projectUID != null);
                return (ProjectBase)UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)Unresolved.this.projectUID);
            }
            return Unresolved.this.projectRef;
        }

        public CharSequence getName() {
            return UNRESOLVED;
        }

        public List<CsmInclude> getIncludes() {
            return Collections.emptyList();
        }

        public List<CsmOffsetableDeclaration> getDeclarations() {
            return Collections.emptyList();
        }

        public String getAbsolutePath() {
            return UNRESOLVED_FILE_FAKE_PATH;
        }

        public boolean isValid() {
            return this.getProject().isValid();
        }

        public void scheduleParsing(boolean bl) {
        }

        public boolean isParsed() {
            return true;
        }

        public List<CsmMacro> getMacros() {
            return Collections.emptyList();
        }

        public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter csmFilter) {
            return this.getMacros().iterator();
        }

        public CsmUID<CsmFile> getUID() {
            if (this.uid == null) {
                this.uid = UIDUtilities.createUnresolvedFileUID(this.getProject());
            }
            return this.uid;
        }

        public boolean isSourceFile() {
            return false;
        }

        public boolean isHeaderFile() {
            return true;
        }

        public Collection<CsmErrorDirective> getErrors() {
            return Collections.emptyList();
        }

        @Override
        public void dispose() {
            UIDUtilities.disposeUnresolved(this.uid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnresolvedNamespace
    extends NamespaceImpl {
        private UnresolvedNamespace(ProjectBase projectBase) {
            super(projectBase, null, "$unresolved$", "$unresolved$");
        }

        @Override
        protected void notify(CsmObject csmObject, NamespaceImpl.NotifyEvent notifyEvent) {
        }

        @Override
        protected CsmUID<CsmNamespace> createUID() {
            return UIDUtilities.createUnresolvedNamespaceUID(this.getProject());
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            throw new IllegalCallException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class UnresolvedClass
    extends ClassEnumBase<CsmClass>
    implements CsmClass {
        public UnresolvedClass(String string) {
            super(string, Unresolved.this.unresolvedFile, null);
            this.initScope((CsmScope)Unresolved.this.unresolvedNamespace, null);
            this.initQualifiedName((CsmScope)Unresolved.this.unresolvedNamespace, null);
        }

        public void register() {
            if (Unresolved.this.unresolvedNamespace != null) {
                Unresolved.this.unresolvedNamespace.addDeclaration(this);
            }
        }

        public boolean isTemplate() {
            return false;
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return Collections.emptyList();
        }

        public Collection<CsmMember> getMembers() {
            return Collections.emptyList();
        }

        public List<CsmFriend> getFriends() {
            return Collections.emptyList();
        }

        public int getLeftBracketOffset() {
            return 0;
        }

        public List<CsmInheritance> getBaseClasses() {
            return Collections.emptyList();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.CLASS;
        }

        @Override
        protected CsmUID<CsmClass> createUID() {
            return UIDUtilities.createUnresolvedClassUID(((Object)this.getName()).toString(), this.getProject());
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            throw new IllegalCallException();
        }
    }

    private static class IllegalCallException
    extends RuntimeException {
        IllegalCallException() {
            super("This method should never be called for Unresolved");
        }
    }
}

