/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmObjectFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;

class NamespaceKey
extends ProjectNameBasedKey {
    private final CharSequence fqn;
    private final int hashCode;

    public NamespaceKey(CsmNamespace csmNamespace) {
        super(NamespaceKey.getProjectName(csmNamespace));
        this.fqn = csmNamespace.getQualifiedName();
        this.hashCode = this._hashCode();
    }

    private static String getProjectName(CsmNamespace csmNamespace) {
        ProjectBase projectBase = (ProjectBase)csmNamespace.getProject();
        assert (projectBase != null) : "no project in namespace";
        return projectBase == null ? "<No Project Name>" : ((Object)projectBase.getUniqueName()).toString();
    }

    public String toString() {
        return "NSKey " + this.fqn + " of project " + this.getProjectName();
    }

    public PersistentFactory getPersistentFactory() {
        return CsmObjectFactory.instance();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int _hashCode() {
        int n = super.hashCode();
        n = 74 + n;
        n = 17 * n + this.fqn.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        NamespaceKey namespaceKey = (NamespaceKey)object;
        return this.fqn.equals(namespaceKey.fqn);
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.fqn != null);
        PersistentUtils.writeUTF(this.fqn, dataOutput);
    }

    NamespaceKey(DataInput dataInput) throws IOException {
        super(dataInput);
        this.fqn = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.fqn != null);
        this.hashCode = this._hashCode();
    }

    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    public CharSequence getAt(int n) {
        assert (super.getDepth() == 0 && n < this.getDepth());
        return this.fqn;
    }

    public int getSecondaryDepth() {
        return 1;
    }

    public int getSecondaryAt(int n) {
        assert (n == 0);
        return 2;
    }

    public Key.Behavior getBehavior() {
        return Key.Behavior.LargeAndMutable;
    }

    public boolean hasCache() {
        return true;
    }
}

