/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryListenerImpl;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.utils.CndUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryUtils {
    private static final boolean TRACE_ARGS = CndUtils.getBoolean((String)"cnd.repository.trace.args", (boolean)false);
    private static final boolean TRACE_REPOSITORY_ACCESS = TRACE_ARGS || DebugUtils.getBoolean((String)"cnd.modelimpl.trace.repository", (boolean)false);
    private static final Repository repository = RepositoryAccessor.getRepository();
    private static int CURRENT_VERSION_OF_PERSISTENCY = 77;
    private static volatile int counter = 0;
    private static RepositoryListenerProxy myRepositoryListenerProxy;

    private RepositoryUtils() {
    }

    public static <T> T get(CsmUID<T> csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        Persistent persistent = RepositoryUtils.get(key);
        assert (persistent == null || persistent instanceof CsmIdentifiable) : "unexpected object with class " + persistent.getClass() + persistent;
        Persistent persistent2 = persistent;
        return (T)persistent2;
    }

    public static Persistent tryGet(Key key) {
        assert (key != null);
        Persistent persistent = repository.tryGet(key);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            System.err.printf("%d:trying key %s got %s", RepositoryUtils.nextIndex(), key, persistent);
        }
        return persistent;
    }

    public static Persistent get(Key key) {
        assert (key != null);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            long l = System.currentTimeMillis();
            int n = RepositoryUtils.nextIndex();
            System.err.println(n + ": " + System.identityHashCode(key) + "@getting key " + key);
            Persistent persistent = repository.get(key);
            l = System.currentTimeMillis() - l;
            System.err.println(n + ": " + System.identityHashCode(key) + "@got" + (persistent == null ? " - NULL" : "") + " in " + l + "ms the key " + key);
            return persistent;
        }
        return repository.get(key);
    }

    private static synchronized int nextIndex() {
        return counter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void remove(CsmUID csmUID, CsmObject csmObject) {
        block6: {
            block5: {
                Key key = RepositoryUtils.UIDtoKey(csmUID);
                if (key == null) return;
                try {
                    if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                        long l = System.currentTimeMillis();
                        int n = RepositoryUtils.nextIndex();
                        System.err.println(n + ": " + System.identityHashCode(key) + "@removing key " + key);
                        if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                            repository.remove(key);
                        }
                        l = System.currentTimeMillis() - l;
                        System.err.println(n + ": " + System.identityHashCode(key) + "@removed in " + l + "ms the key " + key);
                        Object var7_5 = null;
                        break block5;
                    }
                    if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                        repository.remove(key);
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    RepositoryUtils.disposeUID(csmUID, csmObject);
                    throw throwable;
                }
            }
            RepositoryUtils.disposeUID(csmUID, csmObject);
            return;
        }
        Object var7_6 = null;
        RepositoryUtils.disposeUID(csmUID, csmObject);
    }

    public static void disposeUID(CsmUID csmUID, CsmObject csmObject) {
        if (csmUID instanceof KeyBasedUID) {
            ((KeyBasedUID)csmUID).dispose(csmObject);
        }
    }

    public static void remove(Collection<? extends CsmUID> collection) {
        if (collection != null) {
            for (CsmUID csmUID : collection) {
                RepositoryUtils.remove(csmUID, null);
            }
        }
    }

    public static <T> CsmUID<T> put(T t) {
        CsmUID<T> csmUID = null;
        if (t != null) {
            csmUID = UIDProviderIml.get(t, false);
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.put(key, (Persistent)t);
            if (!(t instanceof CsmNamespace) && !(t instanceof CsmProject)) assert (csmUID.getObject() != null);
        }
        return csmUID;
    }

    public static void put(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ": " + System.identityHashCode(key) + "@putting key " + key);
                repository.put(key, persistent);
                l = System.currentTimeMillis() - l;
                System.err.println(n + ": " + System.identityHashCode(key) + "@put in " + l + "ms the key " + key);
                return;
            }
            repository.put(key, persistent);
        }
    }

    public static void hang(Object object) {
        CsmUID<Object> csmUID = null;
        if (object != null) {
            csmUID = UIDProviderIml.get(object, false);
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.hang(key, (Persistent)object);
            if (!(object instanceof CsmNamespace) && !(object instanceof CsmProject)) assert (csmUID.getObject() != null);
        }
    }

    public static void hang(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ": " + System.identityHashCode(key) + "@hanging key " + key);
                repository.hang(key, persistent);
                l = System.currentTimeMillis() - l;
                System.err.println(n + ": " + System.identityHashCode(key) + "@hung in " + l + "ms the key " + key);
                return;
            }
            repository.hang(key, persistent);
        }
    }

    public static <T> Collection<CsmUID<T>> put(Collection<T> collection) {
        assert (collection != null);
        ArrayList<CsmUID<T>> arrayList = new ArrayList<CsmUID<T>>(collection.size());
        for (T t : collection) {
            if (!(t instanceof CsmIdentifiable)) continue;
            CsmUID<T> csmUID = RepositoryUtils.put(t);
            arrayList.add(csmUID);
        }
        return arrayList;
    }

    public static <T extends CsmObject> void setSelfUIDs(Collection<T> collection) {
        assert (collection != null);
        for (CsmObject csmObject : collection) {
            Utils.setSelfUID(csmObject);
        }
    }

    public static Key UIDtoKey(CsmUID csmUID) {
        if (csmUID instanceof KeyHolder) {
            return ((KeyHolder)csmUID).getKey();
        }
        return null;
    }

    public static CharSequence getUnitName(CsmUID csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        assert (key != null);
        CharSequence charSequence = key.getUnit();
        return charSequence;
    }

    public static void startup() {
        repository.startup(CURRENT_VERSION_OF_PERSISTENCY);
        repository.unregisterRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
        repository.registerRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
    }

    private static synchronized RepositoryListenerProxy getRepositoryListenerProxy() {
        if (myRepositoryListenerProxy == null) {
            myRepositoryListenerProxy = new RepositoryListenerProxy();
        }
        return myRepositoryListenerProxy;
    }

    public static void shutdown() {
        repository.shutdown();
    }

    public static void cleanCashes() {
        repository.cleanCaches();
    }

    public static void debugClear() {
        repository.debugClear();
    }

    public static void closeUnit(CsmUID csmUID, Set<String> set, boolean bl) {
        RepositoryUtils.closeUnit(RepositoryUtils.UIDtoKey(csmUID), set, bl);
    }

    public static void closeUnit(String string, Set<String> set, boolean bl) {
        RepositoryListenerImpl.instance().onExplicitClose(string);
        RepositoryUtils._closeUnit(string, set, bl);
    }

    public static void closeUnit(Key key, Set<String> set, boolean bl) {
        assert (key != null);
        RepositoryUtils._closeUnit(((Object)key.getUnit()).toString(), set, bl);
    }

    private static void _closeUnit(String string, Set<String> set, boolean bl) {
        int n;
        assert (string != null);
        if (!bl && (n = myRepositoryListenerProxy.getErrorCount(string)) > 0) {
            System.err.println("Clean index for project \"" + string + "\" because index was corrupted (was " + n + " errors).");
            bl = true;
        }
        myRepositoryListenerProxy.cleanErrorCount(string);
        repository.closeUnit(string, bl, set);
    }

    public static int getRepositoryErrorCount(ProjectBase projectBase) {
        return RepositoryUtils.getRepositoryListenerProxy().getErrorCount(((Object)projectBase.getUniqueName()).toString());
    }

    public static void onProjectDeleted(NativeProject nativeProject) {
        Key key = KeyUtilities.createProjectKey(nativeProject);
        repository.removeUnit(((Object)key.getUnit()).toString());
    }

    public static void openUnit(ProjectBase projectBase) {
        CsmUID<CsmProject> csmUID = projectBase.getUID();
        assert (csmUID != null);
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        RepositoryUtils.openUnit(key);
    }

    public static void openUnit(Key key) {
        RepositoryUtils.openUnit(key.getUnitId(), ((Object)key.getUnit()).toString());
    }

    private static void openUnit(int n, String string) {
        RepositoryListenerImpl.instance().onExplicitOpen(string);
        repository.openUnit(n, string);
    }

    public static void unregisterRepositoryListener(RepositoryListener repositoryListener) {
        repository.unregisterRepositoryListener(repositoryListener);
    }

    static int getUnitId(String string) {
        return RepositoryAccessor.getTranslator().getUnitId(string);
    }

    static String getUnitName(int n) {
        return RepositoryAccessor.getTranslator().getUnitName(n);
    }

    static int getFileIdByName(int n, String string) {
        return RepositoryAccessor.getTranslator().getFileIdByName(n, string);
    }

    static String getFileNameByIdSafe(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameByIdSafe(n, n2);
    }

    static String getFileNameById(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameById(n, n2);
    }

    private static boolean isTracingKey(Key key) {
        if (TRACE_ARGS) {
            return key.getDepth() == 3 && ("argc".contentEquals(key.getAt(2)) || "main".contentEquals(key.getAt(2)));
        }
        return true;
    }

    private static class RepositoryListenerProxy
    implements RepositoryListener {
        private RepositoryListener parent = RepositoryListenerImpl.instance();
        private Map<String, Integer> wasErrors = new ConcurrentHashMap<String, Integer>();

        private RepositoryListenerProxy() {
        }

        public int getErrorCount(String string) {
            Integer n = this.wasErrors.get(string);
            if (n == null) {
                return 0;
            }
            return n;
        }

        public void cleanErrorCount(String string) {
            this.wasErrors.remove(string);
        }

        public boolean unitOpened(String string) {
            return this.parent.unitOpened(string);
        }

        public void unitClosed(String string) {
            this.parent.unitClosed(string);
        }

        public void anExceptionHappened(String string, RepositoryException repositoryException) {
            this.primitiveErrorStrategy(string, repositoryException);
            this.parent.anExceptionHappened(string, repositoryException);
        }

        private void primitiveErrorStrategy(String string, RepositoryException repositoryException) {
            Integer n = this.wasErrors.get(string);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            this.wasErrors.put(string, n);
        }
    }
}

