/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.Constants;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.ModuleMBean;

public class JvmOptions
extends ModuleMBean
implements Constants {
    private ObjectName configObjName = null;
    private boolean isServerEightOne = true;

    public JvmOptions(MBeanServerConnection mBeanServerConnection) {
        super(mBeanServerConnection);
        this.runtimeObjName = this.configObjName = this.createConfigObjectName();
    }

    public JvmOptions(ObjectName objectName, MBeanServerConnection mBeanServerConnection) {
        super(objectName, mBeanServerConnection);
        this.configObjName = this.createConfigObjectName();
    }

    public JvmOptions(ObjectName objectName, MBeanServerConnection mBeanServerConnection, boolean bl) {
        super(objectName, mBeanServerConnection);
        this.configObjName = this.createConfigObjectName();
        this.isServerEightOne = bl;
    }

    private ObjectName createConfigObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("com.sun.appserv:type=java-config,config=server-config,category=config");
        }
        catch (Exception exception) {
            return null;
        }
        return objectName;
    }

    public ObjectName getConfigObjectName() {
        return this.configObjName;
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = null;
        try {
            String string = this.getAddressValue();
            Attribute attribute = null;
            if (this.isSharedMemory()) {
                if (this.isWindows()) {
                    attribute = new Attribute("shared_memory", string);
                } else {
                    Attribute attribute2 = new Attribute("debug-options", "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=11000");
                    this.setAttribute(attribute2);
                    Integer n = new Integer(11000);
                    attribute = new Attribute("jpda_port_number", n);
                }
            } else {
                Integer n = new Integer(string);
                attribute = new Attribute("jpda_port_number", n);
            }
            attributeList = this.conn.getAttributes(this.configObjName, stringArray);
            attributeList.add(attribute);
        }
        catch (Exception exception) {
            return attributeList;
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mBeanInfo = null;
        try {
            MBeanInfo mBeanInfo2 = this.conn.getMBeanInfo(this.configObjName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo2.getAttributes();
            int n = mBeanAttributeInfoArray.length + 1;
            MBeanAttributeInfo[] mBeanAttributeInfoArray2 = new MBeanAttributeInfo[n];
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                mBeanAttributeInfoArray2[i] = mBeanAttributeInfoArray[i];
            }
            mBeanAttributeInfoArray2[n - 1] = this.isSharedMemory() && this.isWindows() ? new MBeanAttributeInfo("shared_memory", "java.lang.String", "Shared Memory", true, true, false) : new MBeanAttributeInfo("jpda_port_number", "int", "JPDA port number", true, true, false);
            mBeanInfo = new MBeanInfo(mBeanInfo2.getClassName(), mBeanInfo2.getDescription(), mBeanAttributeInfoArray2, mBeanInfo2.getConstructors(), mBeanInfo2.getOperations(), mBeanInfo2.getNotifications());
        }
        catch (Exception exception) {
            return mBeanInfo;
        }
        return mBeanInfo;
    }

    public void setAttribute(Attribute attribute) throws RemoteException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (attribute.getName().equals("jpda_port_number")) {
            if (attribute.getValue() != null) {
                this.setAddressValue(attribute.getValue().toString());
            }
        } else if (attribute.getName().equals("shared_memory")) {
            if (attribute.getValue() != null) {
                this.setAddressValue(attribute.getValue().toString());
            }
        } else if (attribute.getName().equals("debug-options")) {
            if (attribute.getValue() != null && attribute.getValue().toString().indexOf("transport=dt_shmem") == -1) {
                this.conn.setAttribute(this.configObjName, attribute);
            } else if (this.isWindows()) {
                this.conn.setAttribute(this.configObjName, attribute);
            }
        } else {
            this.conn.setAttribute(this.configObjName, attribute);
        }
    }

    private String getDebugOptions() {
        String string = this.getConfigAttributeValue("debug-options");
        String string2 = null;
        if (string != null) {
            string2 = string.toString().trim();
        }
        return string2;
    }

    public String getAddressValue() {
        int n;
        String string = this.getDebugOptions();
        if (string != null && (n = (string = string.substring(string.indexOf("address=") + "address=".length(), string.length())).indexOf(",")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void setAddressValue(String string) {
        try {
            Object object;
            String string2 = this.getDebugOptions();
            String string3 = string2.substring(0, string2.indexOf("address=") + "address=".length());
            string3 = string3 + string;
            String string4 = string2.substring(string2.indexOf("address=") + "address=".length(), string2.length());
            int n = string4.indexOf(",");
            if (n != -1) {
                object = string4.substring(n, string4.length());
                string3 = string3 + (String)object;
            }
            object = new Attribute("debug-options", string3);
            this.setAttribute((Attribute)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getClassPath() {
        String string = this.getConfigAttributeValue("server_classpath");
        return string;
    }

    public void setClassPath(String string) {
        try {
            Attribute attribute = new Attribute("server_classpath", string);
            this.setAttribute(attribute);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getConfigAttributeValue(String string) {
        return super.getAttribute(this.configObjName, string);
    }

    public boolean isSharedMemory() {
        boolean bl;
        block10: {
            bl = false;
            String string = this.getDebugOptions();
            if (string.indexOf("transport=dt_shmem") == -1 && string.indexOf("transport=dt_socket") == -1) {
                try {
                    Attribute attribute = null;
                    attribute = this.isServerEightOne ? new Attribute("debug-options", "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=9009") : new Attribute("debug-options", "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=1044");
                    this.setAttribute(attribute);
                }
                catch (Exception exception) {}
            } else if (string.indexOf("transport=dt_socket") != -1) {
                String string2 = this.getAddressValue();
                Integer n = null;
                try {
                    n = new Integer(string2);
                }
                catch (Exception exception) {
                    if (this.isServerEightOne) {
                        n = new Integer(9009);
                        this.setAddressValue("9009");
                        break block10;
                    }
                    n = new Integer(1044);
                    this.setAddressValue("1044");
                }
            } else if (string.indexOf("transport=dt_shmem") != -1) {
                return true;
            }
        }
        return bl;
    }

    public boolean isWindows() {
        String string = this.getConfigAttributeValue("java-home");
        if (string == null) {
            return false;
        }
        try {
            String string2 = System.getProperty("os.name");
            return string2.toLowerCase(Locale.ENGLISH).indexOf("windows") != -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public void setDefaultTransportForDebug(String string) {
        Attribute attribute = null;
        if (this.isWindows()) {
            String string2 = "-Xdebug -Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=";
            string2 = string != null ? string2 + string : string2 + "defaultAddress";
            attribute = new Attribute("debug-options", string2);
        } else if (this.getAddressValue().equals("1044") || this.getAddressValue().equals("9009")) {
            attribute = new Attribute("debug-options", "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=11000");
        }
        try {
            if (attribute != null) {
                this.setAttribute(attribute);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

