/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader;

import java.io.InputStream;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.xml.cookies.CheckXMLCookie;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataLoader;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataNode;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunResourceDataObject
extends XMLDataObject
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(SunResourceDataObject.class.getName());
    private static String JDBC_CP = "jdbc-connection-pool";
    private static String JDBC_DS = "jdbc-resource";
    private static String PMF = "persistence-manager-factory-resource";
    private static String MAIL = "mail-resource";
    private static String JMS = "jms-resource";
    private transient ValidateXMLCookie validateCookie = null;
    private transient CheckXMLCookie checkCookie = null;
    ConnPoolBean cpBean = null;
    DataSourceBean dsBean = null;
    PersistenceManagerBean pmfBean = null;
    JavaMailSessionBean mailBean = null;
    JMSBean jmsBean = null;
    String resType;

    public SunResourceDataObject(FileObject fileObject, SunResourceDataLoader sunResourceDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)sunResourceDataLoader);
        fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject));
        this.resType = this.getResource(fileObject);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Node.Cookie cookie = null;
        if (ValidateXMLCookie.class.isAssignableFrom(clazz)) {
            if (this.validateCookie == null) {
                InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                this.validateCookie = new ValidateXMLSupport(inputSource);
            }
            return (T)this.validateCookie;
        }
        if (CheckXMLCookie.class.isAssignableFrom(clazz)) {
            if (this.checkCookie == null) {
                InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                this.checkCookie = new CheckXMLSupport(inputSource);
            }
            return (T)this.checkCookie;
        }
        if (cookie == null) {
            cookie = super.getCookie(clazz);
        }
        return (T)cookie;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected Node createNodeDelegate() {
        if (this.resType != null) {
            if (this.resType.equals(JDBC_CP)) {
                ConnPoolBeanDataNode connPoolBeanDataNode = new ConnPoolBeanDataNode(this, this.getPool());
                return connPoolBeanDataNode;
            }
            if (this.resType.equals(JDBC_DS)) {
                DataSourceBeanDataNode dataSourceBeanDataNode = new DataSourceBeanDataNode(this, this.getDataSource());
                return dataSourceBeanDataNode;
            }
            if (this.resType.equals(PMF)) {
                PersistenceManagerBeanDataNode persistenceManagerBeanDataNode = new PersistenceManagerBeanDataNode(this, this.getPersistenceManager());
                return persistenceManagerBeanDataNode;
            }
            if (this.resType.equals(MAIL)) {
                JavaMailSessionBeanDataNode javaMailSessionBeanDataNode = new JavaMailSessionBeanDataNode(this, this.getMailSession());
                return javaMailSessionBeanDataNode;
            }
            if (this.resType.equals(JMS)) {
                JMSBeanDataNode jMSBeanDataNode = new JMSBeanDataNode(this, this.getJMS());
                return jMSBeanDataNode;
            }
            String string = NbBundle.getMessage(SunResourceDataObject.class, (String)"Info_notSunResource");
            LOG.log(Level.INFO, string);
            return new SunResourceDataNode(this);
        }
        return new SunResourceDataNode(this);
    }

    private String getResource(FileObject fileObject) {
        String string = null;
        try {
            if (!fileObject.isFolder() && fileObject.isValid()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                InputStream inputStream = fileObject.getInputStream();
                Resources resources = DDProvider.getDefault().getResourcesGraph(inputStream);
                JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
                if (jdbcConnectionPoolArray.length != 0) {
                    object6 = ConnPoolBean.createBean(jdbcConnectionPoolArray[0]);
                    string = JDBC_CP;
                    this.setPool((ConnPoolBean)object6);
                }
                if (((JdbcResource[])(object6 = resources.getJdbcResource())).length != 0) {
                    object5 = DataSourceBean.createBean(object6[0]);
                    string = JDBC_DS;
                    this.setDataSource((DataSourceBean)object5);
                }
                if (((PersistenceManagerFactoryResource[])(object5 = resources.getPersistenceManagerFactoryResource())).length != 0) {
                    object4 = PersistenceManagerBean.createBean(object5[0]);
                    string = PMF;
                    this.setPersistenceManager((PersistenceManagerBean)object4);
                }
                if (((MailResource[])(object4 = resources.getMailResource())).length != 0) {
                    object3 = JavaMailSessionBean.createBean(object4[0]);
                    string = MAIL;
                    this.setMailSession((JavaMailSessionBean)object3);
                }
                if (((JmsResource[])(object3 = resources.getJmsResource())).length != 0) {
                    object2 = JMSBean.createBean(object3[0]);
                    string = JMS;
                    this.setJMS((JMSBean)object2);
                }
                if (((AdminObjectResource[])(object2 = resources.getAdminObjectResource())).length != 0) {
                    object = JMSBean.createBean(object2[0]);
                    string = JMS;
                    this.setJMS((JMSBean)object);
                }
                object = resources.getConnectorResource();
                ConnectorConnectionPool[] connectorConnectionPoolArray = resources.getConnectorConnectionPool();
                if (((ConnectorResource[])object).length != 0 && connectorConnectionPoolArray.length != 0) {
                    JMSBean jMSBean = JMSBean.createBean(resources);
                    string = JMS;
                    this.setJMS(jMSBean);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            LOG.log(Level.SEVERE, "Unable to load *.sun-resource file", nullPointerException);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Unable to load *.sun-resource file", exception);
        }
        return string;
    }

    private void setPool(ConnPoolBean connPoolBean) {
        this.cpBean = connPoolBean;
    }

    private ConnPoolBean getPool() {
        return this.cpBean;
    }

    private void setDataSource(DataSourceBean dataSourceBean) {
        this.dsBean = dataSourceBean;
    }

    private DataSourceBean getDataSource() {
        return this.dsBean;
    }

    private void setPersistenceManager(PersistenceManagerBean persistenceManagerBean) {
        this.pmfBean = persistenceManagerBean;
    }

    private PersistenceManagerBean getPersistenceManager() {
        return this.pmfBean;
    }

    private void setMailSession(JavaMailSessionBean javaMailSessionBean) {
        this.mailBean = javaMailSessionBean;
    }

    private JavaMailSessionBean getMailSession() {
        return this.mailBean;
    }

    private void setJMS(JMSBean jMSBean) {
        this.jmsBean = jMSBean;
    }

    private JMSBean getJMS() {
        return this.jmsBean;
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.updateDataObject();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.updateDataObject();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.updateDataObject();
    }

    private void updateDataObject() {
        this.resType = this.getResource(this.getPrimaryFile());
    }

    public String getResourceType() {
        return this.resType;
    }
}

