/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.api.SamplingData;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.DataReader;
import org.netbeans.modules.dlight.procfs.reader.impl.MSAInfoImpl;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessUsageProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ReusableByteBuffer;
import org.netbeans.modules.dlight.procfs.reader.impl.ThreadsInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcReaderImpl
implements ProcReader,
ProcessStatusProvider,
ProcessUsageProvider,
ThreadsInfoProvider {
    private static final int MAXFILELENGTH = 512;
    private final HashMap<Integer, MSAInfoImpl> prevMSAData = new HashMap();
    private final HashMap<Integer, Long> prevTSData = new HashMap();
    private final ReusableByteBuffer buffer = new ReusableByteBuffer(512, 10);
    protected final ByteOrder byteOrder;
    protected final DataModel dataModel;

    public ProcReaderImpl(ByteOrder byteOrder, DataModel dataModel) {
        this.byteOrder = byteOrder;
        this.dataModel = dataModel;
    }

    @Override
    public abstract PStatus getProcessStatus();

    @Override
    public abstract PUsage getProcessUsage() throws IOException;

    @Override
    public abstract List<LWPUsage> getThreadsInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PStatus getProcessStatus(InputStream inputStream) throws IOException {
        DataReader dataReader = null;
        try {
            dataReader = this.newReader(inputStream);
            dataReader.seek(4);
            int n = dataReader._int();
            dataReader.seek(8);
            int n2 = dataReader._int();
            dataReader.seek(268);
            int n3 = dataReader._int();
            final PStatus.ThreadsInfo threadsInfo = new PStatus.ThreadsInfo(n, n3){};
            final PStatus.PIDInfo pIDInfo = new PStatus.PIDInfo(n2){};
            PStatus pStatus = new PStatus(){

                public PStatus.ThreadsInfo getThreadInfo() {
                    return threadsInfo;
                }

                public PStatus.PIDInfo getPIDInfo() {
                    return pIDInfo;
                }
            };
            return pStatus;
        }
        finally {
            if (dataReader != null) {
                dataReader.releaseBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LWPUsage getProcessUsage(InputStream inputStream) throws IOException {
        DataReader dataReader = null;
        try {
            dataReader = this.newReader(inputStream, 256);
            dataReader.seek(0);
            int n = dataReader._int();
            int n2 = dataReader._int();
            long l = dataReader._time();
            long l2 = dataReader._time();
            long l3 = dataReader._time();
            long l4 = dataReader._time();
            final PUsage.UsageInfo usageInfo = new PUsage.UsageInfo(n, n2, l, l2, l3, l4){};
            MSAInfoImpl mSAInfoImpl = this.prevMSAData.containsKey(n) ? this.prevMSAData.get(n) : MSAInfoImpl.nullInfo;
            long l5 = this.prevTSData.containsKey(n) ? this.prevTSData.get(n) : l2;
            long l6 = l - l5;
            this.prevTSData.put(n, l);
            final SamplingData samplingData = new SamplingData(l5, l6);
            long l7 = dataReader._time();
            long l8 = dataReader._time();
            long l9 = dataReader._time();
            long l10 = dataReader._time();
            long l11 = dataReader._time();
            long l12 = dataReader._time();
            long l13 = dataReader._time();
            long l14 = dataReader._time();
            long l15 = dataReader._time();
            long l16 = dataReader._time();
            final MSAInfoImpl mSAInfoImpl2 = new MSAInfoImpl(mSAInfoImpl, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16);
            this.prevMSAData.put(n, mSAInfoImpl2);
            LWPUsage lWPUsage = new LWPUsage(){

                public SamplingData getSamplingData() {
                    return samplingData;
                }

                public PUsage.UsageInfo getUsageInfo() {
                    return usageInfo;
                }

                public PUsage.MSAInfo getMSAInfo() {
                    return mSAInfoImpl2;
                }
            };
            return lWPUsage;
        }
        finally {
            if (dataReader != null) {
                dataReader.releaseBuffer();
            }
        }
    }

    protected List<LWPUsage> getThreadsInfo(InputStream inputStream) throws IOException {
        return null;
    }

    private DataReader newReader(InputStream inputStream) throws IOException {
        return this.newReader(inputStream, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataReader newReader(InputStream inputStream, int n) throws IOException {
        n = Math.min(n, 512);
        int n2 = 0;
        try {
            n2 = this.buffer.getAndLockOffset();
            int n3 = 0;
            for (int i = 0; n3 >= 0 && i < n; i += n3) {
                n3 = inputStream.read(this.buffer.buffer, n2 + i, n - i);
            }
        }
        finally {
            inputStream.close();
        }
        return new DataReader(this.buffer, n2, this.byteOrder);
    }
}

