/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProcReader
extends ProcReaderImpl {
    private static final Logger log = DLightLogger.getLogger(RemoteProcReader.class);
    private final String usageFile;
    private final String lwpsUsageCmd;
    private final String statusFile;
    private final String lwpDir;
    private final NativeProcessBuilder npb;

    public RemoteProcReader(ExecutionEnvironment executionEnvironment, int n, ByteOrder byteOrder, DataModel dataModel) {
        super(byteOrder, dataModel);
        this.usageFile = "/proc/" + n + "/usage";
        this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
        this.npb.setExecutable("cat");
        this.statusFile = "/proc/" + n + "/status";
        this.lwpDir = "/proc/" + n + "/lwp";
        this.lwpsUsageCmd = "cat " + this.lwpDir + "/*/lwpusage";
    }

    @Override
    public PStatus getProcessStatus() {
        PStatus pStatus = null;
        try {
            NativeProcess nativeProcess = this.npb.setArguments(new String[]{this.statusFile}).call();
            pStatus = this.getProcessStatus(nativeProcess.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pStatus;
    }

    @Override
    public PUsage getProcessUsage() throws IOException {
        NativeProcess nativeProcess = this.npb.setArguments(new String[]{this.usageFile}).call();
        return this.getProcessUsage(nativeProcess.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LWPUsage> getThreadsInfo() {
        ArrayList<LWPUsage> arrayList = new ArrayList<LWPUsage>();
        try {
            NativeProcess nativeProcess = this.npb.setCommandLine(this.lwpsUsageCmd).call();
            int n = -1;
            try {
                n = nativeProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n != 0) {
                Object object;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("cannot exec " + this.lwpsUsageCmd);
                    object = nativeProcess.getErrorStream();
                    if (((InputStream)object).available() > 0) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                        while (bufferedReader.ready()) {
                            log.fine("\t" + bufferedReader.readLine());
                        }
                    }
                }
                object = arrayList;
                return object;
            }
            InputStream inputStream = nativeProcess.getInputStream();
            MultyFilesStream multyFilesStream = new MultyFilesStream(inputStream, 256);
            try {
                while (multyFilesStream.available() > 0) {
                    arrayList.add(this.getProcessUsage(multyFilesStream));
                }
                return arrayList;
            }
            catch (IOException iOException) {
                return arrayList;
            }
            finally {
                multyFilesStream.doClose();
            }
        }
        catch (IOException iOException) {
            return arrayList;
        }
        finally {
            this.npb.setCommandLine(null);
        }
    }

    private static class MultyFilesStream
    extends FilterInputStream {
        private final int chunkSize;

        private MultyFilesStream(InputStream inputStream, int n) {
            super(inputStream);
            this.chunkSize = n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return super.read(byArray, n, Math.min(n2, this.chunkSize));
        }

        public void close() throws IOException {
        }

        public void doClose() throws IOException {
            super.close();
        }
    }
}

