/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DateType;
import org.netbeans.modules.db.dataview.util.TimeType;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DBReadWriteHelper {
    private static Logger mLogger = Logger.getLogger(DBReadWriteHelper.class.getName());

    public static Object readResultSet(ResultSet resultSet, DBColumn dBColumn, int n) throws SQLException {
        int n2 = dBColumn.getJdbcType();
        if (n2 == -7 && dBColumn.getPrecision() <= 1) {
            n2 = 16;
        }
        switch (n2) {
            case 16: {
                boolean bl = resultSet.getBoolean(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case 92: {
                Time time = resultSet.getTime(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return time;
            }
            case 91: {
                Date date = resultSet.getDate(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return date;
            }
            case -100: 
            case 93: {
                try {
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return timestamp;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("S1009")) {
                        return null;
                    }
                    throw sQLException;
                }
            }
            case -5: {
                long l = resultSet.getLong(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case 8: {
                double d = resultSet.getDouble(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 6: 
            case 7: {
                float f = resultSet.getFloat(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return bigDecimal;
            }
            case 4: {
                int n3 = resultSet.getInt(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Integer(n3);
            }
            case 5: {
                short s = resultSet.getShort(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Short(s);
            }
            case -6: {
                byte by = resultSet.getByte(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Byte(by);
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = resultSet.getString(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                return string;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = resultSet.getBytes(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                Byte[] byteArray = new Byte[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    byteArray[i] = new Byte(byArray[i]);
                }
                String string = BinaryToStringConverter.convertToString(byteArray, 2, true);
                if (n2 == -7 && dBColumn.getPrecision() != 0 && dBColumn.getPrecision() < string.length()) {
                    return string.substring(string.length() - dBColumn.getPrecision());
                }
                return string;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                byte[] byArray = null;
                if (blob != null) {
                    byArray = blob.getBytes(1L, Math.min((int)blob.length(), 2000));
                }
                Byte[] byteArray = new Byte[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    byteArray[i] = new Byte(byArray[i]);
                }
                return BinaryToStringConverter.convertToString(byteArray, 16, false);
            }
            case 2005: 
            case 2011: {
                Clob clob = resultSet.getClob(n);
                if (resultSet.wasNull()) {
                    return null;
                }
                if (clob == null) break;
                return clob.getSubString(1L, Math.min((int)clob.length(), 2000));
            }
        }
        return resultSet.getObject(n);
    }

    public static void setAttributeValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws DBException {
        Number number = null;
        try {
            if (object == null) {
                preparedStatement.setNull(n, n2);
                return;
            }
            if (n2 == -7 && object instanceof Boolean) {
                n2 = 16;
            }
            switch (n2) {
                case 8: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Double.valueOf(object.toString());
                    preparedStatement.setDouble(n, number.doubleValue());
                    break;
                }
                case 3: {
                    number = object instanceof Number ? (Number)object : new BigDecimal(object.toString());
                    preparedStatement.setDouble(n, number.doubleValue());
                    break;
                }
                case -5: 
                case 2: {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    preparedStatement.setBigDecimal(n, bigDecimal);
                    break;
                }
                case 6: 
                case 7: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Float.valueOf(object.toString());
                    preparedStatement.setFloat(n, number.floatValue());
                    break;
                }
                case 4: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Integer.valueOf(object.toString());
                    preparedStatement.setInt(n, number.intValue());
                    break;
                }
                case -6: 
                case 5: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Short.valueOf(object.toString());
                    preparedStatement.setShort(n, number.shortValue());
                    break;
                }
                case 93: {
                    preparedStatement.setTimestamp(n, TimestampType.convert(object));
                    break;
                }
                case 91: {
                    preparedStatement.setDate(n, DateType.convert(object));
                    break;
                }
                case 92: {
                    preparedStatement.setTime(n, TimeType.convert(object));
                    break;
                }
                case -7: {
                    preparedStatement.setBytes(n, BinaryToStringConverter.convertBitStringToBytes(object.toString()));
                    break;
                }
                case -3: 
                case -2: {
                    preparedStatement.setBytes(n, object.toString().getBytes());
                    break;
                }
                case -4: 
                case 2004: {
                    byte[] byArray = object.toString().getBytes();
                    preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    preparedStatement.setString(n, object.toString());
                    break;
                }
                case -1: 
                case 2005: 
                case 2011: {
                    String string = object.toString();
                    preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
                    break;
                }
                default: {
                    preparedStatement.setObject(n, object, n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, "Invalid Data for" + n2 + "type -- ", exception);
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_InvalidType", (Object)n2, (Object)exception));
        }
    }

    public static Object validate(Object object, DBColumn dBColumn) throws DBException {
        int n = dBColumn.getJdbcType();
        if (object == null) {
            return null;
        }
        if (n == -7 && dBColumn.getPrecision() <= 1) {
            n = 16;
        }
        try {
            switch (n) {
                case 16: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    String string = object.toString();
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                        return Boolean.TRUE;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
                        return Boolean.FALSE;
                    }
                    throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Boolean"));
                }
                case 93: {
                    return TimestampType.convert(object);
                }
                case 91: {
                    return DateType.convert(object);
                }
                case 92: {
                    return TimeType.convert(object);
                }
                case -5: {
                    return object instanceof Long ? object : new Long(object.toString());
                }
                case 8: {
                    return object instanceof Double ? object : new Double(object.toString());
                }
                case 6: 
                case 7: {
                    return object instanceof Float ? object : new Float(object.toString());
                }
                case 2: 
                case 3: {
                    return object instanceof BigDecimal ? object : new BigDecimal(object.toString());
                }
                case 4: {
                    return object instanceof Integer ? object : new Integer(object.toString());
                }
                case 5: {
                    return object instanceof Short ? object : new Short(object.toString());
                }
                case -6: {
                    return object instanceof Byte ? object : new Byte(object.toString());
                }
                case -15: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (dBColumn.getPrecision() > 0 && object.toString().length() > dBColumn.getPrecision()) {
                        String string = dBColumn.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)object, (Object)string));
                    }
                    return object;
                }
                case -7: {
                    if (object.toString().length() > dBColumn.getPrecision()) {
                        String string = dBColumn.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)object, (Object)string));
                    }
                    if (object.toString().trim().length() == 0) {
                        String string = dBColumn.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Invalid", (Object)object, (Object)string));
                    }
                    BinaryToStringConverter.convertBitStringToBytes(object.toString());
                    return object;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    char[] cArray = object.toString().toCharArray();
                    Byte[] byteArray = new Byte[cArray.length];
                    for (int i = 0; i < cArray.length; ++i) {
                        byteArray[i] = new Byte((byte)cArray[i]);
                    }
                    return BinaryToStringConverter.convertToString(byteArray, 2, true);
                }
            }
            return object;
        }
        catch (Exception exception) {
            String string = dBColumn.getTypeName();
            String string2 = dBColumn.getQualifiedName(false);
            int n2 = dBColumn.getPrecision();
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_ErrLog", (Object[])new Object[]{string2, string, n2, exception.getLocalizedMessage()}));
        }
    }

    public static boolean isNullString(String string) {
        return string == null || string.trim().length() == 0;
    }
}

