/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AutoTestSupport {
    private Project project;
    private Lookup context;
    private String charsetName;
    private String classPath;

    public AutoTestSupport(Lookup lookup, Project project, String string) {
        this.context = lookup;
        this.project = project;
        this.charsetName = string;
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public static boolean isInstalled(Project project, TestRunner.TestType testType) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (rubyPlatform == null) {
            return false;
        }
        if (testType == TestRunner.TestType.AUTOTEST) {
            return rubyPlatform.hasValidAutoTest(false);
        }
        if (testType == TestRunner.TestType.AUTOSPEC) {
            return rubyPlatform.hasValidAutoSpec(false);
        }
        return false;
    }

    public void start(TestRunner.TestType testType) {
        TestRunner testRunner = Util.getTestRunner(testType);
        if (testRunner != null) {
            testRunner.runAllTests(this.project, false);
            return;
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        if (!rubyPlatform.hasValidAutoTest(true)) {
            return;
        }
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String string = TestRunner.TestType.AUTOSPEC == testType ? rubyPlatform.getAutoSpec() : rubyPlatform.getAutoTest();
        String string2 = TestRunner.TestType.AUTOSPEC == testType ? "AutoSpec" : "AutoTest";
        RubyFileLocator rubyFileLocator = new RubyFileLocator(this.context, this.project);
        String string3 = NbBundle.getMessage(AutoTestSupport.class, (String)string2);
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string3, file, string);
        rubyExecutionDescriptor.additionalArgs(new String[]{"-v"});
        rubyExecutionDescriptor.fileLocator((LineConvertors.FileLocator)rubyFileLocator);
        rubyExecutionDescriptor.classPath(this.classPath);
        rubyExecutionDescriptor.showProgress(false);
        rubyExecutionDescriptor.addStandardRecognizers();
        TestNotifierLineConvertor testNotifierLineConvertor = new TestNotifierLineConvertor(false, false);
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)testNotifierLineConvertor);
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)testNotifierLineConvertor);
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.charsetName);
        ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string3).run();
    }
}

